/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchEntryParer
implements Serializable {
    private static final long serialVersionUID = -3249960583816464391L;
    private final boolean allOperationalAttributes;
    private final boolean allUserAttributes;
    @NotNull
    private final List<String> requestedAttributes;
    @NotNull
    private final Map<String, List<List<String>>> attributeTypesToReturn;
    @Nullable
    private final Schema schema;

    public SearchEntryParer(@NotNull List<String> requestedAttributes, @Nullable Schema schema) {
        this.schema = schema;
        this.requestedAttributes = Collections.unmodifiableList(new ArrayList<String>(requestedAttributes));
        if (requestedAttributes.isEmpty()) {
            this.allUserAttributes = true;
            this.allOperationalAttributes = false;
            this.attributeTypesToReturn = Collections.emptyMap();
            return;
        }
        boolean allUserAttrs = false;
        boolean allOpAttrs = false;
        HashMap<String, List<List<String>>> m = new HashMap<String, List<List<String>>>(StaticUtils.computeMapCapacity(requestedAttributes.size()));
        for (String s : requestedAttributes) {
            AttributeTypeDefinition at2;
            if (s.equals("*")) {
                allUserAttrs = true;
                continue;
            }
            if (s.equals("+")) {
                allOpAttrs = true;
                continue;
            }
            if (s.startsWith("@")) {
                String ocName;
                ObjectClassDefinition oc;
                if (schema == null || (oc = schema.getObjectClass(ocName = s.substring(1))) == null) continue;
                for (AttributeTypeDefinition at2 : oc.getRequiredAttributes(schema, true)) {
                    SearchEntryParer.addAttributeOIDAndNames(at2, m, Collections.emptyList(), schema);
                }
                for (AttributeTypeDefinition at2 : oc.getOptionalAttributes(schema, true)) {
                    SearchEntryParer.addAttributeOIDAndNames(at2, m, Collections.emptyList(), schema);
                }
                continue;
            }
            ObjectPair<String, List<String>> nameWithOptions = SearchEntryParer.getNameWithOptions(s);
            if (nameWithOptions == null) continue;
            String name = nameWithOptions.getFirst();
            List<String> options = nameWithOptions.getSecond();
            if (schema == null) {
                ArrayList<List<String>> optionLists = (ArrayList<List<String>>)m.get(name);
                if (optionLists == null) {
                    optionLists = new ArrayList<List<String>>(1);
                    m.put(name, optionLists);
                }
                optionLists.add(options);
                continue;
            }
            at2 = schema.getAttributeType(name);
            if (at2 == null) {
                ArrayList<List<String>> optionLists = (ArrayList<List<String>>)m.get(name);
                if (optionLists == null) {
                    optionLists = new ArrayList<List<String>>(1);
                    m.put(name, optionLists);
                }
                optionLists.add(options);
                continue;
            }
            SearchEntryParer.addAttributeOIDAndNames(at2, m, options, schema);
        }
        this.allUserAttributes = allUserAttrs;
        this.allOperationalAttributes = allOpAttrs;
        this.attributeTypesToReturn = Collections.unmodifiableMap(m);
    }

    @NotNull
    private static ObjectPair<String, List<String>> getNameWithOptions(@NotNull String s) {
        if (!Attribute.nameIsValid(s, true)) {
            return null;
        }
        String l = StaticUtils.toLowerCase(s);
        int semicolonPos = l.indexOf(59);
        if (semicolonPos < 0) {
            return new ObjectPair<String, List<String>>(l, Collections.emptyList());
        }
        String name = l.substring(0, semicolonPos);
        ArrayList<String> optionList = new ArrayList<String>(1);
        while (true) {
            int nextSemicolonPos;
            if ((nextSemicolonPos = l.indexOf(59, semicolonPos + 1)) < 0) break;
            optionList.add(l.substring(semicolonPos + 1, nextSemicolonPos));
            semicolonPos = nextSemicolonPos;
        }
        optionList.add(l.substring(semicolonPos + 1));
        return new ObjectPair<String, List<String>>(name, optionList);
    }

    private static void addAttributeOIDAndNames(@Nullable AttributeTypeDefinition d, @NotNull Map<String, List<List<String>>> m, @NotNull List<String> o, @Nullable Schema s) {
        if (d == null) {
            return;
        }
        String lowerOID = StaticUtils.toLowerCase(d.getOID());
        if (lowerOID != null) {
            List<List<String>> l = m.get(lowerOID);
            if (l == null) {
                l = new ArrayList<List<String>>(1);
                m.put(lowerOID, l);
            }
            l.add(o);
        }
        for (String name : d.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<List<String>> l = m.get(lowerName);
            if (l == null) {
                l = new ArrayList<List<String>>(1);
                m.put(lowerName, l);
            }
            l.add(o);
        }
        if (s != null) {
            for (AttributeTypeDefinition subordinateType : s.getSubordinateAttributeTypes(d)) {
                SearchEntryParer.addAttributeOIDAndNames(subordinateType, m, o, s);
            }
        }
    }

    @NotNull
    public List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    @NotNull
    public Entry pareEntry(@NotNull Entry entry) {
        if (this.allUserAttributes && (this.allOperationalAttributes || this.schema == null)) {
            return entry.duplicate();
        }
        Entry copy = new Entry(entry.getDN(), this.schema);
        block0: for (Attribute a : entry.getAttributes()) {
            AttributeTypeDefinition at;
            ObjectPair<String, List<String>> nameWithOptions = SearchEntryParer.getNameWithOptions(a.getName());
            String name = nameWithOptions.getFirst();
            List<String> options = nameWithOptions.getSecond();
            if (this.schema != null && (at = this.schema.getAttributeType(name)) != null && at.isOperational()) {
                if (this.allOperationalAttributes) {
                    copy.addAttribute(a);
                    continue;
                }
                List<List<String>> optionLists = this.attributeTypesToReturn.get(name);
                if (optionLists == null) continue;
                for (List<String> optionList : optionLists) {
                    boolean matchAll = true;
                    for (String option : optionList) {
                        if (options.contains(option)) continue;
                        matchAll = false;
                        break;
                    }
                    if (!matchAll) continue;
                    copy.addAttribute(a);
                    continue block0;
                }
                continue;
            }
            if (this.allUserAttributes) {
                copy.addAttribute(a);
                continue;
            }
            List<List<String>> optionLists = this.attributeTypesToReturn.get(name);
            if (optionLists == null) continue;
            for (List<String> optionList : optionLists) {
                boolean matchAll = true;
                for (String option : optionList) {
                    if (options.contains(option)) continue;
                    matchAll = false;
                    break;
                }
                if (!matchAll) continue;
                copy.addAttribute(a);
                continue block0;
            }
        }
        return copy;
    }
}

