/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class FieldFetcher {
    private final List<FieldContext> fieldContexts;

    public static FieldFetcher create(MapperService mapperService, SearchLookup searchLookup, Collection<FieldAndFormat> fieldAndFormats) {
        ArrayList<FieldContext> fieldContexts = new ArrayList<FieldContext>();
        for (FieldAndFormat fieldAndFormat : fieldAndFormats) {
            String fieldPattern = fieldAndFormat.field;
            String format = fieldAndFormat.format;
            Set<String> concreteFields = mapperService.simpleMatchToFullName(fieldPattern);
            for (String field : concreteFields) {
                MappedFieldType ft = mapperService.fieldType(field);
                if (ft == null || mapperService.isMetadataField(field)) continue;
                ValueFetcher valueFetcher = ft.valueFetcher(mapperService, searchLookup, format);
                fieldContexts.add(new FieldContext(field, valueFetcher));
            }
        }
        return new FieldFetcher(fieldContexts);
    }

    private FieldFetcher(List<FieldContext> fieldContexts) {
        this.fieldContexts = fieldContexts;
    }

    public Map<String, DocumentField> fetch(SourceLookup sourceLookup, Set<String> ignoredFields) throws IOException {
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        for (FieldContext context : this.fieldContexts) {
            ValueFetcher valueFetcher;
            List<Object> parsedValues;
            String field = context.fieldName;
            if (ignoredFields.contains(field) || (parsedValues = (valueFetcher = context.valueFetcher).fetchValues(sourceLookup)).isEmpty()) continue;
            documentFields.put(field, new DocumentField(field, parsedValues));
        }
        return documentFields;
    }

    public void setNextReader(LeafReaderContext readerContext) {
        for (FieldContext field : this.fieldContexts) {
            field.valueFetcher.setNextReader(readerContext);
        }
    }

    private static class FieldContext {
        final String fieldName;
        final ValueFetcher valueFetcher;

        FieldContext(String fieldName, ValueFetcher valueFetcher) {
            this.fieldName = fieldName;
            this.valueFetcher = valueFetcher;
        }
    }
}

