/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import reactor.core.publisher.Mono;

public class CassandraVacationDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final UserType zonedDateTimeUserType;
    private final BiFunction<VacationPatch, Insert, Insert> insertGeneratorPipeline;

    @Inject
    public CassandraVacationDAO(Session session, CassandraTypesProvider cassandraTypesProvider) {
        this.zonedDateTimeUserType = cassandraTypesProvider.getDefinedUserType("zonedDateTime");
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = session.prepare((RegularStatement)QueryBuilder.select().from("vacation").where(QueryBuilder.eq((String)"account_id", (Object)QueryBuilder.bindMarker((String)"account_id"))));
        this.insertGeneratorPipeline = ImmutableList.of(this.applyPatchForField("subject", VacationPatch::getSubject), this.applyPatchForField("html", VacationPatch::getHtmlBody), this.applyPatchForField("text", VacationPatch::getTextBody), this.applyPatchForField("is_enabled", VacationPatch::getIsEnabled), this.applyPatchForFieldZonedDateTime("from_date", VacationPatch::getFromDate), this.applyPatchForFieldZonedDateTime("to_date", VacationPatch::getToDate)).stream().reduce((vacation, insert) -> insert, (a, b) -> (vacation, insert) -> (Insert)b.apply(vacation, (Insert)a.apply(vacation, insert)));
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.createSpecificUpdate(vacationPatch, QueryBuilder.insertInto((String)"vacation").value("account_id", (Object)accountId.getIdentifier())));
    }

    public Mono<Optional<Vacation>> retrieveVacation(AccountId accountId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.readStatement.bind().setString("account_id", accountId.getIdentifier())).map(optional -> optional.map(row -> Vacation.builder().enabled(row.getBool("is_enabled")).fromDate(this.retrieveDate((Row)row, "from_date")).toDate(this.retrieveDate((Row)row, "to_date")).subject(Optional.ofNullable(row.getString("subject"))).textBody(Optional.ofNullable(row.getString("text"))).htmlBody(Optional.ofNullable(row.getString("html"))).build()));
    }

    private Optional<ZonedDateTime> retrieveDate(Row row, String dateField) {
        return CassandraZonedDateTimeModule.fromUDTOptional((UDTValue)row.getUDTValue(dateField));
    }

    private Insert createSpecificUpdate(VacationPatch vacationPatch, Insert baseInsert) {
        return this.insertGeneratorPipeline.apply(vacationPatch, baseInsert);
    }

    public <T> BiFunction<VacationPatch, Insert, Insert> applyPatchForField(String field, Function<VacationPatch, ValuePatch<T>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyPatchForField(field, (Optional)optionalValue, (Insert)insert)).orElse(insert);
    }

    public BiFunction<VacationPatch, Insert, Insert> applyPatchForFieldZonedDateTime(String field, Function<VacationPatch, ValuePatch<ZonedDateTime>> getter) {
        return (vacation, insert) -> ((ValuePatch)getter.apply((VacationPatch)vacation)).mapNotKeptToOptional(optionalValue -> this.applyPatchForField(field, CassandraZonedDateTimeModule.toUDT((UserType)this.zonedDateTimeUserType, (Optional)optionalValue), (Insert)insert)).orElse(insert);
    }

    private <T> Insert applyPatchForField(String field, Optional<T> value, Insert insert) {
        return insert.value(field, value.orElse(null));
    }
}

