/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoResp;
import org.apache.iotdb.db.exception.ainode.ModelNotFoundException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IModelFetcher;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.model.ModelInferenceDescriptor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;

public class ModelFetcher
implements IModelFetcher {
    private final IClientManager<ConfigRegionId, ConfigNodeClient> configNodeClientManager = ConfigNodeClientManager.getInstance();

    public static ModelFetcher getInstance() {
        return ModelFetcherHolder.INSTANCE;
    }

    private ModelFetcher() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TSStatus fetchModel(String modelName, Analysis analysis) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetModelInfoResp getModelInfoResp = client.getModelInfo(new TGetModelInfoReq(modelName));
            if (getModelInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) throw new ModelNotFoundException(getModelInfoResp.getStatus().getMessage());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        catch (ClientManagerException | TException e) {
            throw new StatementAnalyzeException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelInferenceDescriptor fetchModel(String modelName) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetModelInfoResp getModelInfoResp = client.getModelInfo(new TGetModelInfoReq(modelName));
            if (getModelInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) throw new ModelNotFoundException(getModelInfoResp.getStatus().getMessage());
            ModelInferenceDescriptor modelInferenceDescriptor = new ModelInferenceDescriptor(getModelInfoResp.aiNodeAddress);
            return modelInferenceDescriptor;
        }
        catch (ClientManagerException | TException e) {
            throw new IoTDBRuntimeException(String.format("fetch model [%s] info failed: %s", modelName, e.getMessage()), TSStatusCode.GET_MODEL_INFO_ERROR.getStatusCode());
        }
    }

    private static final class ModelFetcherHolder {
        private static final ModelFetcher INSTANCE = new ModelFetcher();

        private ModelFetcherHolder() {
        }
    }
}

