/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ratis.security.TlsConf;

public class GrpcTlsConfig
extends TlsConf {
    private final boolean fileBasedConfig;

    public boolean isFileBasedConfig() {
        return this.fileBasedConfig;
    }

    public PrivateKey getPrivateKey() {
        return Optional.ofNullable(this.getKeyManager()).map(TlsConf.KeyManagerConf::getPrivateKey).map(rec$ -> (PrivateKey)((TlsConf.PrivateKeyConf)rec$).get()).orElse(null);
    }

    public File getPrivateKeyFile() {
        return Optional.ofNullable(this.getKeyManager()).map(TlsConf.KeyManagerConf::getPrivateKey).map(rec$ -> ((TlsConf.PrivateKeyConf)rec$).getFile()).orElse(null);
    }

    public X509Certificate getCertChain() {
        return Optional.ofNullable(this.getKeyManager()).map(TlsConf.KeyManagerConf::getKeyCertificates).map(rec$ -> (Iterable)((TlsConf.CertificatesConf)rec$).get()).map(Iterable::iterator).map(Iterator::next).orElse(null);
    }

    public File getCertChainFile() {
        return Optional.ofNullable(this.getKeyManager()).map(TlsConf.KeyManagerConf::getKeyCertificates).map(rec$ -> ((TlsConf.CertificatesConf)rec$).getFile()).orElse(null);
    }

    public List<X509Certificate> getTrustStore() {
        return Optional.ofNullable(this.getTrustManager()).map(TlsConf.TrustManagerConf::getTrustCertificates).map(rec$ -> (Iterable)((TlsConf.CertificatesConf)rec$).get()).orElse(null);
    }

    public File getTrustStoreFile() {
        return Optional.ofNullable(this.getTrustManager()).map(TlsConf.TrustManagerConf::getTrustCertificates).map(rec$ -> ((TlsConf.CertificatesConf)rec$).getFile()).orElse(null);
    }

    public boolean getMtlsEnabled() {
        return this.isMutualTls();
    }

    public GrpcTlsConfig(PrivateKey privateKey, X509Certificate certChain, List<X509Certificate> trustStore, boolean mTlsEnabled) {
        this(GrpcTlsConfig.newBuilder(privateKey, certChain, trustStore, mTlsEnabled), false);
    }

    public GrpcTlsConfig(PrivateKey privateKey, X509Certificate certChain, X509Certificate trustStore, boolean mTlsEnabled) {
        this(privateKey, certChain, Collections.singletonList(trustStore), mTlsEnabled);
    }

    public GrpcTlsConfig(File privateKeyFile, File certChainFile, File trustStoreFile, boolean mTlsEnabled) {
        this(GrpcTlsConfig.newBuilder(privateKeyFile, certChainFile, trustStoreFile, mTlsEnabled), true);
    }

    private GrpcTlsConfig(TlsConf.Builder builder, boolean fileBasedConfig) {
        super(builder);
        this.fileBasedConfig = fileBasedConfig;
    }

    public GrpcTlsConfig(KeyManager keyManager, TrustManager trustManager, boolean mTlsEnabled) {
        this(GrpcTlsConfig.newBuilder(keyManager, trustManager, mTlsEnabled), false);
    }

    private static TlsConf.Builder newBuilder(PrivateKey privateKey, X509Certificate certChain, List<X509Certificate> trustStore, boolean mTlsEnabled) {
        TlsConf.Builder b = GrpcTlsConfig.newBuilder().setMutualTls(mTlsEnabled);
        Optional.ofNullable(trustStore).map(TlsConf.CertificatesConf::new).ifPresent(arg_0 -> ((TlsConf.Builder)b).setTrustCertificates(arg_0));
        Optional.ofNullable(privateKey).map(TlsConf.PrivateKeyConf::new).ifPresent(arg_0 -> ((TlsConf.Builder)b).setPrivateKey(arg_0));
        Optional.ofNullable(certChain).map(xva$0 -> new TlsConf.CertificatesConf(new X509Certificate[]{xva$0})).ifPresent(arg_0 -> ((TlsConf.Builder)b).setKeyCertificates(arg_0));
        return b;
    }

    private static TlsConf.Builder newBuilder(File privateKeyFile, File certChainFile, File trustStoreFile, boolean mTlsEnabled) {
        TlsConf.Builder b = GrpcTlsConfig.newBuilder().setMutualTls(mTlsEnabled);
        Optional.ofNullable(trustStoreFile).map(TlsConf.CertificatesConf::new).ifPresent(arg_0 -> ((TlsConf.Builder)b).setTrustCertificates(arg_0));
        Optional.ofNullable(privateKeyFile).map(TlsConf.PrivateKeyConf::new).ifPresent(arg_0 -> ((TlsConf.Builder)b).setPrivateKey(arg_0));
        Optional.ofNullable(certChainFile).map(TlsConf.CertificatesConf::new).ifPresent(arg_0 -> ((TlsConf.Builder)b).setKeyCertificates(arg_0));
        return b;
    }

    private static TlsConf.Builder newBuilder(KeyManager keyManager, TrustManager trustManager, boolean mTlsEnabled) {
        return GrpcTlsConfig.newBuilder().setMutualTls(mTlsEnabled).setKeyManager(keyManager).setTrustManager(trustManager);
    }
}

