/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.jetbrains.annotations.Nullable;

public class ReplicaTxFinishMarker {
    private final TxManager txManager;

    public ReplicaTxFinishMarker(TxManager txManager) {
        this.txManager = txManager;
    }

    public void markFinished(UUID txId, TxState txState, @Nullable HybridTimestamp commitTimestamp) {
        assert (TxState.isFinalState((TxState)txState)) : "Unexpected state [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf(txState) + "]";
        this.txManager.updateTxMeta(txId, old -> new TxStateMeta(txState, old == null ? null : old.txCoordinatorId(), old == null ? null : old.commitPartitionId(), (HybridTimestamp)(txState == TxState.COMMITTED ? commitTimestamp : null), old == null ? null : old.tx(), old == null ? null : old.initialVacuumObservationTimestamp(), old == null ? null : old.cleanupCompletionTimestamp(), old == null ? null : old.isFinishedDueToTimeout()));
    }
}

