/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.Set;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.SqlProperties;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

public final class ValidationHelper {
    public static void validateParsedStatement(SqlProperties properties, ParsedResult parsedResult) {
        Set allowedTypes = properties.allowedQueryTypes();
        SqlQueryType queryType = parsedResult.queryType();
        if (!parsedResult.queryType().supportsIndependentExecution()) {
            String message = queryType.displayName() + " can not be executed as an independent statement.";
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, message);
        }
        ValidationHelper.validateQueryType(allowedTypes, queryType);
    }

    public static void validateDynamicParameters(int expectedParamsCount, Object[] params, boolean exactMatch) throws SqlException {
        if (exactMatch && expectedParamsCount != params.length || params.length > expectedParamsCount) {
            String message = IgniteStringFormatter.format((String)"Unexpected number of query parameters. Provided {} but there is only {} dynamic parameter(s).", (Object[])new Object[]{params.length, expectedParamsCount});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, message);
        }
        for (Object param : params) {
            if (TypeUtils.supportParamInstance(param)) continue;
            String message = IgniteStringFormatter.format((String)"Unsupported dynamic parameter defined. Provided '{}' is not supported.", (Object[])new Object[]{param.getClass().getName()});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, message);
        }
    }

    static void validateQueryType(Set<SqlQueryType> allowedTypes, SqlQueryType queryType) {
        if (!allowedTypes.contains(queryType)) {
            String message = IgniteStringFormatter.format((String)"Invalid SQL statement type. Expected {} but got {}.", (Object[])new Object[]{allowedTypes, queryType});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, message);
        }
    }
}

