/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.deployment;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.multipart.FileUpload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.IgniteDeployment;
import org.apache.ignite.internal.deployunit.InitialDeployMode;
import org.apache.ignite.internal.deployunit.NodesToDeploy;
import org.apache.ignite.internal.deployunit.UnitStatuses;
import org.apache.ignite.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite.internal.deployunit.tempstorage.TempStorageProvider;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.deployment.DeploymentCodeApi;
import org.apache.ignite.internal.rest.api.deployment.DeploymentStatus;
import org.apache.ignite.internal.rest.api.deployment.UnitStatus;
import org.apache.ignite.internal.rest.api.deployment.UnitVersionStatus;
import org.apache.ignite.internal.rest.deployment.CompletedFileUploadSubscriber;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

@Controller(value="/management/v1/deployment")
public class DeploymentManagementController
implements DeploymentCodeApi,
ResourceHolder {
    private static final IgniteLogger LOG = Loggers.forClass(DeploymentManagementController.class);
    private IgniteDeployment deployment;
    private TempStorageProvider tempStorageProvider;

    public DeploymentManagementController(IgniteDeployment deployment, TempStorageProvider tempStorageProvider) {
        this.deployment = deployment;
        this.tempStorageProvider = tempStorageProvider;
    }

    public CompletableFuture<Boolean> deploy(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<org.apache.ignite.internal.rest.api.deployment.InitialDeployMode> deployMode, Optional<List<String>> initialNodes) {
        return this.doDeploy(unitId, unitVersion, unitContent, deployMode, initialNodes, false);
    }

    public CompletableFuture<Boolean> deployZip(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<org.apache.ignite.internal.rest.api.deployment.InitialDeployMode> deployMode, Optional<List<String>> initialNodes) {
        return this.doDeploy(unitId, unitVersion, unitContent, deployMode, initialNodes, true);
    }

    private CompletableFuture<Boolean> doDeploy(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<org.apache.ignite.internal.rest.api.deployment.InitialDeployMode> deployMode, Optional<List<String>> initialNodes, boolean zip) {
        TempStorage tempStorage;
        Version version;
        try {
            version = Version.parseVersion((String)unitVersion);
            tempStorage = this.tempStorageProvider.tempStorage(unitId, version);
        }
        catch (Exception e) {
            return Mono.from(unitContent).doOnNext(FileUpload::discard).toFuture().thenCompose(unused -> CompletableFuture.failedFuture(e));
        }
        CompletedFileUploadSubscriber subscriber = new CompletedFileUploadSubscriber(tempStorage, zip);
        unitContent.subscribe((Subscriber)subscriber);
        NodesToDeploy nodesToDeploy = initialNodes.map(NodesToDeploy::new).orElseGet(() -> new NodesToDeploy(DeploymentManagementController.fromInitialDeployMode(deployMode)));
        return subscriber.result().thenCompose(deploymentUnit -> this.deployment.deployAsync(unitId, version, deploymentUnit, nodesToDeploy).whenComplete((unitStatus, throwable) -> {
            tempStorage.close();
            try {
                deploymentUnit.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close subscriber", (Throwable)e);
            }
        }));
    }

    public CompletableFuture<Boolean> undeploy(String unitId, String unitVersion) {
        return this.deployment.undeployAsync(unitId, Version.parseVersion((String)unitVersion));
    }

    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(Optional<List<DeploymentStatus>> statuses) {
        return this.deployment.clusterStatusesAsync().thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(String unitId, Optional<String> version, Optional<List<DeploymentStatus>> statuses) {
        return this.clusterStatuses(unitId, version).thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    private CompletableFuture<List<UnitStatuses>> clusterStatuses(String unitId, Optional<String> version) {
        if (version.isPresent()) {
            Version parsedVersion = Version.parseVersion((String)version.get());
            return this.deployment.clusterStatusAsync(unitId, parsedVersion).thenApply(deploymentStatus -> {
                if (deploymentStatus != null) {
                    return List.of(UnitStatuses.builder((String)unitId).append(parsedVersion, deploymentStatus).build());
                }
                return List.of();
            });
        }
        return this.deployment.clusterStatusesAsync(unitId).thenApply(unitStatuses -> unitStatuses != null ? List.of(unitStatuses) : List.of());
    }

    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(Optional<List<DeploymentStatus>> statuses) {
        return this.deployment.nodeStatusesAsync().thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(String unitId, Optional<String> version, Optional<List<DeploymentStatus>> statuses) {
        return this.nodeStatuses(unitId, version).thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    private CompletableFuture<List<UnitStatuses>> nodeStatuses(String unitId, Optional<String> version) {
        if (version.isPresent()) {
            Version parsedVersion = Version.parseVersion((String)version.get());
            return this.deployment.nodeStatusAsync(unitId, parsedVersion).thenApply(deploymentStatus -> {
                if (deploymentStatus != null) {
                    return List.of(UnitStatuses.builder((String)unitId).append(parsedVersion, deploymentStatus).build());
                }
                return List.of();
            });
        }
        return this.deployment.nodeStatusesAsync(unitId).thenApply(unitStatuses -> unitStatuses != null ? List.of(unitStatuses) : List.of());
    }

    private static List<UnitStatus> fromUnitStatuses(List<UnitStatuses> statusesList, Optional<List<DeploymentStatus>> deploymentStatuses) {
        return statusesList.stream().map(unitStatuses -> DeploymentManagementController.fromUnitStatuses(unitStatuses, DeploymentManagementController.createStatusFilter(deploymentStatuses))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static UnitStatus fromUnitStatuses(UnitStatuses statuses, Predicate<DeploymentStatus> statusFilter) {
        ArrayList<UnitVersionStatus> versionStatuses = new ArrayList<UnitVersionStatus>();
        for (org.apache.ignite.internal.deployunit.UnitVersionStatus versionStatus : statuses.versionStatuses()) {
            DeploymentStatus deploymentStatus = DeploymentManagementController.fromDeploymentStatus(versionStatus.getStatus());
            if (!statusFilter.test(deploymentStatus)) continue;
            versionStatuses.add(new UnitVersionStatus(versionStatus.getVersion().render(), deploymentStatus));
        }
        if (versionStatuses.isEmpty()) {
            return null;
        }
        return new UnitStatus(statuses.id(), versionStatuses);
    }

    private static Predicate<DeploymentStatus> createStatusFilter(Optional<List<DeploymentStatus>> statuses) {
        if (statuses.isEmpty() || statuses.get().isEmpty()) {
            return status -> true;
        }
        EnumSet statusesSet = EnumSet.copyOf(statuses.get());
        return statusesSet::contains;
    }

    private static InitialDeployMode fromInitialDeployMode(Optional<org.apache.ignite.internal.rest.api.deployment.InitialDeployMode> mode) {
        if (mode.isEmpty()) {
            return InitialDeployMode.MAJORITY;
        }
        switch (mode.get()) {
            case ALL: {
                return InitialDeployMode.ALL;
            }
        }
        return InitialDeployMode.MAJORITY;
    }

    private static DeploymentStatus fromDeploymentStatus(org.apache.ignite.internal.deployunit.DeploymentStatus status) {
        return DeploymentStatus.valueOf((String)status.name());
    }

    public void cleanResources() {
        this.deployment = null;
        this.tempStorageProvider = null;
    }
}

