/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class VersionedUpdateSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    public static class VersionedUpdateSerializerV2
    implements CatalogObjectSerializer<VersionedUpdate> {
        @Override
        public VersionedUpdate readFrom(CatalogObjectDataInput input) throws IOException {
            int ver = input.readVarIntAsInt();
            long delayDurationMs = input.readVarInt();
            List<UpdateEntry> entries = input.readEntryList(UpdateEntry.class);
            return new VersionedUpdate(ver, delayDurationMs, entries);
        }

        @Override
        public void writeTo(VersionedUpdate value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.version());
            output.writeVarInt(value.delayDurationMs());
            output.writeEntryList(value.entries());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    public static class VersionedUpdateSerializerV1
    implements CatalogObjectSerializer<VersionedUpdate> {
        private final CatalogEntrySerializerProvider serializers;

        public VersionedUpdateSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public VersionedUpdate readFrom(CatalogObjectDataInput input) throws IOException {
            int ver = input.readVarIntAsInt();
            long delayDurationMs = input.readVarInt();
            int size = input.readVarIntAsInt();
            ArrayList<UpdateEntry> entries = new ArrayList<UpdateEntry>(size);
            for (int i = 0; i < size; ++i) {
                short entryTypeId = (short)input.readVarIntAsInt();
                CatalogObjectSerializer serializer = this.serializers.get(1, entryTypeId);
                entries.add((UpdateEntry)serializer.readFrom(input));
            }
            return new VersionedUpdate(ver, delayDurationMs, entries);
        }

        @Override
        public void writeTo(VersionedUpdate update, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(update.version());
            output.writeVarInt(update.delayDurationMs());
            output.writeVarInt(update.entries().size());
            for (UpdateEntry entry : update.entries()) {
                output.writeVarInt(entry.typeId());
                this.serializers.get(1, entry.typeId()).writeTo(entry, output);
            }
        }
    }
}

