/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.MarshallerWriter;

public class ClientMarshallerWriter
implements MarshallerWriter {
    private final BinaryTupleBuilder packer;
    private final BitSet noValueSet;

    public ClientMarshallerWriter(BinaryTupleBuilder packer, BitSet noValueSet) {
        this.packer = packer;
        this.noValueSet = noValueSet;
    }

    @Override
    public void writeNull() {
        this.packer.appendNull();
    }

    @Override
    public void writeAbsentValue() {
        this.noValueSet.set(this.packer.elementIndex());
        this.packer.appendNull();
    }

    @Override
    public void writeBoolean(boolean val) {
        this.packer.appendBoolean(val);
    }

    @Override
    public void writeByte(byte val) {
        this.packer.appendByte(val);
    }

    @Override
    public void writeShort(short val) {
        this.packer.appendShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.packer.appendInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.packer.appendLong(val);
    }

    @Override
    public void writeFloat(float val) {
        this.packer.appendFloat(val);
    }

    @Override
    public void writeDouble(double val) {
        this.packer.appendDouble(val);
    }

    @Override
    public void writeString(String val) {
        this.packer.appendString(val);
    }

    @Override
    public void writeUuid(UUID val) {
        this.packer.appendUuid(val);
    }

    @Override
    public void writeBytes(byte[] val) {
        this.packer.appendBytes(val);
    }

    @Override
    public void writeBigDecimal(BigDecimal val, int scale) {
        this.packer.appendDecimal(val, scale);
    }

    @Override
    public void writeDate(LocalDate val) {
        this.packer.appendDate(val);
    }

    @Override
    public void writeTime(LocalTime val) {
        this.packer.appendTime(val);
    }

    @Override
    public void writeTimestamp(Instant val) {
        this.packer.appendTimestamp(val);
    }

    @Override
    public void writeDateTime(LocalDateTime val) {
        this.packer.appendDateTime(val);
    }
}

