/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.future.timeout;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.shaded.org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.shaded.org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.shaded.org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.shaded.org.apache.ignite.internal.future.timeout.TimeoutObject;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class TimeoutWorker
extends IgniteWorker {
    private final long sleepInterval = TimeoutWorker.getSleepInterval();
    public final ConcurrentMap<Long, TimeoutObject<?>> requestsMap;
    @Nullable
    private final FailureProcessor failureProcessor;

    public TimeoutWorker(IgniteLogger log, String igniteInstanceName, String name, ConcurrentMap requestsMap, @Nullable FailureProcessor failureProcessor) {
        super(log, igniteInstanceName, name);
        this.requestsMap = requestsMap;
        this.failureProcessor = failureProcessor;
    }

    @Override
    protected void body() {
        try {
            while (!this.isCancelled()) {
                long now = FastTimestamps.coarseCurrentTimeMillis();
                for (Map.Entry entry : this.requestsMap.entrySet()) {
                    Object fut;
                    this.updateHeartbeat();
                    TimeoutObject timeoutObject = (TimeoutObject)entry.getValue();
                    assert (timeoutObject != null) : "Unexpected null in timeout operation map.";
                    if (timeoutObject.endTime() <= 0L || now <= timeoutObject.endTime() || ((CompletableFuture)(fut = timeoutObject.future())).isDone()) continue;
                    ((CompletableFuture)fut).completeExceptionally(new TimeoutException(timeoutObject.describe()));
                    this.requestsMap.remove(entry.getKey(), timeoutObject);
                }
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException e) {
                    this.log.info("The timeout worker was interrupted, probably the worker is stopping.", new Object[0]);
                }
                this.updateHeartbeat();
            }
        }
        catch (Throwable t) {
            if (this.failureProcessor != null) {
                this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            }
            this.log.error("Timeout worker failed and can't process the timeouts any longer [worker={}].", t, this.name());
        }
    }

    public static long getSleepInterval() {
        return IgniteSystemProperties.getLong("IGNITE_TIMEOUT_WORKER_SLEEP_INTERVAL", 500L);
    }
}

