/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteLimit;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class IgniteMdRowCount
extends RelMdRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (MetadataHandler)new IgniteMdRowCount());

    public Double getRowCount(Join rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Sort rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    @Nullable
    public static Double joinRowCount(RelMetadataQuery mq, Join rel) {
        Double max;
        if (!rel.getJoinType().projectsRight()) {
            RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode((RelMetadataQuery)mq, (Join)rel);
            return NumberUtil.multiply((Double)mq.getSelectivity(rel.getLeft(), semiJoinSelectivity), (Double)mq.getRowCount(rel.getLeft()));
        }
        Double left = mq.getRowCount(rel.getLeft());
        Double right = mq.getRowCount(rel.getRight());
        if (left == null || right == null) {
            return null;
        }
        if ((left <= 1.0 || right <= 1.0) && (max = mq.getMaxRowCount((RelNode)rel)) != null && max <= 1.0) {
            return max;
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        ImmutableIntList leftKeys = joinInfo.leftKeys;
        ImmutableIntList rightKeys = joinInfo.rightKeys;
        double selectivity = mq.getSelectivity((RelNode)rel, rel.getCondition());
        if (F.isEmpty((Collection)leftKeys) || F.isEmpty((Collection)rightKeys)) {
            return left * right * selectivity;
        }
        double leftDistinct = (Double)Util.first((Object)mq.getDistinctRowCount(rel.getLeft(), ImmutableBitSet.of((ImmutableIntList)leftKeys), null), (Object)left);
        double rightDistinct = (Double)Util.first((Object)mq.getDistinctRowCount(rel.getRight(), ImmutableBitSet.of((ImmutableIntList)rightKeys), null), (Object)right);
        double leftCardinality = leftDistinct / left;
        double rightCardinality = rightDistinct / right;
        double rowsCnt = Math.min(left, right) / (leftCardinality * rightCardinality) * selectivity;
        JoinRelType type = rel.getJoinType();
        if (type == JoinRelType.LEFT) {
            rowsCnt += left.doubleValue();
        } else if (type == JoinRelType.RIGHT) {
            rowsCnt += right.doubleValue();
        } else if (type == JoinRelType.FULL) {
            rowsCnt += left + right;
        }
        return rowsCnt;
    }

    public double getRowCount(IgniteSortedIndexSpool rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Intersect rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Minus rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public double getRowCount(IgniteAggregate rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public double getRowCount(IgniteLimit rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }
}

