/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class CacheConsistencyViolationEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private final Map<Object, EntriesInfo> entries;
    private final Map<Object, Object> repaired;
    private final String cacheName;
    private final ReadRepairStrategy strategy;

    public CacheConsistencyViolationEvent(String cacheName, ClusterNode node, String msg, Map<Object, EntriesInfo> entries, Map<Object, Object> repaired, ReadRepairStrategy strategy) {
        super(node, msg, 135);
        this.cacheName = cacheName;
        this.entries = Collections.unmodifiableMap(entries);
        this.repaired = Collections.unmodifiableMap(repaired);
        this.strategy = strategy;
    }

    public Map<Object, EntriesInfo> getEntries() {
        return this.entries;
    }

    public Map<Object, Object> getRepairedEntries() {
        return this.repaired;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ReadRepairStrategy getStrategy() {
        return this.strategy;
    }

    public static interface EntryInfo {
        public Object getValue();

        public CacheEntryVersion getVersion();

        public boolean isPrimary();

        public boolean isCorrect();
    }

    public static interface EntriesInfo {
        public Map<ClusterNode, EntryInfo> getMapping();

        public int partition();
    }
}

