/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class CollocatedSetItemKey
implements SetItemKey {
    private IgniteUuid setId;
    @GridToStringInclude(sensitive=true)
    private Object item;
    @AffinityKeyMapped
    private int setNameHash;

    public CollocatedSetItemKey(String setName, IgniteUuid setId, Object item) {
        this.setNameHash = setName.hashCode();
        this.setId = setId;
        this.item = item;
    }

    @Override
    public IgniteUuid setId() {
        return this.setId;
    }

    @Override
    public Object item() {
        return this.item;
    }

    public int hashCode() {
        int res = this.setId.hashCode();
        res = 31 * res + this.item.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollocatedSetItemKey that = (CollocatedSetItemKey)o;
        return this.setId.equals(that.setId) && this.item.equals(that.item);
    }

    public String toString() {
        return S.toString(CollocatedSetItemKey.class, this);
    }
}

