/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class SharedContentChangeLinkExpiryDetails {
    protected final Date newValue;
    protected final Date previousValue;

    public SharedContentChangeLinkExpiryDetails(Date newValue, Date previousValue) {
        this.newValue = LangUtil.truncateMillis(newValue);
        this.previousValue = LangUtil.truncateMillis(previousValue);
    }

    public SharedContentChangeLinkExpiryDetails() {
        this(null, null);
    }

    public Date getNewValue() {
        return this.newValue;
    }

    public Date getPreviousValue() {
        return this.previousValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.newValue, this.previousValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentChangeLinkExpiryDetails other = (SharedContentChangeLinkExpiryDetails)obj;
            return (this.newValue == other.newValue || this.newValue != null && this.newValue.equals(other.newValue)) && (this.previousValue == other.previousValue || this.previousValue != null && this.previousValue.equals(other.previousValue));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedContentChangeLinkExpiryDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedContentChangeLinkExpiryDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.newValue != null) {
                g.writeFieldName("new_value");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.newValue, g);
            }
            if (value.previousValue != null) {
                g.writeFieldName("previous_value");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.previousValue, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedContentChangeLinkExpiryDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_previousValue;
            Date f_newValue;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newValue = null;
                f_previousValue = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_value".equals(field)) {
                        f_newValue = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("previous_value".equals(field)) {
                        f_previousValue = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentChangeLinkExpiryDetails value = new SharedContentChangeLinkExpiryDetails(f_newValue, f_previousValue);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected Date newValue = null;
        protected Date previousValue = null;

        protected Builder() {
        }

        public Builder withNewValue(Date newValue) {
            this.newValue = LangUtil.truncateMillis(newValue);
            return this;
        }

        public Builder withPreviousValue(Date previousValue) {
            this.previousValue = LangUtil.truncateMillis(previousValue);
            return this;
        }

        public SharedContentChangeLinkExpiryDetails build() {
            return new SharedContentChangeLinkExpiryDetails(this.newValue, this.previousValue);
        }
    }
}

