/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class PaperFolderCreateArg {
    protected final String name;
    protected final String parentFolderId;
    protected final Boolean isTeamFolder;

    public PaperFolderCreateArg(String name, String parentFolderId, Boolean isTeamFolder) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        this.parentFolderId = parentFolderId;
        this.isTeamFolder = isTeamFolder;
    }

    public PaperFolderCreateArg(String name) {
        this(name, null, null);
    }

    public String getName() {
        return this.name;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public Boolean getIsTeamFolder() {
        return this.isTeamFolder;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.parentFolderId, this.isTeamFolder});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperFolderCreateArg other = (PaperFolderCreateArg)obj;
            return (this.name == other.name || this.name.equals(other.name)) && (this.parentFolderId == other.parentFolderId || this.parentFolderId != null && this.parentFolderId.equals(other.parentFolderId)) && (this.isTeamFolder == other.isTeamFolder || this.isTeamFolder != null && this.isTeamFolder.equals(other.isTeamFolder));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperFolderCreateArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperFolderCreateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            if (value.parentFolderId != null) {
                g.writeFieldName("parent_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentFolderId, g);
            }
            if (value.isTeamFolder != null) {
                g.writeFieldName("is_team_folder");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isTeamFolder, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperFolderCreateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isTeamFolder;
            String f_parentFolderId;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_parentFolderId = null;
                f_isTeamFolder = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("parent_folder_id".equals(field)) {
                        f_parentFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_team_folder".equals(field)) {
                        f_isTeamFolder = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperFolderCreateArg value = new PaperFolderCreateArg(f_name, f_parentFolderId, f_isTeamFolder);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String name;
        protected String parentFolderId;
        protected Boolean isTeamFolder;

        protected Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            this.parentFolderId = null;
            this.isTeamFolder = null;
        }

        public Builder withParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public Builder withIsTeamFolder(Boolean isTeamFolder) {
            this.isTeamFolder = isTeamFolder;
            return this;
        }

        public PaperFolderCreateArg build() {
            return new PaperFolderCreateArg(this.name, this.parentFolderId, this.isTeamFolder);
        }
    }
}

