/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.environment.LifecycleEnvironmentDialog;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.project.ProjectDialog;
import org.apache.hop.projects.util.ProjectsUtil;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.vfs.HopVfsFileDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.dialog.PipelineExecutionConfigurationDialog;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engines.local.LocalWorkflowRunConfiguration;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

@GuiPlugin
public class ProjectsGuiPlugin {
    public static final Class<?> PKG = ProjectsGuiPlugin.class;
    public static final String ID_TOOLBAR_PROJECT_LABEL = "toolbar-40000-project-label";
    public static final String ID_TOOLBAR_PROJECT_COMBO = "toolbar-40010-project-list";
    public static final String ID_TOOLBAR_PROJECT_EDIT = "toolbar-40020-project-edit";
    public static final String ID_TOOLBAR_PROJECT_ADD = "toolbar-40030-project-add";
    public static final String ID_TOOLBAR_PROJECT_DELETE = "toolbar-40040-project-delete";
    public static final String ID_TOOLBAR_ENVIRONMENT_LABEL = "toolbar-50000-environment-label";
    public static final String ID_TOOLBAR_ENVIRONMENT_COMBO = "toolbar-50010-environment-list";
    public static final String ID_TOOLBAR_ENVIRONMENT_EDIT = "toolbar-50020-environment-edit";
    public static final String ID_TOOLBAR_ENVIRONMENT_ADD = "toolbar-50030-environment-add";
    public static final String ID_TOOLBAR_ENVIRONMENT_DELETE = "toolbar-50040-environment-delete";
    public static final String ID_MAIN_MENU_PROJECT_EXPORT = "10055-menu-file-export-to-svg";
    public static final String NAVIGATE_TOOLBAR_PARENT_ID = "HopVfsFileDialog-NavigateToolbar";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_PROJECT_HOME = "0005-navigate-project-home";

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-40000-project-label", type=GuiToolbarElementType.LABEL, label="i18n::HopGui.Toolbar.Project.Label", toolTip="i18n::HopGui.Toolbar.Project.Tooltip", separator=true)
    public void editProject() {
        String projectName;
        HopGui hopGui = HopGui.getInstance();
        Combo combo = ProjectsGuiPlugin.getProjectsCombo();
        if (combo == null) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName = combo.getText());
        if (projectConfig == null) {
            return;
        }
        try {
            Project project = projectConfig.loadProject(hopGui.getVariables());
            ProjectDialog projectDialog = new ProjectDialog(hopGui.getShell(), project, projectConfig, hopGui.getVariables(), true);
            if (projectDialog.open() != null) {
                config.addProjectConfig(projectConfig);
                if (!projectName.equals(projectConfig.getProjectName())) {
                    projectName = projectConfig.getProjectName();
                    HopConfig.getInstance().saveToFile();
                }
                project.saveToFile();
                ProjectsGuiPlugin.refreshProjectsList();
                ProjectsGuiPlugin.selectProjectInList(projectName);
                if (projectDialog.isNeedingProjectRefresh()) {
                    if (this.askAboutProjectRefresh(hopGui)) {
                        LifecycleEnvironment environment = null;
                        Combo environmentsCombo = ProjectsGuiPlugin.getEnvironmentsCombo();
                        if (environmentsCombo != null) {
                            environment = config.findEnvironment(environmentsCombo.getText());
                        }
                        ProjectsGuiPlugin.enableHopGuiProject(projectConfig.getProjectName(), project, environment);
                    }
                    hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.ProjectUpdated.name()});
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    private boolean askAboutProjectRefresh(HopGui hopGui) {
        MessageBox box = new MessageBox(hopGui.getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ReloadProject.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ReloadProject.Dialog.Message", (String[])new String[0]));
        int answer = box.open();
        return (answer & 0x40) != 0;
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-40010-project-list", type=GuiToolbarElementType.COMBO, comboValuesMethod="getProjectsList", extraWidth=200, toolTip="i18n::HopGui.Toolbar.ProjectsList.Tooltip")
    public void selectProject() {
        List<LifecycleEnvironment> environments;
        HopGui hopGui = HopGui.getInstance();
        Combo combo = ProjectsGuiPlugin.getProjectsCombo();
        if (combo == null) {
            return;
        }
        String projectName = combo.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        LifecycleEnvironment environment = null;
        try {
            List environmentAuditEvents = AuditManager.findEvents((String)"projects", (String)"environment", (String)"open", (int)100, (boolean)true);
            for (AuditEvent auditEvent : environmentAuditEvents) {
                String environmentName = auditEvent.getName();
                if (!StringUtils.isNotEmpty((String)environmentName) || (environment = config.findEnvironment(environmentName)) == null) continue;
                if (!projectName.equals(environment.getProjectName())) {
                    environment = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error reading the last used environment from the audit logs", (Throwable)e);
        }
        if (environment == null && !(environments = config.findEnvironmentsOfProject(projectName)).isEmpty()) {
            environment = environments.get(0);
        }
        try {
            Project project = projectConfig.loadProject(hopGui.getVariables());
            if (project != null) {
                ProjectsGuiPlugin.enableHopGuiProject(projectName, project, environment);
            } else {
                hopGui.getLog().logError("Unable to find project '" + projectName + "'");
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-40020-project-edit", toolTip="i18n::HopGui.Toolbar.Project.Edit.Tooltip", image="project-edit.svg")
    public void editSelectedProject() {
        this.editProject();
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-40030-project-add", toolTip="i18n::HopGui.Toolbar.Project.Add.Tooltip", image="project-add.svg")
    public void addNewProject() {
        HopGui hopGui = HopGui.getInstance();
        IVariables variables = hopGui.getVariables();
        try {
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            String standardProjectsFolder = variables.resolve(config.getStandardProjectsFolder());
            String defaultProjectConfigFilename = variables.resolve(config.getDefaultProjectConfigFile());
            ProjectConfig projectConfig = new ProjectConfig("", standardProjectsFolder, defaultProjectConfigFilename);
            Project project = new Project();
            project.setParentProjectName(config.getStandardParentProject());
            ProjectDialog projectDialog = new ProjectDialog(hopGui.getShell(), project, projectConfig, variables, false);
            String projectName = projectDialog.open();
            if (projectName != null) {
                MessageBox box;
                config.addProjectConfig(projectConfig);
                HopConfig.getInstance().saveToFile();
                FileObject configFile = HopVfs.getFileObject((String)projectConfig.getActualProjectConfigFilename(variables));
                if (!configFile.exists()) {
                    project.saveToFile();
                } else {
                    MessageBox box2 = new MessageBox(hopGui.getShell(), 36);
                    box2.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ProjectExists.Dialog.Header", (String[])new String[0]));
                    box2.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ProjectExists.Dialog.Message", (String[])new String[0]));
                    box2.open();
                    project.readFromFile();
                }
                ProjectsGuiPlugin.refreshProjectsList();
                ProjectsGuiPlugin.selectProjectInList(projectName);
                ProjectsGuiPlugin.enableHopGuiProject(projectName, project, null);
                IHopMetadataSerializer prcSerializer = hopGui.getMetadataProvider().getSerializer(PipelineRunConfiguration.class);
                List pipelineRunConfigs = prcSerializer.loadAll();
                boolean localFound = false;
                for (PipelineRunConfiguration pipelineRunConfig : pipelineRunConfigs) {
                    if (!(pipelineRunConfig.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) continue;
                    localFound = true;
                }
                if (!localFound) {
                    PipelineExecutionConfigurationDialog.createLocalPipelineConfiguration((Shell)hopGui.getShell(), (IHopMetadataSerializer)prcSerializer);
                }
                IHopMetadataSerializer wrcSerializer = hopGui.getMetadataProvider().getSerializer(WorkflowRunConfiguration.class);
                localFound = false;
                List workflowRunConfigs = wrcSerializer.loadAll();
                for (WorkflowRunConfiguration workflowRunConfig : workflowRunConfigs) {
                    if (!(workflowRunConfig.getEngineRunConfiguration() instanceof LocalWorkflowRunConfiguration)) continue;
                    localFound = true;
                }
                if (!localFound) {
                    box = new MessageBox(HopGui.getInstance().getShell(), 196);
                    box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfig.Dialog.Header", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfig.Dialog.Message", (String[])new String[0]));
                    int anwser = box.open();
                    if ((anwser & 0x40) != 0) {
                        LocalWorkflowRunConfiguration localWorkflowRunConfiguration = new LocalWorkflowRunConfiguration();
                        localWorkflowRunConfiguration.setEnginePluginId("Local");
                        WorkflowRunConfiguration local = new WorkflowRunConfiguration("local", BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.LocalWFRunConfigDescription.Text", (String[])new String[0]), null, (IWorkflowEngineRunConfiguration)localWorkflowRunConfiguration, true);
                        wrcSerializer.save((IHopMetadata)local);
                    }
                }
                box = new MessageBox(HopGui.getInstance().getShell(), 196);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Message1", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.Lifecycle.Dialog.Message2", (String[])new String[0]));
                int anwser = box.open();
                if ((anwser & 0x40) != 0) {
                    this.addNewEnvironment();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddProject.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-40040-project-delete", toolTip="i18n::HopGui.Toolbar.Project.Delete.Tooltip", image="project-delete.svg", separator=true)
    public void deleteSelectedProject() {
        Combo combo = ProjectsGuiPlugin.getProjectsCombo();
        if (combo == null) {
            return;
        }
        String projectName = combo.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig currentProjectConfig = config.findProjectConfig(projectName);
        if (currentProjectConfig == null) {
            return;
        }
        String projectHome = currentProjectConfig.getProjectHome();
        String configFilename = currentProjectConfig.getConfigFilename();
        try {
            List<String> refs = ProjectsUtil.getParentProjectReferences(projectName);
            if (refs.isEmpty()) {
                this.performProjectDeletion(projectName, config, projectHome, configFilename);
            } else {
                String prjReferences = String.join((CharSequence)",", refs);
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Message1", (String[])new String[0]) + Const.CR + prjReferences + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.ProjectReferencedAsParent.Message2", (String[])new String[0]));
                box.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
        }
    }

    private void performProjectDeletion(String projectName, ProjectsConfig config, String projectHome, String configFilename) {
        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Message1", (String[])new String[]{projectName}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Dialog.Message2", (String[])new String[]{projectHome, configFilename}));
        int anwser = box.open();
        if ((anwser & 0x40) != 0) {
            try {
                config.removeProjectConfig(projectName);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.refreshProjectsList();
                if (StringUtils.isEmpty((String)config.getDefaultProject())) {
                    ProjectsGuiPlugin.selectProjectInList(null);
                } else {
                    ProjectsGuiPlugin.selectProjectInList(config.getDefaultProject());
                }
            }
            catch (Exception e) {
                new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteProject.Error.Dialog.Message", (String[])new String[]{projectName}), e);
            }
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-50000-environment-label", type=GuiToolbarElementType.LABEL, label="i18n::HopGui.Toolbar.Environment.Label", toolTip="i18n::HopGui.Toolbar.Environment.Tooltip", separator=true)
    public void editEnvironment() {
        HopGui hopGui = HopGui.getInstance();
        Combo combo = ProjectsGuiPlugin.getEnvironmentsCombo();
        if (combo == null) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        String environmentName = combo.getText();
        if (StringUtils.isEmpty((String)environmentName)) {
            return;
        }
        LifecycleEnvironment environment = config.findEnvironment(environmentName);
        if (environment == null) {
            return;
        }
        try {
            LifecycleEnvironmentDialog dialog = new LifecycleEnvironmentDialog(hopGui.getShell(), environment, hopGui.getVariables());
            if (dialog.open() != null) {
                config.addEnvironment(environment);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.refreshEnvironmentsList();
                ProjectsGuiPlugin.selectEnvironmentInList(environmentName);
            }
            if (dialog.isNeedingEnvironmentRefresh() && this.askAboutProjectRefresh(hopGui)) {
                this.selectEnvironment();
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.EditEnvironment.Error.Dialog.Message", (String[])new String[]{environmentName}), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-50010-environment-list", type=GuiToolbarElementType.COMBO, comboValuesMethod="getEnvironmentsList", extraWidth=200, toolTip="i18n::HopGui.Toolbar.EnvironmentsList.Tooltip")
    public void selectEnvironment() {
        HopGui hopGui = HopGui.getInstance();
        Combo envCombo = ProjectsGuiPlugin.getEnvironmentsCombo();
        if (envCombo == null) {
            return;
        }
        String environmentName = envCombo.getText();
        if (StringUtils.isEmpty((String)environmentName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName);
        if (environment == null) {
            return;
        }
        if (StringUtils.isEmpty((String)environment.getProjectName())) {
            return;
        }
        ProjectConfig projectConfig = config.findProjectConfig(environment.getProjectName());
        if (projectConfig == null) {
            return;
        }
        try {
            Project project = projectConfig.loadProject(hopGui.getVariables());
            if (project != null) {
                ProjectsGuiPlugin.enableHopGuiProject(projectConfig.getProjectName(), project, environment);
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ChangeEnvironment.Error.Dialog.Message", (String[])new String[]{environmentName}), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-50020-environment-edit", toolTip="i18n::HopGui.Toolbar.Environment.Edit.Tooltip", image="environment-edit.svg")
    public void editSelectedEnvironment() {
        this.editEnvironment();
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-50030-environment-add", toolTip="i18n::HopGui.Toolbar.Environment.Add.Tooltip", image="environment-add.svg")
    public void addNewEnvironment() {
        HopGui hopGui = HopGui.getInstance();
        try {
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            String projectName = ProjectsGuiPlugin.getProjectsCombo().getText();
            LifecycleEnvironment environment = new LifecycleEnvironment(null, "", projectName, new ArrayList<String>());
            LifecycleEnvironmentDialog dialog = new LifecycleEnvironmentDialog(hopGui.getShell(), environment, hopGui.getVariables());
            String environmentName = dialog.open();
            if (environmentName != null) {
                config.addEnvironment(environment);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.refreshEnvironmentsList();
                ProjectsGuiPlugin.selectEnvironmentInList(environmentName);
                ProjectConfig projectConfig = config.findProjectConfig(projectName);
                if (projectConfig != null) {
                    Project project = projectConfig.loadProject(hopGui.getVariables());
                    ProjectsGuiPlugin.enableHopGuiProject(projectName, project, environment);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.AddEnvironment.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-50040-environment-delete", toolTip="i18n::HopGui.Toolbar.Environment.Delete.Tooltip", image="environment-delete.svg", separator=true)
    public void deleteSelectedEnvironment() {
        Combo combo = ProjectsGuiPlugin.getEnvironmentsCombo();
        if (combo == null) {
            return;
        }
        String environmentName = combo.getText();
        if (StringUtils.isEmpty((String)environmentName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        LifecycleEnvironment environment = config.findEnvironment(environmentName);
        if (environment == null) {
            return;
        }
        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 196);
        box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Message1", (String[])new String[]{environmentName}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Dialog.Message2", (String[])new String[]{environment.getProjectName()}));
        int anwser = box.open();
        if ((anwser & 0x40) != 0) {
            try {
                config.removeEnvironment(environmentName);
                ProjectsConfigSingleton.saveConfig();
                ProjectsGuiPlugin.refreshEnvironmentsList();
                ProjectsGuiPlugin.selectEnvironmentInList(null);
            }
            catch (Exception e) {
                new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.DeleteEnvironment.Error.Dialog.Message", (String[])new String[]{environmentName}), e);
            }
        }
    }

    public static void enableHopGuiProject(String projectName, Project project, LifecycleEnvironment environment) throws HopException {
        try {
            HopGui hopGui = HopGui.getInstance();
            hopGui.auditDelegate.writeLastOpenFiles();
            if (!hopGui.fileDelegate.saveGuardAllFiles()) {
                return;
            }
            hopGui.fileDelegate.closeAllFiles();
            IVariables variables = Variables.getADefaultVariableSpace();
            ArrayList<String> configurationFiles = new ArrayList<String>();
            if (environment != null) {
                configurationFiles.addAll(environment.getConfigurationFiles());
            }
            String environmentName = environment == null ? null : environment.getName();
            ProjectsUtil.enableProject(hopGui.getLog(), projectName, project, variables, configurationFiles, environmentName, (IHasHopMetadataProvider)hopGui);
            IHopMetadataSerializer runConfigSerializer = hopGui.getMetadataProvider().getSerializer(PipelineRunConfiguration.class);
            for (String[] runConfig : runConfigSerializer.loadAll()) {
                for (DescribedVariable variableValueDescription : runConfig.getConfigurationVariables()) {
                    variables.setVariable(variableValueDescription.getName(), "");
                }
            }
            hopGui.setVariables(variables);
            hopGui.auditDelegate.openLastFiles();
            IVariables hopGuiVariables = Variables.getADefaultVariableSpace();
            hopGui.setVariables(hopGuiVariables);
            for (String variable : variables.getVariableNames()) {
                String value = variables.getVariable(variable);
                if (variable.startsWith("Internal")) continue;
                hopGuiVariables.setVariable(variable, value);
            }
            hopGui.getActivePerspective().getActiveFileTypeHandler().updateGui();
            ProjectsGuiPlugin.selectProjectInList(projectName);
            ProjectsGuiPlugin.selectEnvironmentInList(environment == null ? null : environment.getName());
            AuditEvent prjUsedEvent = new AuditEvent("projects", "project", projectName, "open", new Date());
            AuditManager.getActive().storeEvent(prjUsedEvent);
            ProjectsGuiPlugin.refreshProjectsList();
            ProjectsGuiPlugin.selectProjectInList(projectName);
            if (environment != null) {
                AuditEvent envUsedEvent = new AuditEvent("projects", "environment", environment.getName(), "open", new Date());
                AuditManager.getActive().storeEvent(envUsedEvent);
            }
            hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.ProjectActivated.name()});
            hopGui.getEventsHandler().fire(new String[]{projectName, HopGuiEvents.MetadataChanged.name()});
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)hopGuiVariables, (String)HopExtensionPoint.HopGuiProjectAfterEnabled.name(), (Object)((Object)project));
        }
        catch (Exception e) {
            throw new HopException("Error enabling project '" + projectName + "' in HopGui", (Throwable)e);
        }
    }

    private static Combo getProjectsCombo() {
        Control control = (Control)HopGui.getInstance().getMainToolbarWidgets().getWidgetsMap().get(ID_TOOLBAR_PROJECT_COMBO);
        if (control instanceof Combo) {
            return (Combo)control;
        }
        return null;
    }

    private static Combo getEnvironmentsCombo() {
        Control control = (Control)HopGui.getInstance().getMainToolbarWidgets().getWidgetsMap().get(ID_TOOLBAR_ENVIRONMENT_COMBO);
        if (control instanceof Combo) {
            return (Combo)control;
        }
        return null;
    }

    public List<String> getProjectsList(ILogChannel log, IHopMetadataProvider metadataProvider) throws Exception {
        List<String> names = ProjectsConfigSingleton.getConfig().listProjectConfigNames();
        final HashMap<String, Date> lastUsedMap = new HashMap<String, Date>();
        names.stream().forEach(name -> lastUsedMap.put((String)name, new GregorianCalendar(1900, 0, 1).getTime()));
        List projectOpenEvents = AuditManager.findEvents((String)"projects", (String)"project", (String)"open", (int)100, (boolean)true);
        for (AuditEvent projectOpenEvent : projectOpenEvents) {
            lastUsedMap.put(projectOpenEvent.getName(), projectOpenEvent.getDate());
        }
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                int cmp = -((Date)lastUsedMap.get(name1)).compareTo((Date)lastUsedMap.get(name2));
                if (cmp == 0) {
                    cmp = name1.compareToIgnoreCase(name2);
                }
                return cmp;
            }
        });
        return names;
    }

    public static void refreshProjectsList() {
        HopGui.getInstance().getMainToolbarWidgets().refreshComboItemList(ID_TOOLBAR_PROJECT_COMBO);
    }

    public static void selectProjectInList(String name) {
        String projectHome;
        ProjectsConfig config;
        ProjectConfig projectConfig;
        GuiToolbarWidgets toolbarWidgets = HopGui.getInstance().getMainToolbarWidgets();
        toolbarWidgets.selectComboItem(ID_TOOLBAR_PROJECT_COMBO, name);
        Combo combo = ProjectsGuiPlugin.getProjectsCombo();
        if (combo != null && (projectConfig = (config = ProjectsConfigSingleton.getConfig()).findProjectConfig(name)) != null && StringUtils.isNotEmpty((String)(projectHome = projectConfig.getProjectHome()))) {
            combo.setToolTipText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.SelectProject.Tooltip", (String[])new String[]{name, projectHome, projectConfig.getConfigFilename()}));
        }
    }

    public List<String> getEnvironmentsList(ILogChannel log, IHopMetadataProvider metadataProvider) throws Exception {
        return ProjectsConfigSingleton.getConfig().listEnvironmentNames();
    }

    public static void refreshEnvironmentsList() {
        HopGui.getInstance().getMainToolbarWidgets().refreshComboItemList(ID_TOOLBAR_ENVIRONMENT_COMBO);
    }

    public static void selectEnvironmentInList(String name) {
        ProjectsConfig config;
        LifecycleEnvironment environment;
        GuiToolbarWidgets toolbarWidgets = HopGui.getInstance().getMainToolbarWidgets();
        toolbarWidgets.selectComboItem(ID_TOOLBAR_ENVIRONMENT_COMBO, name);
        Combo combo = ProjectsGuiPlugin.getEnvironmentsCombo();
        if (combo != null && (environment = (config = ProjectsConfigSingleton.getConfig()).findEnvironment(name)) != null) {
            combo.setToolTipText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.FindEnvironment.Tooltip", (String[])new String[]{name, environment.getProjectName(), environment.getPurpose()}));
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0005-navigate-project-home", toolTip="i18n::FileDialog.Browse.Project.Home", image="project.svg")
    public void fileDialogBrowserProjectHome() {
        HopVfsFileDialog instance;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(HopNamespace.getNamespace());
        if (projectConfig == null) {
            return;
        }
        String homeFolder = projectConfig.getProjectHome();
        if (StringUtils.isNotEmpty((String)homeFolder) && (instance = HopVfsFileDialog.getInstance()) != null) {
            instance.navigateTo(homeFolder, true);
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="10055-menu-file-export-to-svg", label="i18n::HopGui.FileMenu.Project.Export.Label", image="export.svg", parentId="10000-menu-file", separator=false)
    public void menuProjectExport() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        String zipFilename = BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.zip", "*.*"}, (String[])new String[]{"Zip files (*.zip)", "All Files (*.*)"}, (boolean)true);
        if (zipFilename == null) {
            return;
        }
        Combo combo = ProjectsGuiPlugin.getProjectsCombo();
        if (combo == null) {
            return;
        }
        String projectName = combo.getText();
        if (StringUtils.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        String projectHome = projectConfig.getProjectHome();
        try {
            IRunnableWithProgress op = monitor -> {
                try {
                    monitor.setTaskName(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Taskname.Text", (String[])new String[0]));
                    OutputStream outputStream = HopVfs.getOutputStream((String)zipFilename, (boolean)false);
                    ZipOutputStream zos = new ZipOutputStream(outputStream);
                    FileObject projectDirectory = HopVfs.getFileObject((String)projectHome);
                    String projectHomeFolder = HopVfs.getFileObject((String)projectHome).getParent().getName().getURI();
                    this.zipFile(projectDirectory, projectDirectory.getName().getURI(), zos, projectHomeFolder);
                    zos.close();
                    outputStream.close();
                    monitor.done();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error zipping project: " + e.getMessage());
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.run(false, op);
            GuiResource.getInstance().toClipboard(zipFilename);
            MessageBox box = new MessageBox(shell, 66);
            box.setText(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Message1", (String[])new String[]{zipFilename}) + Const.CR + BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Dialog.Message2", (String[])new String[0]));
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Error.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProjectGuiPlugin.ZipDirectory.Error.Dialog.Message", (String[])new String[0]), e);
        }
    }

    public void zipFile(FileObject fileToZip, String filename, ZipOutputStream zipOutputStream, String projectHomeParent) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isFolder()) {
            FileObject[] children;
            if (filename.endsWith("/")) {
                zipOutputStream.putNextEntry(new ZipEntry(filename.replaceAll(projectHomeParent, "")));
                zipOutputStream.closeEntry();
            } else {
                zipOutputStream.putNextEntry(new ZipEntry(filename.replaceAll(projectHomeParent, "") + "/"));
                zipOutputStream.closeEntry();
            }
            for (FileObject childFile : children = fileToZip.getChildren()) {
                this.zipFile(childFile, filename + "/" + childFile.getName().getBaseName(), zipOutputStream, projectHomeParent);
            }
            return;
        }
        InputStream fis = HopVfs.getInputStream((FileObject)fileToZip);
        ZipEntry zipEntry = new ZipEntry(filename.replaceAll(projectHomeParent, ""));
        zipOutputStream.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOutputStream.write(bytes, 0, length);
        }
        fis.close();
    }

    public static final void enableProject(String projectName) throws HopException {
        HopGui hopGui = HopGui.getInstance();
        IVariables variables = hopGui.getVariables();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            throw new HopException("The project with name '" + projectName + "' could not be found");
        }
        Project project = projectConfig.loadProject(variables);
        ProjectsGuiPlugin.enableHopGuiProject(projectName, project, null);
    }
}

