/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineTweak;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.TestType;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.xp.RowCollection;

public class DataSetConst {
    private static final Class<?> PKG = DataSetConst.class;
    public static final String DATABASE_FACTORY_KEY = "DatabaseMetaFactory";
    public static final String GROUP_FACTORY_KEY = "DataSetGroupFactory";
    public static final String SET_FACTORY_KEY = "DataSetFactory";
    public static final String VAR_RUN_UNIT_TEST = "__UnitTest_Run__";
    public static final String VAR_UNIT_TEST_NAME = "__UnitTest_Name__";
    public static final String VAR_WRITE_TO_DATASET = "__UnitTest_WriteDataSet__";
    public static final String VAR_DO_NOT_SHOW_UNIT_TEST_ERRORS = "__UnitTest_DontShowUnitTestErrors__";
    public static final String AREA_DRAWN_UNIT_TEST_ICON = "Drawn_UnitTestIcon";
    public static final String AREA_DRAWN_UNIT_TEST_NAME = "Drawn_UnitTestName";
    public static final String AREA_DRAWN_INPUT_DATA_SET = "Input_DataSet";
    public static final String AREA_DRAWN_GOLDEN_DATA_SET = "Golden_DataSet";
    public static final String AREA_DRAWN_GOLDEN_DATA_RESULT = "Golden_DataSet_Result";
    public static final String ROW_COLLECTION_MAP = "RowCollectionMap";
    public static final String UNIT_TEST_RESULTS = "UnitTestResults";
    public static final String VARIABLE_HOP_UNIT_TESTS_FOLDER = "HOP_UNIT_TESTS_FOLDER";
    public static final String STATE_KEY_GOLDEN_DATASET_RESULTS = "GoldenDataSetResults";
    public static final String STATE_KEY_ACTIVE_UNIT_TEST = "ActiveUnitTest";
    private static final String[] tweakDesc = new String[]{BaseMessages.getString(PKG, (String)"DataSetConst.Tweak.NONE.Desc", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataSetConst.Tweak.BYPASS_TRANSFORM.Desc", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataSetConst.Tweak.REMOVE_TRANSFORM.Desc", (String[])new String[0])};
    private static final String[] testTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"DataSetConst.TestType.DEVELOPMENT.Desc", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataSetConst.TestType.UNIT_TEST.Desc", (String[])new String[0])};

    public static final int validateTransformResultAgainstUnitTest(IPipelineEngine<PipelineMeta> pipeline, PipelineUnitTest unitTest, IHopMetadataProvider metadataProvider, List<UnitTestResult> results) throws HopException {
        int nrErrors = 0;
        ILogChannel log = pipeline.getLogChannel();
        Map collectionMap = (Map)pipeline.getExtensionDataMap().get(ROW_COLLECTION_MAP);
        if (collectionMap == null) {
            String comment = "No transform output result data found to validate against";
            results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), null, null, false, comment));
            return nrErrors;
        }
        for (PipelineUnitTestSetLocation location : unitTest.getGoldenDataSets()) {
            Object comment;
            if (pipeline.getPipelineMeta().findTransform(location.getTransformName()) == null) continue;
            int nrLocationErrors = 0;
            RowCollection resultCollection = (RowCollection)collectionMap.get(location.getTransformName());
            if (resultCollection == null || resultCollection.getRows() == null || resultCollection.getRowMeta() == null) {
                resultCollection = new RowCollection();
                resultCollection.setRowMeta((IRowMeta)new RowMeta());
                resultCollection.setRows(new ArrayList<Object[]>());
                String comment2 = "WARNING: no test results found for transform '" + location.getTransformName() + "' : check disabled hops, input and so on.";
                results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), location.getDataSetName(), location.getTransformName(), false, comment2));
            }
            IRowMeta resultRowMeta = resultCollection.getRowMeta();
            log.logDetailed("Found " + resultCollection.getRows().size() + " results for data comparing in transform '" + location.getTransformName() + "', fields: " + resultRowMeta.toString());
            DataSet goldenDataSet = unitTest.getGoldenDataSet(log, metadataProvider, location);
            List<Object[]> goldenRows = goldenDataSet.getAllRows((IVariables)pipeline, log, location);
            IRowMeta goldenRowMeta = goldenDataSet.getMappedDataSetFieldsRowMeta(location);
            log.logDetailed("Found " + goldenRows.size() + " golden rows '" + location.getTransformName() + "', fields: " + String.valueOf(goldenRowMeta));
            List<Object[]> resultRows = resultCollection.getRows();
            if (resultRows.size() != goldenRows.size()) {
                comment = "Incorrect number of rows received from transform, golden data set '" + location.getDataSetName() + "' has " + goldenRows.size() + " rows in it and we received " + resultRows.size();
                results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), location.getDataSetName(), location.getTransformName(), true, (String)comment));
                ++nrLocationErrors;
            } else {
                int i;
                int i2;
                int[] resultFieldIndexes = new int[location.getFieldOrder().size()];
                for (i2 = 0; i2 < resultFieldIndexes.length; ++i2) {
                    String dataSetOrderField = location.getFieldOrder().get(i2);
                    String transformOrderField = location.findTransformField(dataSetOrderField);
                    if (transformOrderField == null) {
                        throw new HopException("There is no transform field provided in the mappings so I don't know which field to use to sort '" + dataSetOrderField + "'");
                    }
                    resultFieldIndexes[i2] = resultRowMeta.indexOfValue(transformOrderField);
                    if (resultFieldIndexes[i2] >= 0) continue;
                    throw new HopException("Unable to find sort field '" + transformOrderField + "' in transform results : " + Arrays.toString(resultRowMeta.getFieldNames()));
                }
                try {
                    log.logDetailed("Sorting result rows collection on fields: " + String.valueOf(location.getFieldOrder()));
                    resultCollection.getRows().sort((row1, row2) -> {
                        try {
                            return resultRowMeta.compare(row1, row2, resultFieldIndexes);
                        }
                        catch (HopValueException e) {
                            throw new RuntimeException("Error comparing golden data result rows", e);
                        }
                    });
                }
                catch (RuntimeException e) {
                    throw new HopException("Error sorting result rows for golden data set '" + location.getDataSetName() + "'", (Throwable)e);
                }
                if (log.isDebug()) {
                    for (i2 = 0; i2 < 10 && i2 < resultCollection.getRows().size(); ++i2) {
                        log.logDetailed("Result row #" + (i2 + 1) + " : " + resultRowMeta.getString(resultCollection.getRows().get(i2)));
                    }
                }
                int[] goldenFieldIndexes = new int[location.getFieldOrder().size()];
                for (i = 0; i < goldenFieldIndexes.length; ++i) {
                    goldenFieldIndexes[i] = goldenRowMeta.indexOfValue(location.getFieldOrder().get(i));
                    if (goldenFieldIndexes[i] >= 0) continue;
                    throw new HopException("Unable to find sort field '" + location.getFieldOrder().get(i) + "' in golden rows : " + Arrays.toString(goldenRowMeta.getFieldNames()));
                }
                try {
                    log.logDetailed("Sorting golden rows collection on fields: " + String.valueOf(location.getFieldOrder()));
                    goldenRows.sort((row1, row2) -> {
                        try {
                            return goldenRowMeta.compare(row1, row2, goldenFieldIndexes);
                        }
                        catch (HopValueException e) {
                            throw new RuntimeException("Error comparing golden data set rows", e);
                        }
                    });
                }
                catch (RuntimeException e) {
                    throw new HopException("Error sorting golden data rows for golden data set '" + location.getDataSetName() + "'", (Throwable)e);
                }
                if (log.isDebug()) {
                    for (i = 0; i < 10 && i < goldenRows.size(); ++i) {
                        log.logDetailed("Golden row #" + (i + 1) + " : " + goldenRowMeta.getString(goldenRows.get(i)));
                    }
                }
                if (nrLocationErrors == 0) {
                    int[] transformFieldIndices = new int[location.getFieldMappings().size()];
                    int[] goldenIndices = new int[location.getFieldMappings().size()];
                    for (int i3 = 0; i3 < location.getFieldMappings().size(); ++i3) {
                        PipelineUnitTestFieldMapping fieldMapping = location.getFieldMappings().get(i3);
                        transformFieldIndices[i3] = resultRowMeta.indexOfValue(fieldMapping.getTransformFieldName());
                        if (transformFieldIndices[i3] < 0) {
                            throw new HopException("Unable to find output field '" + fieldMapping.getTransformFieldName() + "' while testing output of transform '" + location.getTransformName() + "'");
                        }
                        goldenIndices[i3] = goldenRowMeta.indexOfValue(fieldMapping.getDataSetFieldName());
                        if (goldenIndices[i3] < 0) {
                            throw new HopException("Unable to find golden data set field '" + fieldMapping.getDataSetFieldName() + "' while testing output of transform '" + location.getTransformName() + "'");
                        }
                        log.logDetailed("Field to compare #" + i3 + " found on transform index : " + transformFieldIndices[i3] + ", golden index : " + goldenIndices[i3]);
                    }
                    for (int rowNumber = 0; rowNumber < resultRows.size(); ++rowNumber) {
                        Object[] resultRow = resultRows.get(rowNumber);
                        Object[] goldenRow = goldenRows.get(rowNumber);
                        for (int i4 = 0; i4 < location.getFieldMappings().size(); ++i4) {
                            IValueMeta transformValueMeta = resultCollection.getRowMeta().getValueMeta(transformFieldIndices[i4]);
                            Object transformValue = resultRow[transformFieldIndices[i4]];
                            IValueMeta goldenValueMeta = goldenRowMeta.getValueMeta(goldenIndices[i4]);
                            Object goldenValue = goldenRow[goldenIndices[i4]];
                            if (log.isDetailed()) {
                                log.logDebug("Comparing Meta '" + transformValueMeta.toString() + "' with '" + goldenValueMeta.toString() + "'");
                                log.logDebug("Comparing Value '" + String.valueOf(transformValue) + "' with '" + String.valueOf(goldenValue) + "'");
                            }
                            Object goldenValueConverted = goldenValueMeta.getType() == transformValueMeta.getType() ? goldenValue : transformValueMeta.convertData(goldenValueMeta, goldenValue);
                            try {
                                int cmp = transformValueMeta.compare(transformValue, goldenValueMeta, goldenValueConverted);
                                if (cmp != 0 && transformValueMeta.isNumber() && !transformValueMeta.isNull(transformValue) && !transformValueMeta.isNull(goldenValueConverted)) {
                                    Double d1 = transformValueMeta.getNumber(transformValue);
                                    Double d2 = transformValueMeta.getNumber(goldenValueConverted);
                                    if (Precision.equals((double)d1, (double)d2, (double)1.0E-6)) {
                                        cmp = 0;
                                    }
                                }
                                if (cmp == 0) continue;
                                if (log.isDebug()) {
                                    log.logDebug("Unit test failure: '" + String.valueOf(transformValue) + "' <> '" + String.valueOf(goldenValue) + "'");
                                }
                                String comment3 = "Validation against golden data failed for row number " + (rowNumber + 1) + ", field " + transformValueMeta.getName() + " : transform value [" + transformValueMeta.getString(transformValue) + "] does not correspond to data set value [" + goldenValueMeta.getString(goldenValue) + "]";
                                results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), location.getDataSetName(), location.getTransformName(), true, comment3));
                                ++nrLocationErrors;
                                continue;
                            }
                            catch (HopValueException e) {
                                throw new HopException("Unable to compare transform data against golden data set '" + location.getDataSetName() + "'", (Throwable)e);
                            }
                        }
                    }
                }
            }
            if (nrLocationErrors == 0) {
                comment = "Test passed successfully against golden data set";
                results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), location.getDataSetName(), location.getTransformName(), false, (String)comment));
                continue;
            }
            nrErrors += nrLocationErrors;
        }
        if (nrErrors == 0) {
            String comment = "Unit test was successfully executed.";
            results.add(new UnitTestResult(pipeline.getPipelineMeta().getName(), unitTest.getName(), null, null, false, comment));
        }
        return nrErrors;
    }

    public static final String getDirectoryFromPath(String path) {
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            return path.substring(0, lastSlashIndex);
        }
        return "/";
    }

    public static final String getNameFromPath(String path) {
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            return path.substring(lastSlashIndex + 1);
        }
        return path;
    }

    public static IRowMeta getTransformOutputFields(DataSet dataSet, PipelineUnitTestSetLocation inputLocation) throws HopException {
        IRowMeta dataSetRowMeta = dataSet.getSetRowMeta();
        RowMeta outputRowMeta = new RowMeta();
        for (int i = 0; i < inputLocation.getFieldMappings().size(); ++i) {
            PipelineUnitTestFieldMapping fieldMapping = inputLocation.getFieldMappings().get(i);
            IValueMeta injectValueMeta = dataSetRowMeta.searchValueMeta(fieldMapping.getDataSetFieldName());
            if (injectValueMeta == null) {
                throw new HopException("Unable to find mapped field '" + fieldMapping.getDataSetFieldName() + "' in data set '" + dataSet.getName() + "'");
            }
            injectValueMeta.setName(fieldMapping.getTransformFieldName());
            outputRowMeta.addValueMeta(injectValueMeta);
        }
        return outputRowMeta;
    }

    public PipelineTweak getTweakForDescription(String tweakDescription) {
        if (StringUtils.isEmpty((String)tweakDescription)) {
            return PipelineTweak.NONE;
        }
        int index = Const.indexOfString((String)tweakDescription, (String[])tweakDesc);
        if (index < 0) {
            return PipelineTweak.NONE;
        }
        return PipelineTweak.values()[index];
    }

    public static final String getTestTypeDescription(TestType testType) {
        int index = 0;
        if (testType != null) {
            TestType[] testTypes = TestType.values();
            for (int i = 0; i < testTypes.length; ++i) {
                if (testTypes[i] != testType) continue;
                index = i;
                break;
            }
        }
        return testTypeDesc[index];
    }

    public static final TestType getTestTypeForDescription(String testTypeDescription) {
        if (StringUtils.isEmpty((String)testTypeDescription)) {
            return TestType.DEVELOPMENT;
        }
        int index = Const.indexOfString((String)testTypeDescription, (String[])testTypeDesc);
        if (index < 0) {
            return TestType.DEVELOPMENT;
        }
        return TestType.values()[index];
    }

    public static final String[] getTestTypeDescriptions() {
        return testTypeDesc;
    }
}

