/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;

public class BasicURLHandler
extends AbstractURLHandler
implements TimeoutConstrainedURLHandler {
    private static final int BUFFER_SIZE = 65536;

    @Override
    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, null);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        return this.getURLInfo(url, BasicURLHandler.createTimeoutConstraints(timeout));
    }

    @Override
    public boolean isReachable(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).isReachable();
    }

    @Override
    public long getContentLength(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).getContentLength();
    }

    @Override
    public long getLastModified(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URLHandler.URLInfo getURLInfo(URL url, TimeoutConstraint timeoutConstraint) {
        URLConnection con;
        block13: {
            if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                IvyAuthenticator.install();
            }
            int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
            int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
            con = null;
            try {
                URL normalizedURL = this.normalizeToURL(url);
                con = normalizedURL.openConnection();
                con.setConnectTimeout(connectionTimeout);
                con.setReadTimeout(readTimeout);
                con.setRequestProperty("User-Agent", this.getUserAgent());
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection httpCon = (HttpURLConnection)con;
                    if (this.getRequestMethod() == 2) {
                        httpCon.setRequestMethod("HEAD");
                    }
                    if (this.checkStatusCode(normalizedURL, httpCon)) {
                        String bodyCharset = BasicURLHandler.getCharSetFromContentType(con.getContentType());
                        URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, httpCon.getContentLength(), con.getLastModified(), bodyCharset);
                        this.disconnect(con);
                        return uRLInfo;
                    }
                    break block13;
                }
                int contentLength = con.getContentLength();
                if (contentLength <= 0) {
                    URLHandler.URLInfo bodyCharset = UNAVAILABLE;
                    this.disconnect(con);
                    return bodyCharset;
                }
                String bodyCharset = BasicURLHandler.getCharSetFromContentType(con.getContentType());
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, contentLength, con.getLastModified(), bodyCharset);
                this.disconnect(con);
                return uRLInfo;
            }
            catch (UnknownHostException e) {
                Message.warn("Host " + e.getMessage() + " not found. url=" + url);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
                this.disconnect(con);
                return UNAVAILABLE;
                {
                    catch (Throwable throwable) {
                        this.disconnect(con);
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    Message.error("Server access error at url " + url, e2);
                    this.disconnect(con);
                    return UNAVAILABLE;
                }
            }
        }
        this.disconnect(con);
        return UNAVAILABLE;
    }

    public static String getCharSetFromContentType(String contentType) {
        String charSet = null;
        if (contentType != null) {
            for (String el : contentType.split(";")) {
                String element = el.trim();
                if (!element.toLowerCase().startsWith("charset=")) continue;
                charSet = element.substring("charset=".length());
            }
        }
        if (charSet == null || charSet.length() == 0) {
            charSet = "ISO-8859-1";
        }
        return charSet;
    }

    private boolean checkStatusCode(URL url, HttpURLConnection con) throws IOException {
        int status = con.getResponseCode();
        if (status == 200) {
            return true;
        }
        if ("HEAD".equals(con.getRequestMethod()) && status == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + status + " url=" + url);
        if (status == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + con.getResponseMessage() + " url=" + url);
        } else if (String.valueOf(status).startsWith("5")) {
            Message.error("SERVER ERROR: " + con.getResponseMessage() + " url=" + url);
        }
        return false;
    }

    @Override
    public InputStream openStream(URL url) throws IOException {
        return this.openStream(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openStream(URL url, TimeoutConstraint timeoutConstraint) throws IOException {
        if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
            IvyAuthenticator.install();
        }
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        URLConnection conn = null;
        try {
            int len;
            HttpURLConnection httpCon;
            URL normalizedURL = this.normalizeToURL(url);
            conn = normalizedURL.openConnection();
            conn.setConnectTimeout(connectionTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("User-Agent", this.getUserAgent());
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (conn instanceof HttpURLConnection && !this.checkStatusCode(normalizedURL, httpCon = (HttpURLConnection)conn)) {
                throw new IOException("The HTTP response code for " + normalizedURL + " did not indicate a success. See log for more detail.");
            }
            InputStream inStream = this.getDecodingInputStream(conn.getContentEncoding(), conn.getInputStream());
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outStream.toByteArray());
            this.disconnect(conn);
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            this.disconnect(conn);
            throw throwable;
        }
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.download(src, dest, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(URL src, File dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        if ("http".equals(src.getProtocol()) || "https".equals(src.getProtocol())) {
            IvyAuthenticator.install();
        }
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        URLConnection srcConn = null;
        try {
            long lastModified;
            HttpURLConnection httpCon;
            URL normalizedURL = this.normalizeToURL(src);
            srcConn = normalizedURL.openConnection();
            srcConn.setConnectTimeout(connectionTimeout);
            srcConn.setReadTimeout(readTimeout);
            srcConn.setRequestProperty("User-Agent", this.getUserAgent());
            srcConn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (srcConn instanceof HttpURLConnection && !this.checkStatusCode(normalizedURL, httpCon = (HttpURLConnection)srcConn)) {
                throw new IOException("The HTTP response code for " + normalizedURL + " did not indicate a success. See log for more detail.");
            }
            InputStream inStream = this.getDecodingInputStream(srcConn.getContentEncoding(), srcConn.getInputStream());
            FileUtil.copy(inStream, dest, listener);
            if (srcConn.getContentEncoding() == null) {
                int contentLength = srcConn.getContentLength();
                long destFileSize = dest.length();
                if (contentLength != -1 && destFileSize != (long)contentLength) {
                    dest.delete();
                    throw new IOException("Downloaded file size (" + destFileSize + ") doesn't match expected Content Length (" + contentLength + ") for " + normalizedURL + ". Please retry.");
                }
            }
            if ((lastModified = srcConn.getLastModified()) > 0L) {
                dest.setLastModified(lastModified);
            }
            this.disconnect(srcConn);
        }
        catch (Throwable throwable) {
            this.disconnect(srcConn);
            throw throwable;
        }
    }

    @Override
    public void upload(File source, URL dest, CopyProgressListener l) throws IOException {
        this.upload(source, dest, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(File src, URL dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        if (!"http".equals(dest.getProtocol()) && !"https".equals(dest.getProtocol())) {
            throw new UnsupportedOperationException("URL repository only support HTTP PUT at the moment");
        }
        IvyAuthenticator.install();
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        HttpURLConnection conn = null;
        try {
            URL normalizedDestURL = this.normalizeToURL(dest);
            conn = (HttpURLConnection)normalizedDestURL.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(connectionTimeout);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("User-Agent", this.getUserAgent());
            conn.setRequestProperty("Content-type", "application/octet-stream");
            conn.setRequestProperty("Content-length", Long.toString(src.length()));
            conn.setInstanceFollowRedirects(true);
            try (FileInputStream in = new FileInputStream(src);){
                OutputStream os = conn.getOutputStream();
                FileUtil.copy((InputStream)in, os, listener);
            }
            this.validatePutStatusCode(normalizedDestURL, conn.getResponseCode(), conn.getResponseMessage());
            this.disconnect(conn);
        }
        catch (Throwable throwable) {
            this.disconnect(conn);
            throw throwable;
        }
    }

    private void disconnect(URLConnection con) {
        if (con instanceof HttpURLConnection) {
            if (!"HEAD".equals(((HttpURLConnection)con).getRequestMethod())) {
                this.readResponseBody((HttpURLConnection)con);
            }
            ((HttpURLConnection)con).disconnect();
        } else if (con != null) {
            try {
                con.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponseBody(HttpURLConnection conn) {
        byte[] buffer = new byte[65536];
        try (InputStream inStream2 = conn.getInputStream();){
            while (inStream2.read(buffer) > 0) {
            }
        }
        catch (IOException inStream2) {
            // empty catch block
        }
        InputStream errStream = conn.getErrorStream();
        if (errStream != null) {
            try {
                while (errStream.read(buffer) > 0) {
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    errStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final class HttpStatus {
        static final int SC_OK = 200;
        static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;

        private HttpStatus() {
        }
    }
}

