/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.Plugin;
import org.apache.hop.core.plugins.PluginMainClassType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.core.xml.XmlHandlerCache;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class BeamHop {
    private static final Logger LOG = LoggerFactory.getLogger(BeamHop.class);

    public static final boolean isInitialized() {
        return HopEnvironment.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init() throws HopException {
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        synchronized (pluginRegistry) {
            System.setProperty("HOP_AUTO_CREATE_CONFIG", "N");
            HopEnvironment.init();
            XmlHandlerCache.getInstance();
        }
    }

    private static IPlugin findPlugin(PluginRegistry registry, Class<? extends IPluginType<?>> pluginTypeClass, String pluginClassName) {
        PluginMainClassType classType = pluginTypeClass.getAnnotation(PluginMainClassType.class);
        List plugins = registry.getPlugins(pluginTypeClass);
        for (IPlugin plugin : plugins) {
            String mainClassName = (String)plugin.getClassMap().get(classType.value());
            if (!pluginClassName.equals(mainClassName)) continue;
            return plugin;
        }
        return null;
    }

    public static IPlugin getTransformPluginForClass(Class<? extends ITransformMeta> metaClass) {
        Transform transformAnnotation = metaClass.getAnnotation(Transform.class);
        return new Plugin(new String[]{transformAnnotation.id()}, TransformPluginType.class, metaClass, transformAnnotation.categoryDescription(), transformAnnotation.name(), transformAnnotation.description(), transformAnnotation.image(), transformAnnotation.isSeparateClassLoaderNeeded(), false, new HashMap(), new ArrayList(), transformAnnotation.documentationUrl(), transformAnnotation.keywords(), null, false);
    }

    public static Node getTransformXmlNode(TransformMeta transformMeta) throws HopException {
        String xml = transformMeta.getXml();
        Node transformNode = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)xml), (String)"transform");
        return transformNode;
    }

    public static void loadTransformMetadata(ITransformMeta meta, TransformMeta transformMeta, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta) throws HopException {
        meta.loadXml(BeamHop.getTransformXmlNode(transformMeta), metadataProvider);
        meta.searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
    }
}

