/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.TabFolderReorder;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypePluginType;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.apache.hop.ui.hopgui.perspective.TabCloseHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerFilePaintListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRefreshListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRootChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerSelectionListener;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.apache.hop.ui.hopgui.perspective.explorer.file.ExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.FolderFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.GenericFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;

@HopPerspectivePlugin(id="300-HopExplorerPerspective", name="i18n::ExplorerPerspective.Name", description="The Hop Explorer Perspective", image="ui/images/folder.svg")
@GuiPlugin(description="i18n::ExplorerPerspective.GuiPlugin.Description")
public class ExplorerPerspective
implements IHopPerspective,
TabClosable {
    public static final Class<?> PKG = ExplorerPerspective.class;
    public static final String GUI_TOOLBAR_CREATED_CALLBACK_ID = "ExplorerPerspective-Toolbar-Created";
    private static final String FILE_EXPLORER_TREE = "File explorer tree";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "ExplorerPerspective-Toolbar";
    public static final String TOOLBAR_ITEM_OPEN = "ExplorerPerspective-Toolbar-10000-Open";
    public static final String TOOLBAR_ITEM_CREATE_FOLDER = "ExplorerPerspective-Toolbar-10050-CreateFolder";
    public static final String TOOLBAR_ITEM_DELETE = "ExplorerPerspective-Toolbar-10100-Delete";
    public static final String TOOLBAR_ITEM_RENAME = "ExplorerPerspective-Toolbar-10200-Rename";
    public static final String TOOLBAR_ITEM_REFRESH = "ExplorerPerspective-Toolbar-10300-Refresh";
    private static ExplorerPerspective instance;
    private boolean treeIsFresh;
    private HopGui hopGui;
    private SashForm sash;
    private Tree tree;
    private TreeEditor treeEditor;
    private CTabFolder tabFolder;
    private ToolBar toolBar;
    private GuiToolbarWidgets toolBarWidgets;
    private List<ExplorerFile> files = new ArrayList<ExplorerFile>();
    private final EmptyFileType emptyFileType;
    private final ExplorerFileType explorerFileType;
    private String rootFolder;
    private String rootName;
    private List<IExplorerFilePaintListener> filePaintListeners;
    private List<IExplorerRootChangedListener> rootChangedListeners;
    private List<IExplorerRefreshListener> refreshListeners;
    private List<IExplorerSelectionListener> selectionListeners;
    private List<IHopFileType> fileTypes;
    private Map<String, Image> typeImageMap;
    boolean first = true;

    public static ExplorerPerspective getInstance() {
        if (instance == null) {
            new ExplorerPerspective();
        }
        return instance;
    }

    public ExplorerPerspective() {
        instance = this;
        this.emptyFileType = new EmptyFileType();
        this.explorerFileType = new ExplorerFileType();
        this.filePaintListeners = new ArrayList<IExplorerFilePaintListener>();
        this.rootChangedListeners = new ArrayList<IExplorerRootChangedListener>();
        this.refreshListeners = new ArrayList<IExplorerRefreshListener>();
        this.selectionListeners = new ArrayList<IExplorerSelectionListener>();
        this.typeImageMap = new HashMap<String, Image>();
        this.treeIsFresh = false;
    }

    @Override
    public String getId() {
        return "explorer-perspective";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=101)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=101)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        if (!this.treeIsFresh) {
            this.refresh();
        }
        this.updateGui();
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.singletonList(this.explorerFileType);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.determineRootFolderName(hopGui);
        this.loadFileTypes();
        this.loadTypeImages(parent);
        this.sash = new SashForm(parent, 256);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment(0, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.createTree((Composite)this.sash);
        this.createTabFolder((Composite)this.sash);
        this.sash.setWeights(new int[]{20, 80});
        hopGui.getEventsHandler().addEventListener(this.getClass().getName() + "ProjectActivated", e -> this.refresh(), HopGuiEvents.ProjectActivated.name());
        hopGui.getEventsHandler().addEventListener(this.getClass().getName() + "ProjectUpdated", e -> this.refresh(), HopGuiEvents.ProjectUpdated.name());
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    private void loadFileTypes() {
        this.fileTypes = new ArrayList<IHopFileType>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = PluginRegistry.getInstance().getPlugins(HopFileTypePluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IHopFileType fileType = (IHopFileType)registry.loadClass(plugin);
                this.fileTypes.add(fileType);
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Unable to load file type plugin: " + plugin.getIds()[0], (Throwable)e);
            }
        }
        this.fileTypes.add(new GenericFileType());
    }

    private void loadTypeImages(Composite parentComposite) {
        this.typeImageMap = new HashMap<String, Image>();
        int iconSize = (int)(PropsUi.getInstance().getZoomFactor() * 16.0);
        for (IHopFileType fileType : this.fileTypes) {
            String imageFilename = fileType.getFileTypeImage();
            if (imageFilename == null) continue;
            try {
                SvgCacheEntry svgCacheEntry = SvgCache.loadSvg((SvgFile)new SvgFile(imageFilename, fileType.getClass().getClassLoader()));
                SwtUniversalImageSvg imageSvg = new SwtUniversalImageSvg(new SvgImage((Document)svgCacheEntry.getSvgDocument()));
                Image image = imageSvg.getAsBitmapForSize((Device)this.hopGui.getDisplay(), iconSize, iconSize);
                this.typeImageMap.put(fileType.getName(), image);
            }
            catch (Exception e2) {
                this.hopGui.getLog().logError("Error loading image : '" + imageFilename + "' for type '" + fileType.getName() + "'", (Throwable)e2);
            }
        }
        parentComposite.addListener(12, e -> {
            for (Image image : this.typeImageMap.values()) {
                image.dispose();
            }
        });
    }

    public void determineRootFolderName(HopGui hopGui) {
        String oldRootFolder = this.rootFolder;
        String oldRootName = this.rootName;
        this.rootFolder = hopGui.getVariables().getVariable("user.home");
        this.rootName = "Home folder";
        DetermineRootFolderExtension ext = new DetermineRootFolderExtension(hopGui, this.rootFolder, this.rootName);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)hopGui.getVariables(), (String)HopGuiExtensionPoint.HopGuiDetermineExplorerRoot.id, (Object)ext);
            this.rootFolder = ext.rootFolder;
            this.rootName = ext.rootName;
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RootFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RootFolder.Message", (String[])new String[0]), e);
        }
        if (!StringUtils.equals((String)oldRootFolder, (String)this.rootFolder) || !StringUtils.equals((String)oldRootName, (String)this.rootName)) {
            for (IExplorerRootChangedListener listener : this.rootChangedListeners) {
                listener.rootChanged(this.rootFolder, this.rootName);
            }
        }
    }

    protected void createTree(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Composite composite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.tree = new Tree(composite, 772);
        this.tree.setHeaderVisible(false);
        this.tree.addListener(13, event -> this.updateSelection());
        this.tree.addListener(14, this::openFile);
        PropsUi.setLook((Widget)this.tree);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)this.toolBar, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)treeFormData);
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.tree.addListener(17, this::lazyLoadFolderOnExpand);
        TreeMemory.addTreeListener(this.tree, FILE_EXPLORER_TREE);
        GuiRegistry.getInstance().executeCallbackMethods(GUI_TOOLBAR_CREATED_CALLBACK_ID);
    }

    private void lazyLoadFolderOnExpand(Event event) {
        TreeItem item = (TreeItem)event.item;
        TreeItemFolder treeItemFolder = (TreeItemFolder)item.getData();
        if (treeItemFolder != null && !treeItemFolder.loaded) {
            BusyIndicator.showWhile((Display)this.hopGui.getDisplay(), () -> {
                this.refreshFolder(item, treeItemFolder.path, treeItemFolder.depth + 1);
                treeItemFolder.loaded = true;
            });
        }
    }

    private void openFile(Event event) {
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            TreeItemFolder tif = (TreeItemFolder)item.getData();
            if (tif.folder) {
                if (!item.getExpanded()) {
                    this.lazyLoadFolderOnExpand(event);
                    item.setExpanded(true);
                } else {
                    item.setExpanded(false);
                }
                TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, item.getExpanded());
            } else {
                this.openFile(item);
            }
        }
    }

    private void openFile(TreeItem item) {
        try {
            TreeItemFolder tif = (TreeItemFolder)item.getData();
            if (tif != null && tif.fileType != null) {
                if (tif.fileType instanceof FolderFileType) {
                    boolean expanded = !item.getExpanded();
                    item.setExpanded(expanded);
                    TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, expanded);
                } else {
                    IHopFileTypeHandler handler = tif.fileType.openFile(this.hopGui, tif.path, this.hopGui.getVariables());
                    if (handler != null) {
                        this.updateGui();
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.OpenFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.OpenFile.Message", (String[])new String[0]), e);
        }
    }

    private void deleteFile(TreeItem item) {
        try {
            TreeItemFolder tif = (TreeItemFolder)item.getData();
            if (tif != null && tif.fileType != null) {
                FileObject fileObject;
                boolean deleted;
                MessageBox box = new MessageBox(this.hopGui.getShell(), 196);
                box.setText(BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFile.Confirmation.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFile.Confirmation.Message", (String[])new String[0]) + Const.CR + Const.CR + tif.path);
                int answer = box.open();
                if ((answer & 0x40) != 0 && (deleted = (fileObject = HopVfs.getFileObject((String)tif.path)).delete())) {
                    this.refresh();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.DeleteFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.DeleteFile.Message", (String[])new String[0]), e);
        }
    }

    private void renameFile(TreeItem item) {
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.fileType != null) {
            Text text = new Text((Composite)this.tree, 2048);
            text.setText(item.getText());
            text.addListener(16, event -> text.dispose());
            text.addListener(2, event -> {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if (item.getText().equals(text.getText())) break;
                        try {
                            FileObject fileObject = HopVfs.getFileObject((String)tif.path);
                            FileObject newObject = HopVfs.getFileObject((String)(HopVfs.getFilename((FileObject)fileObject.getParent()) + "/" + text.getText()));
                            fileObject.moveTo(newObject);
                            break;
                        }
                        catch (Exception e) {
                            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RenameFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RenameFile.Message", (String[])new String[0]), e);
                            break;
                        }
                        finally {
                            text.dispose();
                            this.refresh();
                        }
                    }
                    case 27: {
                        text.dispose();
                    }
                }
            });
            text.selectAll();
            text.setFocus();
            this.treeEditor.setEditor((Control)text, item);
        }
    }

    protected void createTabFolder(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        this.tabFolder = new CTabFolder(parent, 2050);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                ExplorerPerspective.this.onTabClose(event);
            }
        });
        this.tabFolder.addListener(13, this::handleTabSelectionEvent);
        PropsUi.setLook((Widget)this.tabFolder, 4);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(GuiResource.getInstance().getImageMinimizePanel());
        item.addListener(13, e -> {
            if (this.sash.getMaximizedControl() == null) {
                this.sash.setMaximizedControl((Control)this.tabFolder);
                item.setImage(GuiResource.getInstance().getImageMaximizePanel());
            } else {
                this.sash.setMaximizedControl(null);
                item.setImage(GuiResource.getInstance().getImageMinimizePanel());
            }
        });
        this.tabFolder.setTopRight((Control)toolBar, 131072);
        new TabCloseHandler(this);
        new TabFolderReorder(this.tabFolder);
    }

    @Override
    public void closeTab(CTabFolderEvent event, CTabItem tabItem) {
        ExplorerFile file = (ExplorerFile)tabItem.getData();
        if (file.getFileTypeHandler().isCloseable()) {
            this.files.remove(file);
            tabItem.dispose();
            try {
                this.hopGui.fileRefreshDelegate.remove(HopVfs.getFileObject((String)file.getFileTypeHandler().getFilename()).getPublicURIString());
            }
            catch (HopFileException e) {
                this.hopGui.getLog().logError("Error getting VFS fileObject", (Throwable)e);
            }
            this.refresh();
            if (this.tabFolder.getItemCount() == 0) {
                HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
            }
            this.updateGui();
        } else if (event != null) {
            event.doit = false;
        }
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    private void handleTabSelectionEvent(Event event) {
        if (event.item instanceof CTabItem) {
            CTabItem tabItem = (CTabItem)event.item;
            ExplorerFile explorerFile = (ExplorerFile)tabItem.getData();
            this.selectInTree(explorerFile.getFilename());
            this.updateGui();
        }
    }

    public void addFile(ExplorerFile explorerFile) {
        if (this.files.contains(explorerFile)) {
            return;
        }
        final CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        tabItem.setText(Const.NVL((String)explorerFile.getName(), (String)""));
        if (explorerFile.getTabImage() != null) {
            tabItem.setImage(explorerFile.getTabImage());
        } else {
            tabItem.setImage(GuiResource.getInstance().getImageFile());
        }
        tabItem.setToolTipText(explorerFile.getFilename());
        tabItem.setData((Object)explorerFile);
        explorerFile.addContentChangedListener(new IContentChangedListener(){

            public void contentChanged(Object parentObject) {
                tabItem.setFont(GuiResource.getInstance().getFontBold());
            }

            public void contentSafe(Object parentObject) {
                tabItem.setFont(ExplorerPerspective.this.tabFolder.getFont());
            }
        });
        PropsUi props = PropsUi.getInstance();
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        FormLayout layoutComposite = new FormLayout();
        layoutComposite.marginWidth = PropsUi.getFormMargin();
        layoutComposite.marginHeight = PropsUi.getFormMargin();
        composite.setLayout((Layout)layoutComposite);
        PropsUi.setLook((Widget)composite);
        IExplorerFileTypeHandler renderer = explorerFile.getFileTypeHandler();
        renderer.renderFile(composite);
        Composite area = new Composite(composite, 0);
        FormLayout layoutArea = new FormLayout();
        layoutArea.marginWidth = 0;
        layoutArea.marginHeight = 0;
        area.setLayout((Layout)layoutArea);
        FormData fdArea = new FormData();
        fdArea.left = new FormAttachment(0, 0);
        fdArea.top = new FormAttachment(0, 0);
        fdArea.right = new FormAttachment(100, 0);
        fdArea.bottom = new FormAttachment(100, 0);
        area.setLayoutData((Object)fdArea);
        PropsUi.setLook((Widget)area);
        tabItem.setControl((Control)composite);
        tabItem.setData((Object)explorerFile);
        this.files.add(explorerFile);
        this.hopGui.fileRefreshDelegate.register(explorerFile.getFilename(), renderer);
        if (!this.isActive()) {
            this.activate();
        }
        this.tabFolder.setSelection(tabItem);
        this.selectInTree(explorerFile.getFilename());
        this.updateGui();
    }

    public void refreshFileContent() {
        this.tabFolder.getChildren();
    }

    private void selectInTree(String filename) {
        for (TreeItem item : this.tree.getItems()) {
            if (this.selectInTree(item, filename)) break;
        }
    }

    private boolean selectInTree(TreeItem item, String filename) {
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.path.equals(filename)) {
            this.tree.setSelection(tif.treeItem);
            return true;
        }
        for (TreeItem child : item.getItems()) {
            if (!this.selectInTree(child, filename)) continue;
            return true;
        }
        return false;
    }

    public ExplorerFile getSelectedFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return null;
        }
        TreeItem item = selection[0];
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null) {
            Image image = this.getFileTypeImage(tif.fileType);
            return new ExplorerFile(tif.name, image, tif.path, null, null);
        }
        return null;
    }

    public void setActiveFile(ExplorerFile file) {
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!item.getData().equals(file)) continue;
            this.tabFolder.setSelection(item);
            this.tabFolder.showItem(item);
            HopGui.getInstance().handleFileCapabilities(this.explorerFileType, file.isChanged(), false, false);
        }
    }

    public ExplorerFile getActiveFile() {
        if (this.tabFolder.getSelectionIndex() < 0) {
            return null;
        }
        return (ExplorerFile)this.tabFolder.getSelection().getData();
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        ExplorerFile explorerFile = this.getActiveFile();
        if (explorerFile != null) {
            return explorerFile.getFileTypeHandler();
        }
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler fileTypeHandler) {
        if (fileTypeHandler instanceof ExplorerFile) {
            this.setActiveFile((ExplorerFile)((Object)fileTypeHandler));
        }
    }

    protected void onTabClose(CTabFolderEvent event) {
        CTabItem tabItem = (CTabItem)event.item;
        this.closeTab(event, tabItem);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10000-Open", toolTip="i18n::ExplorerPerspective.ToolbarElement.Open.Tooltip", image="ui/images/arrow-right.svg")
    public void openFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.openFile(selection[0]);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10050-CreateFolder", toolTip="i18n::ExplorerPerspective.ToolbarElement.CreateFolder.Tooltip", image="ui/images/folder-add.svg")
    public void createFolder() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TreeItem item = selection[0];
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif == null) {
            return;
        }
        EnterStringDialog dialog = new EnterStringDialog(this.getShell(), "", BaseMessages.getString(PKG, (String)"ExplorerPerspective.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.CreateFolder.Message", (String[])new String[]{tif.path}));
        String folder = dialog.open();
        if (folder != null) {
            Object newPath = tif.path;
            if (!((String)newPath).endsWith("/") && !((String)newPath).endsWith("\\")) {
                newPath = (String)newPath + "/";
            }
            newPath = (String)newPath + folder;
            try {
                FileObject newFolder = HopVfs.getFileObject((String)newPath);
                newFolder.createFolder();
                this.refresh();
            }
            catch (Throwable e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.CreateFolder.Message", (String[])new String[]{newPath}), e);
            }
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10100-Delete", toolTip="i18n::ExplorerPerspective.ToolbarElement.Delete.Tooltip", image="ui/images/delete.svg", separator=true)
    @GuiKeyboardShortcut(key=127)
    @GuiOsxKeyboardShortcut(key=127)
    public void deleteFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.deleteFile(selection[0]);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10200-Rename", toolTip="i18n::ExplorerPerspective.ToolbarElement.Rename.Tooltip", image="ui/images/rename.svg", separator=false)
    @GuiKeyboardShortcut(key=0x100000B)
    @GuiOsxKeyboardShortcut(key=0x100000B)
    public void renameFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.renameFile(selection[0]);
    }

    public void onNewFile() {
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10300-Refresh", toolTip="i18n::ExplorerPerspective.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        try {
            this.determineRootFolderName(this.hopGui);
            for (IExplorerRefreshListener listener : this.refreshListeners) {
                listener.beforeRefresh();
            }
            this.tree.setRedraw(false);
            this.tree.removeAll();
            TreeItem rootItem = new TreeItem(this.tree, 0);
            rootItem.setText(Const.NVL((String)this.rootName, (String)""));
            IHopFileType fileType = this.getFileType(this.rootFolder);
            this.setItemImage(rootItem, fileType);
            this.callPaintListeners(this.tree, rootItem, this.rootFolder, this.rootName, fileType);
            this.setTreeItemData(rootItem, this.rootFolder, this.rootName, fileType, 0, true, true);
            this.refreshFolder(rootItem, this.rootFolder, 0);
            this.tree.setRedraw(true);
            TreeMemory.setExpandedFromMemory(this.tree, FILE_EXPLORER_TREE);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.TreeRefresh.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.TreeRefresh.Message", (String[])new String[0]), e);
        }
        this.updateSelection();
        this.treeIsFresh = true;
    }

    private void setTreeItemData(TreeItem treeItem, String path, String name, IHopFileType fileType, int depth, boolean folder, boolean loaded) {
        treeItem.setData((Object)new TreeItemFolder(treeItem, path, name, fileType, depth, folder, loaded));
    }

    private void setItemImage(TreeItem treeItem, IHopFileType fileType) {
        Image image = this.typeImageMap.get(fileType.getName());
        if (image != null) {
            treeItem.setImage(image);
        }
    }

    public Image getFileTypeImage(IHopFileType fileType) {
        return this.typeImageMap.get(fileType.getName());
    }

    public IHopFileType getFileType(String path) throws HopException {
        for (IHopFileType hopFileType : this.fileTypes) {
            if (!hopFileType.isHandledBy(path, false)) continue;
            return hopFileType;
        }
        return new EmptyFileType();
    }

    private void refreshFolder(TreeItem item, String path, int depth) {
        try {
            for (TreeItem child : item.getItems()) {
                child.dispose();
            }
            FileObject fileObject = HopVfs.getFileObject((String)path);
            FileObject[] children = fileObject.getChildren();
            Arrays.sort(children, Comparator.comparing(Object::toString));
            for (boolean folder : new boolean[]{true, false}) {
                for (FileObject child : children) {
                    if (child.isHidden() || child.isFolder() != folder) continue;
                    String childPath = child.toString();
                    String childName = child.getName().getBaseName();
                    IHopFileType fileType = this.getFileType(childPath);
                    TreeItem childItem = new TreeItem(item, 0);
                    childItem.setText(childName);
                    this.setItemImage(childItem, fileType);
                    this.callPaintListeners(this.tree, childItem, childPath, childName, fileType);
                    this.setTreeItemData(childItem, childPath, childName, fileType, depth, folder, true);
                    if (!child.isFolder()) continue;
                    String maxDepthString = ExplorerPerspectiveConfigSingleton.getConfig().getLazyLoadingDepth();
                    int maxDepth = Const.toInt((String)this.hopGui.getVariables().resolve(maxDepthString), (int)0);
                    if (depth + 1 <= maxDepth) {
                        childItem.setData((Object)new TreeItemFolder(childItem, child.getName().getURI(), childName, fileType, depth, folder, true));
                        this.refreshFolder(childItem, childPath, depth + 1);
                        continue;
                    }
                    childItem.setData((Object)new TreeItemFolder(childItem, child.getName().getURI(), childName, fileType, depth, folder, false));
                    new TreeItem(childItem, 0);
                    childItem.setExpanded(false);
                    TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, childItem, false);
                }
            }
        }
        catch (Exception e) {
            TreeItem treeItem = new TreeItem(item, 0);
            treeItem.setText("!!Error refreshing folder!!");
            this.hopGui.getLog().logError("Error refresh folder '" + path + "'", (Throwable)e);
        }
    }

    private void callPaintListeners(Tree tree, TreeItem treeItem, String path, String name, IHopFileType fileType) {
        for (IExplorerFilePaintListener filePaintListener : this.filePaintListeners) {
            filePaintListener.filePainted(tree, treeItem, path, name);
        }
    }

    public void updateSelection() {
        TreeItem selectedItem;
        TreeItemFolder tif = null;
        if (this.tree.getSelectionCount() > 0 && (tif = (TreeItemFolder)(selectedItem = this.tree.getSelection()[0]).getData()) == null) {
            return;
        }
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_OPEN, tif != null);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DELETE, tif != null);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_RENAME, tif != null);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_CREATE_FOLDER, tif != null && tif.fileType instanceof FolderFileType);
        for (IExplorerSelectionListener listener : this.selectionListeners) {
            listener.fileSelected();
        }
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        BaseExplorerFileTypeHandler fileTypeHandler;
        if (typeHandler instanceof BaseExplorerFileTypeHandler && (fileTypeHandler = (BaseExplorerFileTypeHandler)typeHandler).isCloseable()) {
            ExplorerFile file = fileTypeHandler.getExplorerFile();
            this.files.remove(file);
            for (CTabItem item : this.tabFolder.getItems()) {
                if (!file.equals(item.getData())) continue;
                item.dispose();
            }
            this.refresh();
            this.updateGui();
        }
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        ArrayList<TabItemHandler> items = new ArrayList<TabItemHandler>();
        for (CTabItem tabItem : this.tabFolder.getItems()) {
            for (ExplorerFile file : this.files) {
                if (!tabItem.getData().equals(file)) continue;
                items.add(new TabItemHandler(tabItem, file.getFileTypeHandler()));
            }
        }
        return items;
    }

    @Override
    public void navigateToPreviousFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() - 1);
        this.updateGui();
    }

    @Override
    public void navigateToNextFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() + 1);
        this.updateGui();
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return this.tabFolder.getSelectionIndex() > 0;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return this.tabFolder.getItemCount() > 0 && this.tabFolder.getSelectionIndex() < this.tabFolder.getItemCount() - 1;
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    protected Shell getShell() {
        return this.hopGui.getShell();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }

    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        IHopFileTypeHandler activeHandler = this.getActiveFileTypeHandler();
        activeHandler.updateGui();
    }

    public List<IExplorerRootChangedListener> getRootChangedListeners() {
        return this.rootChangedListeners;
    }

    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }

    public List<IExplorerFilePaintListener> getFilePaintListeners() {
        return this.filePaintListeners;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public String getRootName() {
        return this.rootName;
    }

    public List<IExplorerRefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    public List<IExplorerSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    public Tree getTree() {
        return this.tree;
    }

    public static class DetermineRootFolderExtension {
        public HopGui hopGui;
        public String rootFolder;
        public String rootName;

        public DetermineRootFolderExtension(HopGui hopGui, String rootFolder, String rootName) {
            this.hopGui = hopGui;
            this.rootFolder = rootFolder;
            this.rootName = rootName;
        }
    }

    private class TreeItemFolder {
        public TreeItem treeItem;
        public String path;
        public String name;
        public IHopFileType fileType;
        public int depth;
        public boolean folder;
        public boolean loaded;

        public TreeItemFolder(TreeItem treeItem, String path, String name, IHopFileType fileType, int depth, boolean folder, boolean loaded) {
            this.treeItem = treeItem;
            this.path = path;
            this.name = name;
            this.fileType = fileType;
            this.depth = depth;
            this.folder = folder;
            this.loaded = loaded;
        }
    }
}

