/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.execution;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.TabFolderReorder;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.apache.hop.ui.hopgui.perspective.TabCloseHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.execution.IExecutionViewer;
import org.apache.hop.ui.hopgui.perspective.execution.PipelineExecutionViewer;
import org.apache.hop.ui.hopgui.perspective.execution.WorkflowExecutionViewer;
import org.apache.hop.workflow.WorkflowMeta;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

@HopPerspectivePlugin(id="150-HopExecutionPerspective", name="i18n::ExecutionPerspective.Name", description="i18n::ExecutionPerspective.Description", image="ui/images/location.svg")
@GuiPlugin
public class ExecutionPerspective
implements IHopPerspective,
TabClosable {
    public static final Class<?> PKG = ExecutionPerspective.class;
    private static final String EXECUTION_PERSPECTIVE_TREE = "Execution perspective tree";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "ExecutionPerspective-Toolbar";
    public static final String TOOLBAR_ITEM_EDIT = "ExecutionPerspective-Toolbar-10010-Edit";
    public static final String TOOLBAR_ITEM_DUPLICATE = "ExecutionPerspective-Toolbar-10030-Duplicate";
    public static final String TOOLBAR_ITEM_DELETE = "ExecutionPerspective-Toolbar-10040-Delete";
    public static final String TOOLBAR_ITEM_REFRESH = "ExecutionPerspective-Toolbar-10100-Refresh";
    public static final String KEY_HELP = "Help";
    private static ExecutionPerspective instance;
    private HopGui hopGui;
    private SashForm sash;
    private Tree tree;
    private CTabFolder tabFolder;
    private ToolBar toolBar;
    private GuiToolbarWidgets toolBarWidgets;
    private List<IExecutionViewer> viewers = new ArrayList<IExecutionViewer>();
    private Map<String, ExecutionInfoLocation> locationMap;

    public static ExecutionPerspective getInstance() {
        return instance;
    }

    public ExecutionPerspective() {
        instance = this;
    }

    @Override
    public String getId() {
        return "execution-perspective";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=105)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=105)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.refresh();
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.emptyList();
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.locationMap = new HashMap<String, ExecutionInfoLocation>();
        this.sash = new SashForm(parent, 256);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment(0, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.createTree((Composite)this.sash);
        this.createTabFolder((Composite)this.sash);
        this.sash.setWeights(new int[]{20, 80});
        this.refresh();
        for (TreeItem item : this.tree.getItems()) {
            TreeMemory.getInstance().storeExpanded(EXECUTION_PERSPECTIVE_TREE, item, true);
        }
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    protected MetadataManager<IHopMetadata> getMetadataManager(String objectKey) throws HopException {
        MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
        Class metadataClass = metadataProvider.getMetadataClassForKey(objectKey);
        return new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass, this.hopGui.getShell());
    }

    protected void createTree(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Composite composite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.tree = new Tree(composite, 772);
        this.tree.setHeaderVisible(false);
        this.tree.addListener(14, event -> {
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null) {
                this.onNewViewer();
            }
        });
        PropsUi.setLook((Widget)this.tree);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)this.toolBar, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)treeFormData);
        TreeMemory.addTreeListener(this.tree, EXECUTION_PERSPECTIVE_TREE);
    }

    protected void createTabFolder(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        this.tabFolder = new CTabFolder(parent, 2050);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                ExecutionPerspective.this.onTabClose(event);
            }
        });
        PropsUi.setLook((Widget)this.tabFolder, 4);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(GuiResource.getInstance().getImageMinimizePanel());
        item.addListener(13, e -> {
            if (this.sash.getMaximizedControl() == null) {
                this.sash.setMaximizedControl((Control)this.tabFolder);
                item.setImage(GuiResource.getInstance().getImageMaximizePanel());
            } else {
                this.sash.setMaximizedControl(null);
                item.setImage(GuiResource.getInstance().getImageMinimizePanel());
            }
        });
        this.tabFolder.setTopRight((Control)toolBar, 131072);
        new TabCloseHandler(this);
        new TabFolderReorder(this.tabFolder);
    }

    public void addViewer(IExecutionViewer viewer) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        tabItem.setText(viewer.getName());
        tabItem.setImage(viewer.getTitleImage());
        tabItem.setToolTipText(viewer.getTitleToolTip());
        tabItem.setControl(viewer.getControl());
        tabItem.setData((Object)viewer);
        this.viewers.add(viewer);
        this.activate();
        this.tabFolder.setSelection(tabItem);
        viewer.setFocus();
        viewer.refresh();
    }

    public IExecutionViewer findViewer(String logChannelId, String name) {
        if (logChannelId == null || name == null) {
            return null;
        }
        for (IExecutionViewer viewer : this.viewers) {
            if (!logChannelId.equals(viewer.getLogChannelId()) || !name.equals(viewer.getName())) continue;
            return viewer;
        }
        return null;
    }

    public void setActiveViewer(IExecutionViewer viewer) {
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!item.getData().equals(viewer)) continue;
            this.tabFolder.setSelection(item);
            this.tabFolder.showItem(item);
            viewer.setFocus();
        }
    }

    public IExecutionViewer getActiveViewer() {
        if (this.tabFolder.getSelectionIndex() < 0) {
            return null;
        }
        return (IExecutionViewer)this.tabFolder.getSelection().getData();
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler fileTypeHandler) {
    }

    protected void onTabClose(CTabFolderEvent event) {
        CTabItem tabItem = (CTabItem)event.item;
        this.closeTab(event, tabItem);
    }

    public void onNewViewer() {
        try {
            if (this.tree.getSelectionCount() != 1) {
                return;
            }
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null) {
                if (treeItem.getData() instanceof Execution) {
                    Execution execution = (Execution)treeItem.getData();
                    ExecutionInfoLocation location = (ExecutionInfoLocation)treeItem.getParentItem().getData();
                    ExecutionState executionState = location.getExecutionInfoLocation().getExecutionState(execution.getId());
                    this.createExecutionViewer(location.getName(), execution, executionState);
                } else if (treeItem.getData("error") instanceof Exception) {
                    Exception e = (Exception)treeItem.getData("error");
                    new ErrorDialog(this.getShell(), "Error", "Location error:", e);
                }
            }
        }
        catch (Exception e) {
            this.getShell().setCursor(null);
            new ErrorDialog(this.getShell(), "Error", "Error showing viewer for execution", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createExecutionViewer(String locationName, Execution execution, ExecutionState executionState) throws Exception {
        Cursor busyCursor = this.getBusyCursor();
        try {
            if (locationName == null) return;
            if (execution == null) {
                return;
            }
            this.getShell().setCursor(busyCursor);
            IExecutionViewer active = this.findViewer(execution.getId(), execution.getName());
            if (active != null) {
                this.setActiveViewer(active);
                return;
            }
            SerializableMetadataProvider provider = new SerializableMetadataProvider(execution.getMetadataJson());
            IVariables variables = Variables.getADefaultVariableSpace();
            variables.setVariables(execution.getVariableValues());
            switch (execution.getExecutionType()) {
                case Pipeline: {
                    Node pipelineNode = XmlHandler.loadXmlString((String)execution.getExecutorXml(), (String)"pipeline");
                    PipelineMeta pipelineMeta = new PipelineMeta(pipelineNode, (IHopMetadataProvider)provider);
                    PipelineExecutionViewer viewer = new PipelineExecutionViewer((Composite)this.tabFolder, this.hopGui, pipelineMeta, locationName, this, execution, executionState);
                    this.addViewer(viewer);
                    return;
                }
                case Workflow: {
                    Node workflowNode = XmlHandler.loadXmlString((String)execution.getExecutorXml(), (String)"workflow");
                    WorkflowMeta workflowMeta = new WorkflowMeta(workflowNode, (IHopMetadataProvider)provider, variables);
                    WorkflowExecutionViewer viewer = new WorkflowExecutionViewer((Composite)this.tabFolder, this.hopGui, workflowMeta, locationName, this, execution, executionState);
                    this.addViewer(viewer);
                    return;
                }
            }
            return;
        }
        finally {
            this.getShell().setCursor(null);
            busyCursor.dispose();
        }
    }

    private Cursor getBusyCursor() {
        return new Cursor((Device)this.getShell().getDisplay(), 1);
    }

    public void createLastExecutionView(String locationName, ExecutionType executionType, String name) throws Exception {
        try {
            ExecutionInfoLocation location = this.locationMap.get(locationName);
            if (location == null) {
                return;
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            Execution execution = iLocation.findLastExecution(executionType, name);
            ExecutionState executionState = iLocation.getExecutionState(execution.getId());
            this.createExecutionViewer(location.getName(), execution, executionState);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error opening view on last execution information", e);
        }
    }

    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        IHopFileTypeHandler activeHandler = this.getActiveFileTypeHandler();
        this.hopGui.getDisplay().asyncExec(() -> this.hopGui.handleFileCapabilities(activeHandler.getFileType(), activeHandler.hasChanged(), false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuiToolbarElement(root="ExecutionPerspective-Toolbar", id="ExecutionPerspective-Toolbar-10100-Refresh", toolTip="i18n::ExecutionPerspective.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        Cursor busyCursor = this.getBusyCursor();
        try {
            this.getShell().setCursor(busyCursor);
            for (ExecutionInfoLocation location : this.locationMap.values()) {
                location.getExecutionInfoLocation().close();
            }
            this.locationMap.clear();
            this.tree.setRedraw(false);
            this.tree.removeAll();
            MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(ExecutionInfoLocation.class);
            List locations = serializer.loadAll();
            Collections.sort(locations, Comparator.comparing(HopMetadataBase::getName));
            for (ExecutionInfoLocation location : locations) {
                IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
                try {
                    iLocation.initialize(this.hopGui.getVariables(), (IHopMetadataProvider)this.hopGui.getMetadataProvider());
                    this.locationMap.put(location.getName(), location);
                    TreeItem locationItem = new TreeItem(this.tree, 0);
                    locationItem.setText(0, Const.NVL((String)location.getName(), (String)""));
                    locationItem.setImage(GuiResource.getInstance().getImageLocation());
                    TreeMemory.getInstance().storeExpanded(EXECUTION_PERSPECTIVE_TREE, locationItem, true);
                    locationItem.setData((Object)location);
                    try {
                        List ids = iLocation.getExecutionIds(false, 100);
                        for (String id : ids) {
                            try {
                                Execution execution = iLocation.getExecution(id);
                                if (execution == null) continue;
                                TreeItem executionItem = new TreeItem(locationItem, 0);
                                switch (execution.getExecutionType()) {
                                    case Pipeline: {
                                        this.decoratePipelineTreeItem(executionItem, execution);
                                        break;
                                    }
                                    case Workflow: {
                                        this.decorateWorkflowTreeItem(executionItem, execution);
                                    }
                                }
                            }
                            catch (Exception e) {
                                TreeItem errorItem = new TreeItem(locationItem, 0);
                                errorItem.setText("Error reading " + id + " (double click for details)");
                                errorItem.setForeground(GuiResource.getInstance().getColorRed());
                                errorItem.setData("error", (Object)e);
                                errorItem.setImage(GuiResource.getInstance().getImageError());
                            }
                        }
                    }
                    catch (Exception e) {
                        TreeItem errorItem = new TreeItem(locationItem, 0);
                        errorItem.setText("Not reachable (double click for details)");
                        errorItem.setForeground(GuiResource.getInstance().getColorRed());
                        errorItem.setData("error", (Object)e);
                        errorItem.setImage(GuiResource.getInstance().getImageError());
                    }
                }
                catch (Exception e) {
                    TreeItem locationItem = new TreeItem(this.tree, 0);
                    locationItem.setText(0, Const.NVL((String)location.getName(), (String)"") + " (error: double click for details)");
                    locationItem.setForeground(GuiResource.getInstance().getColorRed());
                    locationItem.setImage(GuiResource.getInstance().getImageLocation());
                    locationItem.setData("error", (Object)e);
                }
            }
            TreeUtil.setOptimalWidthOnColumns(this.tree);
            TreeMemory.setExpandedFromMemory(this.tree, EXECUTION_PERSPECTIVE_TREE);
            this.tree.setRedraw(true);
        }
        catch (Exception e) {
            this.getShell().setCursor(null);
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExecutionPerspective.Refresh.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecutionPerspective.Refresh.Error.Message", (String[])new String[0]), e);
        }
        finally {
            this.getShell().setCursor(null);
        }
    }

    private void decoratePipelineTreeItem(TreeItem executionItem, Execution execution) {
        try {
            executionItem.setImage(GuiResource.getInstance().getImagePipeline());
            Object label = execution.getName();
            label = (String)label + " - " + new SimpleDateFormat("yyyy/MM/dd HH:mm").format(execution.getExecutionStartDate());
            executionItem.setText((String)label);
            executionItem.setData((Object)execution);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error drawing pipeline execution information tree item", e);
        }
    }

    private void decorateWorkflowTreeItem(TreeItem executionItem, Execution execution) {
        try {
            executionItem.setImage(GuiResource.getInstance().getImageWorkflow());
            Object label = execution.getName();
            label = (String)label + " - " + new SimpleDateFormat("yyyy/MM/dd HH:mm").format(execution.getExecutionStartDate());
            executionItem.setText((String)label);
            executionItem.setData((Object)execution);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error drawing workflow execution information tree item", e);
        }
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        MetadataEditor editor;
        if (typeHandler instanceof MetadataEditor && (editor = (MetadataEditor)typeHandler).isCloseable()) {
            this.viewers.remove(editor);
            for (CTabItem item : this.tabFolder.getItems()) {
                if (!editor.equals(item.getData())) continue;
                item.dispose();
            }
        }
        return false;
    }

    @GuiToolbarElement(root="ExecutionPerspective-Toolbar", id="ExecutionPerspective-Toolbar-10040-Delete", toolTip="i18n::ExecutionPerspective.ToolbarElement.Delete.Tooltip", image="ui/images/delete.svg", separator=true)
    @GuiKeyboardShortcut(key=127)
    @GuiOsxKeyboardShortcut(key=127)
    public void delete() {
        try {
            if (this.tree.getSelectionCount() != 1) {
                return;
            }
            TreeItem item = this.tree.getSelection()[0];
            Object itemData = item.getData();
            if (itemData instanceof ExecutionInfoLocation) {
                MessageBox box = new MessageBox(this.getShell(), 65728);
                box.setText("Confirm delete");
                box.setMessage("Are you sure you want to delete all information in this location?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return;
                }
                ExecutionInfoLocation location = (ExecutionInfoLocation)itemData;
                IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
                List executionIds = iLocation.getExecutionIds(false, 0);
                for (int i = executionIds.size() - 1; i >= 0; --i) {
                    iLocation.deleteExecution((String)executionIds.get(i));
                }
                this.refresh();
            } else if (itemData instanceof Execution) {
                Execution execution = (Execution)itemData;
                TreeItem parentItem = item.getParentItem();
                ExecutionInfoLocation location = (ExecutionInfoLocation)parentItem.getData();
                IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
                iLocation.deleteExecution(execution.getId());
                this.refresh();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error deleting location(s)", e);
        }
    }

    @Override
    public List<TabItemHandler> getItems() {
        return Collections.emptyList();
    }

    @Override
    public void navigateToPreviousFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() - 1);
    }

    @Override
    public void navigateToNextFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() + 1);
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        if (this.tabFolder.getItemCount() == 0) {
            return false;
        }
        return this.tabFolder.getSelectionIndex() >= 1;
    }

    @Override
    public boolean hasNavigationNextFile() {
        if (this.tabFolder.getItemCount() == 0) {
            return false;
        }
        return this.tabFolder.getSelectionIndex() < this.tabFolder.getItemCount();
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    protected Shell getShell() {
        return this.hopGui.getShell();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        return handlers;
    }

    @Override
    public List<ISearchable> getSearchables() {
        ArrayList<ISearchable> searchables = new ArrayList<ISearchable>();
        return searchables;
    }

    public Map<String, ExecutionInfoLocation> getLocationMap() {
        return this.locationMap;
    }

    @Override
    public void closeTab(CTabFolderEvent event, CTabItem tabItem) {
        IExecutionViewer viewer = (IExecutionViewer)tabItem.getData();
        boolean isRemoved = this.viewers.remove(viewer);
        tabItem.dispose();
        if (!isRemoved && event != null) {
            event.doit = false;
        }
        if (this.tabFolder.getItemCount() == 0) {
            HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
        }
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }
}

