/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.IDialogClosedListener;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PreviewRowsDialog {
    private static final Class<?> PKG = PreviewRowsDialog.class;
    public static final int MAX_BINARY_STRING_PREVIEW_SIZE = 1000000;
    private String transformName;
    private Label wlFields;
    private TableView wFields;
    private Shell shell;
    private final List<Object[]> buffer;
    private String title;
    private String message;
    private Rectangle bounds;
    private int hscroll;
    private int vscroll;
    private int hmax;
    private int vmax;
    private final String loggingText;
    private boolean proposingToGetMoreRows;
    private boolean proposingToStop;
    private boolean askingForMoreRows;
    private boolean askingToStop;
    private IRowMeta rowMeta;
    private final IVariables variables;
    private final ILogChannel log;
    private boolean dynamic;
    private boolean waitingForRows;
    protected int lineNr;
    private int style = 3312;
    private final Shell parentShell;
    private final List<IDialogClosedListener> dialogClosedListeners;
    private Control bottomButton;

    public PreviewRowsDialog(Shell parent, IVariables variables, int style, String transformName, IRowMeta rowMeta, List<Object[]> rowBuffer) {
        this(parent, variables, style, transformName, rowMeta, rowBuffer, null);
    }

    public PreviewRowsDialog(Shell parent, IVariables variables, int style, String transformName, IRowMeta rowMeta, List<Object[]> rowBuffer, String loggingText) {
        this.transformName = transformName;
        this.buffer = rowBuffer;
        this.loggingText = loggingText;
        this.rowMeta = rowMeta;
        this.variables = variables;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.dialogClosedListeners = new ArrayList<IDialogClosedListener>();
        this.bounds = null;
        this.hscroll = -1;
        this.vscroll = -1;
        this.title = null;
        this.message = null;
        this.log = new LogChannel((Object)"Row Preview");
    }

    public void setTitleMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, this.style);
        PropsUi props = PropsUi.getInstance();
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        if (this.title == null) {
            this.title = BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Title", (String[])new String[0]);
        }
        if (this.message == null) {
            this.message = BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Header", (String[])new String[]{this.transformName});
        }
        if (this.buffer != null) {
            this.message = this.message + " " + BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NrRows", (String[])new String[]{"" + this.buffer.size()});
        }
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button wClose = new Button((Composite)this.shell, 8);
        wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wClose.addListener(13, e -> this.cancel());
        buttons.add(wClose);
        if (!Utils.isEmpty((CharSequence)this.loggingText)) {
            Button wLog = new Button((Composite)this.shell, 8);
            wLog.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.ShowLog", (String[])new String[0]));
            wLog.addListener(13, e -> this.log());
            buttons.add(wLog);
        }
        if (this.proposingToStop) {
            Button wStop = new Button((Composite)this.shell, 8);
            wStop.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Stop.Label", (String[])new String[0]));
            wStop.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Stop.ToolTip", (String[])new String[0]));
            wStop.addListener(13, e -> this.cancel());
            buttons.add(wStop);
        }
        if (this.proposingToGetMoreRows) {
            Button wNext = new Button((Composite)this.shell, 8);
            wNext.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Next.Label", (String[])new String[0]));
            wNext.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Next.ToolTip", (String[])new String[0]));
            wNext.addListener(13, e -> {
                this.askingForMoreRows = true;
                this.close();
            });
            buttons.add(wNext);
        }
        if (this.proposingToGetMoreRows || this.proposingToStop) {
            wClose.setText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Close.Label", (String[])new String[0]));
            wClose.setToolTipText(BaseMessages.getString(PKG, (String)"PreviewRowsDialog.Button.Close.ToolTip", (String[])new String[0]));
        }
        this.bottomButton = (Control)buttons.get(0);
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[buttons.size()]), props.getMargin(), null);
        if (this.addFields()) {
            return;
        }
        KeyAdapter escapeListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    PreviewRowsDialog.this.cancel();
                }
            }
        };
        this.shell.addKeyListener((KeyListener)escapeListener);
        this.wFields.addKeyListener((KeyListener)escapeListener);
        this.wFields.table.addKeyListener((KeyListener)escapeListener);
        buttons.stream().forEach(arg_0 -> PreviewRowsDialog.lambda$open$4((KeyListener)escapeListener, arg_0));
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.close(), c -> this.cancel());
    }

    private void cancel() {
        this.askingToStop = true;
        this.close();
    }

    private boolean addFields() {
        PropsUi props = PropsUi.getInstance();
        int margin = props.getMargin();
        if (this.wlFields == null) {
            this.wlFields = new Label((Composite)this.shell, 16384);
            this.wlFields.setText(this.message);
            PropsUi.setLook((Widget)this.wlFields);
            FormData fdlFields = new FormData();
            fdlFields.left = new FormAttachment(0, 0);
            fdlFields.right = new FormAttachment(100, 0);
            fdlFields.top = new FormAttachment(0, margin);
            this.wlFields.setLayoutData((Object)fdlFields);
        } else {
            this.wFields.dispose();
        }
        if (this.dynamic && this.rowMeta == null) {
            this.rowMeta = new RowMeta();
            this.rowMeta.addValueMeta((IValueMeta)new ValueMetaString("<waiting for rows>"));
            this.waitingForRows = true;
        }
        if (!(this.dynamic || this.buffer != null && this.buffer.size() != 0)) {
            ShowMessageDialog dialog = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NoRows.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PreviewRowsDialog.NoRows.Message", (String[])new String[0]));
            dialog.open();
            this.shell.dispose();
            return true;
        }
        ColumnInfo[] columns = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            IValueMeta v = this.rowMeta.getValueMeta(i);
            columns[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            columns[i].setToolTip(v.toStringMeta());
            columns[i].setValueMeta(v);
        }
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, columns, 0, null, props);
        this.wFields.setShowingBlueNullValues(true);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(this.bottomButton, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        if (this.dynamic) {
            this.shell.layout(true, true);
        }
        return false;
    }

    public void dispose() {
        PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
        this.bounds = this.shell.getBounds();
        this.hscroll = this.wFields.getHorizontalBar().getSelection();
        this.vscroll = this.wFields.getVerticalBar().getSelection();
        this.shell.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        List<Object[]> list = this.buffer;
        synchronized (list) {
            this.shell.getDisplay().asyncExec(() -> {
                this.lineNr = 0;
                for (int i = 0; i < this.buffer.size(); ++i) {
                    TableItem item = i == 0 ? this.wFields.table.getItem(i) : new TableItem(this.wFields.table, 0);
                    Object[] row = this.buffer.get(i);
                    this.getDataForRow(item, row);
                }
                if (!this.wFields.isDisposed()) {
                    this.wFields.optWidth(true, 200);
                }
            });
        }
    }

    protected int getDataForRow(TableItem item, Object[] row) {
        String strNr;
        int nrErrors = 0;
        if (row == null) {
            return nrErrors;
        }
        ++this.lineNr;
        try {
            strNr = this.wFields.getNumberColumn().getValueMeta().getString((Object)this.lineNr);
        }
        catch (Exception e) {
            strNr = Integer.toString(this.lineNr);
        }
        item.setText(0, strNr);
        for (int c = 0; c < this.rowMeta.size(); ++c) {
            String show;
            IValueMeta v = this.rowMeta.getValueMeta(c);
            try {
                show = v.getString(row[c]);
                if (v.isBinary() && show != null && show.length() > 1000000) {
                    show = show.substring(0, 1000000);
                }
            }
            catch (HopValueException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            if (show != null) {
                item.setText(c + 1, show);
                item.setForeground(c + 1, GuiResource.getInstance().getColorBlack());
                continue;
            }
            item.setText(c + 1, "<null>");
            item.setForeground(c + 1, GuiResource.getInstance().getColorBlue());
        }
        return nrErrors;
    }

    private void close() {
        this.transformName = null;
        this.dispose();
    }

    private void log() {
        if (this.loggingText != null) {
            EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"PreviewRowsDialog.ShowLogging.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PreviewRowsDialog.ShowLogging.Message", (String[])new String[0]), this.loggingText);
            etd.open();
        }
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle b) {
        this.bounds = b;
    }

    public int getHScroll() {
        return this.hscroll;
    }

    public void setHScroll(int s) {
        this.hscroll = s;
    }

    public int getVScroll() {
        return this.vscroll;
    }

    public void setVScroll(int s) {
        this.vscroll = s;
    }

    public int getHMax() {
        return this.hmax;
    }

    public void setHMax(int m) {
        this.hmax = m;
    }

    public int getVMax() {
        return this.vmax;
    }

    public void setVMax(int m) {
        this.vmax = m;
    }

    public boolean isAskingForMoreRows() {
        return this.askingForMoreRows;
    }

    public boolean isProposingToGetMoreRows() {
        return this.proposingToGetMoreRows;
    }

    public void setProposingToGetMoreRows(boolean proposingToGetMoreRows) {
        this.proposingToGetMoreRows = proposingToGetMoreRows;
    }

    public boolean isAskingToStop() {
        return this.askingToStop;
    }

    public boolean isProposingToStop() {
        return this.proposingToStop;
    }

    public void setProposingToStop(boolean proposingToStop) {
        this.proposingToStop = proposingToStop;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public synchronized void addDataRow(IRowMeta rowMeta, Object[] rowData) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        HopGui.getInstance().getDisplay().syncExec(() -> {
            if (this.wFields.isDisposed()) {
                return;
            }
            if (this.waitingForRows) {
                this.rowMeta = rowMeta;
                this.addFields();
            }
            TableItem item = new TableItem(this.wFields.table, 0);
            this.getDataForRow(item, rowData);
            if (this.waitingForRows) {
                this.waitingForRows = false;
                this.wFields.removeEmptyRows();
                this.rowMeta = rowMeta;
                if (this.wFields.table.getItemCount() < 10) {
                    this.wFields.optWidth(true);
                }
            }
            if (this.wFields.table.getItemCount() > PropsUi.getInstance().getDefaultPreviewSize()) {
                this.wFields.table.remove(0);
            }
            this.wFields.table.setTopIndex(this.wFields.table.getItemCount() - 1);
        });
    }

    public void addDialogClosedListener(IDialogClosedListener listener) {
        this.dialogClosedListeners.add(listener);
    }

    private static /* synthetic */ void lambda$open$4(KeyListener escapeListener, Button b) {
        b.addKeyListener(escapeListener);
    }
}

