/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.compress.CompressionOutputStream;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.zip.ZipCompressionProvider;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.fileinput.CharsetToolkit;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileField;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutputData;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileOutputMeta;

public class TextFileOutput<Meta extends TextFileOutputMeta, Data extends TextFileOutputData>
extends BaseTransform<Meta, Data> {
    private static final Class<?> PKG = TextFileOutputMeta.class;
    private static final String FILE_COMPRESSION_TYPE_NONE = TextFileOutputMeta.fileCompressionTypeCodes[0];

    public TextFileOutput(TransformMeta transformMeta, Meta meta, Data data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    private void initFieldNumbers(IRowMeta outputRowMeta, TextFileField[] outputFields) throws HopException {
        ((TextFileOutputData)this.data).fieldnrs = new int[outputFields.length];
        for (int i = 0; i < outputFields.length; ++i) {
            ((TextFileOutputData)this.data).fieldnrs[i] = outputRowMeta.indexOfValue(outputFields[i].getName());
            if (((TextFileOutputData)this.data).fieldnrs[i] >= 0) continue;
            throw new HopTransformException("Field [" + outputFields[i].getName() + "] couldn't be found in the input stream!");
        }
    }

    public boolean isFileExists(String filename) throws HopException {
        try {
            return this.getFileObject(filename, (IVariables)this).exists();
        }
        catch (Exception e) {
            throw new HopException("Error opening new file : " + e.toString());
        }
    }

    private ICompressionProvider getCompressionProvider() throws HopException {
        ICompressionProvider compressionProvider;
        String compressionType = ((TextFileOutputMeta)this.meta).getFileCompression();
        if (Utils.isEmpty((CharSequence)compressionType)) {
            compressionType = FILE_COMPRESSION_TYPE_NONE;
        }
        if ((compressionProvider = CompressionProviderFactory.getInstance().getCompressionProviderByName(compressionType)) == null) {
            throw new HopException("No compression provider found with name = " + compressionType);
        }
        if (!compressionProvider.supportsOutput()) {
            throw new HopException("Compression provider " + compressionType + " does not support output streams!");
        }
        return compressionProvider;
    }

    public void initFileStreamWriter(String filename) throws HopException {
        ((TextFileOutputData)this.data).writer = null;
        try {
            TextFileOutputData.FileStream fileStreams = null;
            try {
                boolean writingToFileForFirstTime;
                if (((TextFileOutputData)this.data).splitEvery > 0) {
                    if (filename.equals(((TextFileOutputData)this.data).getFileStreamsCollection().getLastFileName())) {
                        fileStreams = ((TextFileOutputData)this.data).getFileStreamsCollection().getLastStream();
                    }
                } else {
                    fileStreams = ((TextFileOutputData)this.data).getFileStreamsCollection().getStream(filename);
                }
                boolean bl = writingToFileForFirstTime = fileStreams == null;
                if (writingToFileForFirstTime) {
                    if (((TextFileOutputMeta)this.meta).isAddToResultFiles()) {
                        ResultFile resultFile = new ResultFile(0, this.getFileObject(filename, (IVariables)this), this.getPipelineMeta().getName(), this.getTransformName());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"TextFileOutput.AddResultFile", (String[])new String[0]));
                        this.addResultFile(resultFile);
                    }
                    ICompressionProvider compressionProvider = this.getCompressionProvider();
                    boolean isZipFile = compressionProvider instanceof ZipCompressionProvider;
                    boolean createParentDirIfNotExists = ((TextFileOutputMeta)this.meta).isCreateParentFolder();
                    boolean appendToExistingFile = ((TextFileOutputMeta)this.meta).isFileAppended();
                    if (appendToExistingFile && isZipFile && this.isFileExists(filename)) {
                        throw new HopException("Can not append to an existing zip file : " + filename);
                    }
                    int maxOpenFiles = this.getMaxOpenFiles();
                    if (maxOpenFiles > 0 && ((TextFileOutputData)this.data).getFileStreamsCollection().getNumOpenFiles() >= maxOpenFiles) {
                        ((TextFileOutputData)this.data).getFileStreamsCollection().closeOldestOpenFile(isZipFile);
                    }
                    if (createParentDirIfNotExists && (((TextFileOutputData)this.data).getFileStreamsCollection().size() == 0 || ((TextFileOutputMeta)this.meta).isFileNameInField())) {
                        this.createParentFolder(filename);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opening output stream using provider: " + compressionProvider.getName());
                    }
                    OutputStream fileOutputStream = this.getOutputStream(filename, (IVariables)this, !isZipFile && appendToExistingFile);
                    CompressionOutputStream compressionOutputStream = compressionProvider.createOutputStream(fileOutputStream);
                    compressionOutputStream.addEntry(filename, this.resolve(((TextFileOutputMeta)this.meta).getExtension()));
                    if (this.log.isDetailed()) {
                        if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEncoding())) {
                            this.logDetailed("Opening output stream in encoding: " + ((TextFileOutputMeta)this.meta).getEncoding());
                        } else {
                            this.logDetailed("Opening output stream in default encoding");
                        }
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)compressionOutputStream, 5000);
                    TextFileOutputData textFileOutputData = (TextFileOutputData)this.data;
                    Objects.requireNonNull(textFileOutputData);
                    fileStreams = new TextFileOutputData.FileStream(textFileOutputData, fileOutputStream, compressionOutputStream, bufferedOutputStream);
                    ((TextFileOutputData)this.data).getFileStreamsCollection().add(filename, fileStreams);
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opened new file with name [" + HopVfs.getFriendlyURI((String)filename) + "]");
                    }
                } else if (fileStreams.getBufferedOutputStream() == null) {
                    int maxOpenFiles = this.getMaxOpenFiles();
                    if (maxOpenFiles > 0 && ((TextFileOutputData)this.data).getFileStreamsCollection().getNumOpenFiles() >= maxOpenFiles) {
                        ((TextFileOutputData)this.data).getFileStreamsCollection().closeOldestOpenFile(false);
                    }
                    OutputStream fileOutputStream = this.getOutputStream(filename, (IVariables)this, true);
                    ICompressionProvider compressionProvider = this.getCompressionProvider();
                    CompressionOutputStream compressionOutputStream = compressionProvider.createOutputStream(fileOutputStream);
                    compressionOutputStream.addEntry(filename, this.resolve(((TextFileOutputMeta)this.meta).getExtension()));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)compressionOutputStream, 5000);
                    fileStreams.setFileOutputStream(fileOutputStream);
                    fileStreams.setCompressedOutputStream(compressionOutputStream);
                    fileStreams.setBufferedOutputStream(bufferedOutputStream);
                }
            }
            catch (Exception e) {
                if (!(e instanceof HopException)) {
                    throw new HopException("Error opening new file : " + e.toString());
                }
                throw (HopException)((Object)e);
            }
            fileStreams.setDirty(true);
            ((TextFileOutputData)this.data).fos = fileStreams.getFileOutputStream();
            ((TextFileOutputData)this.data).out = fileStreams.getCompressedOutputStream();
            ((TextFileOutputData)this.data).writer = fileStreams.getBufferedOutputStream();
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException("Error opening new file : " + e.toString());
        }
    }

    public String getOutputFileName(Object[] row) throws HopException {
        String filename = null;
        if (row == null) {
            if (((TextFileOutputData)this.data).writer != null) {
                filename = ((TextFileOutputData)this.data).getFileStreamsCollection().getLastFileName();
            } else {
                filename = ((TextFileOutputMeta)this.meta).getFileName();
                if (filename == null) {
                    throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameNotSet", (String[])new String[0]));
                }
                filename = this.buildFilename(this.resolve(filename), true);
            }
        } else {
            ((TextFileOutputData)this.data).fileNameFieldIndex = this.getInputRowMeta().indexOfValue(((TextFileOutputMeta)this.meta).getFileNameField());
            if (((TextFileOutputData)this.data).fileNameFieldIndex < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameFieldNotFound", (String[])new String[]{((TextFileOutputMeta)this.meta).getFileNameField()}));
            }
            ((TextFileOutputData)this.data).fileNameMeta = this.getInputRowMeta().getValueMeta(((TextFileOutputData)this.data).fileNameFieldIndex);
            ((TextFileOutputData)this.data).fileName = ((TextFileOutputData)this.data).fileNameMeta.getString(row[((TextFileOutputData)this.data).fileNameFieldIndex]);
            if (((TextFileOutputData)this.data).fileName == null) {
                throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameNotSet", (String[])new String[0]));
            }
            filename = this.buildFilename(this.resolve(((TextFileOutputData)this.data).fileName), true);
        }
        return filename;
    }

    public int getFlushInterval() {
        String var = this.variables.getVariable("HOP_FILE_OUTPUT_MAX_STREAM_LIFE");
        int flushInterval = 0;
        if (var != null) {
            try {
                flushInterval = Integer.parseInt(var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flushInterval;
    }

    public int getMaxOpenFiles() {
        String var = this.variables.getVariable("HOP_FILE_OUTPUT_MAX_STREAM_COUNT");
        int maxStreamCount = 0;
        if (var != null) {
            try {
                maxStreamCount = Integer.parseInt(var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxStreamCount;
    }

    public boolean isWriteHeader(String filename) throws HopException {
        boolean writingToFileForFirstTime = this.first;
        boolean isWriteHeader = ((TextFileOutputMeta)this.meta).isHeaderEnabled();
        if (isWriteHeader) {
            writingToFileForFirstTime = ((TextFileOutputData)this.data).splitEvery > 0 ? (writingToFileForFirstTime |= !filename.equals(((TextFileOutputData)this.data).getFileStreamsCollection().getLastFileName())) : (writingToFileForFirstTime |= ((TextFileOutputData)this.data).getFileStreamsCollection().getStream(filename) == null);
        }
        return isWriteHeader &= writingToFileForFirstTime && (!((TextFileOutputMeta)this.meta).isFileAppended() || !this.isFileExists(filename));
    }

    private boolean writeRowToFile(Object[] row) throws HopException {
        if (row != null) {
            int flushInterval;
            String filename = this.getOutputFileName((Object[])(((TextFileOutputMeta)this.meta).isFileNameInField() ? row : null));
            boolean isWriteHeader = this.isWriteHeader(filename);
            if (((TextFileOutputData)this.data).writer == null || ((TextFileOutputMeta)this.meta).isFileNameInField()) {
                this.initFileStreamWriter(filename);
            }
            this.first = false;
            if (isWriteHeader) {
                this.writeHeader();
            }
            if (!((TextFileOutputMeta)this.meta).isFileNameInField() && this.getLinesOutput() > 0L && ((TextFileOutputData)this.data).splitEvery > 0 && (this.getLinesOutput() + (long)((TextFileOutputMeta)this.meta).getFooterShift()) % (long)((TextFileOutputData)this.data).splitEvery == 0L) {
                if (((TextFileOutputMeta)this.meta).isFooterEnabled()) {
                    this.writeHeader();
                }
                this.closeFile(filename);
                ++((TextFileOutputData)this.data).splitnr;
                ((TextFileOutputData)this.data).fos = null;
                ((TextFileOutputData)this.data).out = null;
                ((TextFileOutputData)this.data).writer = null;
                filename = this.getOutputFileName(null);
                isWriteHeader = this.isWriteHeader(filename);
                this.initFileStreamWriter(filename);
                if (isWriteHeader) {
                    this.writeHeader();
                }
            }
            this.writeRow(((TextFileOutputData)this.data).outputRowMeta, row);
            this.putRow(((TextFileOutputData)this.data).outputRowMeta, row);
            if (this.checkFeedback(this.getLinesOutput())) {
                this.logBasic("linenr " + this.getLinesOutput());
            }
            if ((flushInterval = this.getFlushInterval()) > 0) {
                long currentTime = new Date().getTime();
                if (((TextFileOutputData)this.data).lastFileFlushTime == 0L) {
                    ((TextFileOutputData)this.data).lastFileFlushTime = currentTime;
                } else if (((TextFileOutputData)this.data).lastFileFlushTime - currentTime > (long)flushInterval) {
                    try {
                        ((TextFileOutputData)this.data).getFileStreamsCollection().flushOpenFiles(false);
                    }
                    catch (IOException e) {
                        throw new HopException("Unable to flush open files", (Throwable)e);
                    }
                    ((TextFileOutputData)this.data).lastFileFlushTime = new Date().getTime();
                }
            }
            return true;
        }
        if (((TextFileOutputData)this.data).writer != null) {
            if (((TextFileOutputData)this.data).outputRowMeta != null && ((TextFileOutputMeta)this.meta).isFooterEnabled()) {
                this.writeHeader();
            }
        } else if (!Utils.isEmpty((CharSequence)this.resolve(((TextFileOutputMeta)this.meta).getEndedLine())) && !((TextFileOutputMeta)this.meta).isFileNameInField()) {
            String filename = this.getOutputFileName(null);
            this.initFileStreamWriter(filename);
            this.initBinaryDataFields();
        }
        if (((TextFileOutputData)this.data).writer != null) {
            this.writeEndedLine();
        }
        try {
            this.flushOpenFiles(true);
        }
        catch (IOException e) {
            throw new HopException("Unable to flush open files", (Throwable)e);
        }
        this.setOutputDone();
        return false;
    }

    public void flushOpenFiles(boolean closeAfterFlush) throws IOException {
        ((TextFileOutputData)this.data).getFileStreamsCollection().flushOpenFiles(true);
    }

    public synchronized boolean processRow() throws HopException {
        Object[] row;
        if (((TextFileOutputMeta)this.meta).getEncoding() == null || ((TextFileOutputMeta)this.meta).getEncoding().isEmpty()) {
            ((TextFileOutputMeta)this.meta).setEncoding(CharsetToolkit.getDefaultSystemCharset().name());
        }
        if ((row = this.getRow()) != null && this.first) {
            ((TextFileOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        }
        if (this.first) {
            this.initBinaryDataFields();
            if (((TextFileOutputData)this.data).outputRowMeta != null) {
                this.initFieldNumbers(((TextFileOutputData)this.data).outputRowMeta, ((TextFileOutputMeta)this.meta).getOutputFields());
                if (row != null) {
                    ((TextFileOutputMeta)this.meta).getFields(((TextFileOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                }
            }
        }
        return this.writeRowTo(row);
    }

    protected boolean writeRowTo(Object[] row) throws HopException {
        return this.writeRowToFile(row);
    }

    public void writeRow(IRowMeta rowMeta, Object[] r) throws HopTransformException {
        try {
            if (((TextFileOutputMeta)this.meta).getOutputFields() == null || ((TextFileOutputMeta)this.meta).getOutputFields().length == 0) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && ((TextFileOutputData)this.data).binarySeparator.length > 0) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binarySeparator);
                    }
                    IValueMeta v = rowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(v, valueData, null);
                }
                ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryNewline);
            } else {
                for (int i = 0; i < ((TextFileOutputMeta)this.meta).getOutputFields().length; ++i) {
                    if (i > 0 && ((TextFileOutputData)this.data).binarySeparator.length > 0) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binarySeparator);
                    }
                    IValueMeta v = rowMeta.getValueMeta(((TextFileOutputData)this.data).fieldnrs[i]);
                    Object valueData = r[((TextFileOutputData)this.data).fieldnrs[i]];
                    this.writeField(v, valueData, ((TextFileOutputData)this.data).binaryNullValue[i]);
                }
                ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryNewline);
            }
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing line", (Throwable)e);
        }
    }

    private byte[] formatField(IValueMeta v, Object valueData) throws HopValueException {
        if (v.isString()) {
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && Utils.isEmpty((CharSequence)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (String)valueData : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(IValueMeta v, String string) throws HopValueException {
        byte[] text;
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            if (Utils.isEmpty((CharSequence)v.getStringEncoding())) {
                return tmp.getBytes();
            }
            try {
                return tmp.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new HopValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEncoding())) {
            text = string.getBytes();
        } else {
            try {
                text = string.getBytes(((TextFileOutputMeta)this.meta).getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new HopValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (length > string.length()) {
            int size = 0;
            byte[] filler = null;
            try {
                filler = !Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEncoding()) ? " ".getBytes(((TextFileOutputMeta)this.meta).getEncoding()) : " ".getBytes();
                size = text.length + filler.length * (length - string.length());
            }
            catch (UnsupportedEncodingException uee) {
                throw new HopValueException((Throwable)uee);
            }
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            } else {
                int currIndex = text.length;
                for (int i = 0; i < length - string.length(); ++i) {
                    for (int j = 0; j < filler.length; ++j) {
                        bytes[currIndex++] = filler[j];
                    }
                }
            }
            return bytes;
        }
        return text;
    }

    private byte[] getBinaryString(String string) throws HopTransformException {
        try {
            if (((TextFileOutputData)this.data).hasEncoding) {
                return string.getBytes(((TextFileOutputMeta)this.meta).getEncoding());
            }
            return string.getBytes();
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    private void writeField(IValueMeta v, Object valueData, byte[] nullString) throws HopTransformException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : (((TextFileOutputMeta)this.meta).isFastDump() ? (valueData instanceof byte[] ? (byte[])valueData : this.getBinaryString(valueData == null ? "" : valueData.toString())) : this.formatField(v, valueData));
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString()) {
                    if (((TextFileOutputMeta)this.meta).isEnclosureForced() && !((TextFileOutputMeta)this.meta).isPadded()) {
                        writeEnclosures = true;
                    } else if (!((TextFileOutputMeta)this.meta).isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(str, ((TextFileOutputData)this.data).binarySeparator, ((TextFileOutputData)this.data).binaryEnclosure)) {
                        writeEnclosures = true;
                    }
                }
                if (writeEnclosures) {
                    ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    ((TextFileOutputData)this.data).writer.write(str);
                } else {
                    int from = 0;
                    for (int i = 0; i < enclosures.size(); ++i) {
                        int position = enclosures.get(i);
                        ((TextFileOutputData)this.data).writer.write(str, from, position + ((TextFileOutputData)this.data).binaryEnclosure.length - from);
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                        from = position + ((TextFileOutputData)this.data).binaryEnclosure.length;
                    }
                    if (from < str.length) {
                        ((TextFileOutputData)this.data).writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing field content to file", (Throwable)e);
        }
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        if (((TextFileOutputData)this.data).binaryEnclosure != null && ((TextFileOutputData)this.data).binaryEnclosure.length > 0) {
            int len = str.length - ((TextFileOutputData)this.data).binaryEnclosure.length + 1;
            for (int i = 0; i < len; ++i) {
                boolean found = true;
                for (int x = 0; found && x < ((TextFileOutputData)this.data).binaryEnclosure.length; ++x) {
                    if (str[i + x] == ((TextFileOutputData)this.data).binaryEnclosure[x]) continue;
                    found = false;
                }
                if (!found) continue;
                if (positions == null) {
                    positions = new ArrayList<Integer>();
                }
                positions.add(i);
            }
        }
        return positions;
    }

    protected boolean writeEndedLine() {
        boolean retval = false;
        try {
            String sLine = this.resolve(((TextFileOutputMeta)this.meta).getEndedLine());
            if (sLine != null && sLine.trim().length() > 0) {
                ((TextFileOutputData)this.data).writer.write(this.getBinaryString(sLine));
                this.incrementLinesOutput();
            }
        }
        catch (Exception e) {
            this.logError("Error writing ended tag line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        return retval;
    }

    protected boolean writeHeader() {
        boolean retval = false;
        IRowMeta r = ((TextFileOutputData)this.data).outputRowMeta;
        try {
            if (((TextFileOutputMeta)this.meta).getOutputFields() != null && ((TextFileOutputMeta)this.meta).getOutputFields().length > 0) {
                for (int i = 0; i < ((TextFileOutputMeta)this.meta).getOutputFields().length; ++i) {
                    boolean writeEnclosure;
                    String fieldName = ((TextFileOutputMeta)this.meta).getOutputFields()[i].getName();
                    IValueMeta v = r.searchValueMeta(fieldName);
                    if (i > 0 && ((TextFileOutputData)this.data).binarySeparator.length > 0) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binarySeparator);
                    }
                    boolean bl = writeEnclosure = ((TextFileOutputMeta)this.meta).isEnclosureForced() && ((TextFileOutputData)this.data).binaryEnclosure.length > 0 && v != null && v.isString() || !((TextFileOutputMeta)this.meta).isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(fieldName.getBytes(), ((TextFileOutputData)this.data).binarySeparator, ((TextFileOutputData)this.data).binaryEnclosure);
                    if (writeEnclosure) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                    }
                    ((TextFileOutputData)this.data).writer.write(this.getBinaryString(fieldName));
                    if (!writeEnclosure) continue;
                    ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                }
                ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryNewline);
            } else if (r != null) {
                for (int i = 0; i < r.size(); ++i) {
                    boolean writeEnclosure;
                    if (i > 0 && ((TextFileOutputData)this.data).binarySeparator.length > 0) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binarySeparator);
                    }
                    IValueMeta v = r.getValueMeta(i);
                    boolean bl = writeEnclosure = ((TextFileOutputMeta)this.meta).isEnclosureForced() && ((TextFileOutputData)this.data).binaryEnclosure.length > 0 && v != null && v.isString() || !((TextFileOutputMeta)this.meta).isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(v.getName().getBytes(), ((TextFileOutputData)this.data).binarySeparator, ((TextFileOutputData)this.data).binaryEnclosure);
                    if (writeEnclosure) {
                        ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                    }
                    ((TextFileOutputData)this.data).writer.write(this.getBinaryString(v.getName()));
                    if (!writeEnclosure) continue;
                    ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryEnclosure);
                }
                ((TextFileOutputData)this.data).writer.write(((TextFileOutputData)this.data).binaryNewline);
            } else {
                ((TextFileOutputData)this.data).writer.write(this.getBinaryString("no rows selected" + Const.CR));
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        this.incrementLinesOutput();
        return retval;
    }

    public String buildFilename(String filename, boolean ziparchive) {
        return ((TextFileOutputMeta)this.meta).buildFilename(filename, ((TextFileOutputMeta)this.meta).getExtension(), (IVariables)this, this.getCopy(), this.getPartitionId(), ((TextFileOutputData)this.data).splitnr, ((TextFileOutputData)this.data).isBeamContext(), this.log.getLogChannelId(), ((TextFileOutputData)this.data).getBeamBundleNr(), ziparchive, (TextFileOutputMeta)this.meta);
    }

    protected boolean closeFile(String filename) {
        try {
            ((TextFileOutputData)this.data).getFileStreamsCollection().closeFile(filename);
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    protected boolean closeFile() {
        boolean retval;
        try {
            if (((TextFileOutputData)this.data).writer != null) {
                ((TextFileOutputData)this.data).getFileStreamsCollection().closeStream(((TextFileOutputData)this.data).writer);
            }
            ((TextFileOutputData)this.data).writer = null;
            ((TextFileOutputData)this.data).out = null;
            ((TextFileOutputData)this.data).fos = null;
            if (this.log.isDebug()) {
                this.logDebug("Closing normal file ...");
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            ((TextFileOutputData)this.data).writer = null;
            ((TextFileOutputData)this.data).out = null;
            ((TextFileOutputData)this.data).fos = null;
            retval = false;
        }
        return retval;
    }

    public boolean init() {
        if (super.init()) {
            ((TextFileOutputData)this.data).splitnr = 0;
            if (!((TextFileOutputMeta)this.meta).isDoNotOpenNewFileInit() && !((TextFileOutputMeta)this.meta).isFileNameInField()) {
                try {
                    this.initOutput();
                }
                catch (Exception e) {
                    this.logError("Couldn't open file " + HopVfs.getFriendlyURI((String)this.getParentVariables().resolve(((TextFileOutputMeta)this.meta).getFileName())) + "." + this.getParentVariables().resolve(((TextFileOutputMeta)this.meta).getExtension()), e);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            try {
                this.initBinaryDataFields();
            }
            catch (Exception e) {
                this.logError("Couldn't initialize binary data fields", e);
                this.setErrors(1L);
                this.stopAll();
            }
            return true;
        }
        return false;
    }

    protected void initOutput() throws HopException {
        String filename = this.getOutputFileName(null);
        this.initFileStreamWriter(filename);
    }

    protected void initBinaryDataFields() throws HopException {
        try {
            ((TextFileOutputData)this.data).hasEncoding = !Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEncoding());
            ((TextFileOutputData)this.data).binarySeparator = new byte[0];
            ((TextFileOutputData)this.data).binaryEnclosure = new byte[0];
            ((TextFileOutputData)this.data).binaryNewline = new byte[0];
            if (((TextFileOutputData)this.data).hasEncoding) {
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getSeparator())) {
                    ((TextFileOutputData)this.data).binarySeparator = this.resolve(((TextFileOutputMeta)this.meta).getSeparator()).getBytes(((TextFileOutputMeta)this.meta).getEncoding());
                }
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEnclosure())) {
                    ((TextFileOutputData)this.data).binaryEnclosure = this.resolve(((TextFileOutputMeta)this.meta).getEnclosure()).getBytes(((TextFileOutputMeta)this.meta).getEncoding());
                }
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getNewline())) {
                    ((TextFileOutputData)this.data).binaryNewline = ((TextFileOutputMeta)this.meta).getNewline().getBytes(((TextFileOutputMeta)this.meta).getEncoding());
                }
            } else {
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getSeparator())) {
                    ((TextFileOutputData)this.data).binarySeparator = this.resolve(((TextFileOutputMeta)this.meta).getSeparator()).getBytes();
                }
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getEnclosure())) {
                    ((TextFileOutputData)this.data).binaryEnclosure = this.resolve(((TextFileOutputMeta)this.meta).getEnclosure()).getBytes();
                }
                if (!Utils.isEmpty((CharSequence)((TextFileOutputMeta)this.meta).getNewline())) {
                    ((TextFileOutputData)this.data).binaryNewline = this.resolve(((TextFileOutputMeta)this.meta).getNewline()).getBytes();
                }
            }
            ((TextFileOutputData)this.data).binaryNullValue = new byte[((TextFileOutputMeta)this.meta).getOutputFields().length][];
            for (int i = 0; i < ((TextFileOutputMeta)this.meta).getOutputFields().length; ++i) {
                ((TextFileOutputData)this.data).binaryNullValue[i] = null;
                String nullString = ((TextFileOutputMeta)this.meta).getOutputFields()[i].getNullString();
                if (Utils.isEmpty((CharSequence)nullString)) continue;
                ((TextFileOutputData)this.data).binaryNullValue[i] = ((TextFileOutputData)this.data).hasEncoding ? nullString.getBytes(((TextFileOutputMeta)this.meta).getEncoding()) : nullString.getBytes();
            }
            ((TextFileOutputData)this.data).splitEvery = ((TextFileOutputMeta)this.meta).getSplitEvery(this.variables);
        }
        catch (Exception e) {
            throw new HopException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    protected void close() throws IOException {
        if (!((TextFileOutputMeta)this.meta).isServletOutput()) {
            ((TextFileOutputData)this.data).getFileStreamsCollection().flushOpenFiles(true);
            ((TextFileOutputData)this.data).writer = null;
        }
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (Exception e) {
            this.logError("Unexpected error closing file", e);
            this.setErrors(1L);
        }
        ((TextFileOutputData)this.data).writer = null;
        ((TextFileOutputData)this.data).out = null;
        ((TextFileOutputData)this.data).fos = null;
        super.dispose();
    }

    public boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure) {
        boolean separatorExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean bl = separatorExists = separator != null && separator.length > 0;
        if (separatorExists || enclosureExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!separatorExists || source[index] != separator[0] || index + separator.length > source.length) continue;
                result = true;
                for (i = 1; i < separator.length; ++i) {
                    if (source[index + i] == separator[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = this.getFileObject(filename, this.variables).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (((TextFileOutputMeta)this.meta).isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderCreated", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExistCreateIt", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder), HopVfs.getFriendlyURI((String)filename)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected FileObject getFileObject(String vfsFilename) throws HopFileException {
        return HopVfs.getFileObject((String)vfsFilename);
    }

    protected FileObject getFileObject(String vfsFilename, IVariables variables) throws HopFileException {
        return HopVfs.getFileObject((String)vfsFilename);
    }

    protected OutputStream getOutputStream(String vfsFilename, IVariables variables, boolean append) throws HopFileException {
        return HopVfs.getOutputStream((String)vfsFilename, (boolean)append);
    }

    public void startBundle() throws HopException {
    }

    public void batchComplete() throws HopException {
        if (!((TextFileOutputData)this.data).isBeamContext()) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new HopException("Error closing file(s)", (Throwable)e);
            }
        }
    }

    public void finishBundle() throws HopException {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new HopException("Error closing file(s)", (Throwable)e);
        }
    }
}

