/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.ReadableDateTime;

final class MutationUtils {
    private MutationUtils() {
    }

    public static boolean isPointDelete(Mutation m) {
        return m.getOperation() == Mutation.Op.DELETE && Iterables.isEmpty((Iterable)m.getKeySet().getRanges()) && Iterables.size((Iterable)m.getKeySet().getKeys()) == 1;
    }

    public static SerializableFunction<Row, Mutation> beamRowToMutationFn(Mutation.Op operation, String table) {
        return (SerializableFunction & Serializable)row -> {
            switch (operation) {
                case INSERT: {
                    return MutationUtils.createMutationFromBeamRows(Mutation.newInsertBuilder((String)table), row);
                }
                case DELETE: {
                    return Mutation.delete((String)table, (Key)MutationUtils.createKeyFromBeamRow(row));
                }
                case UPDATE: {
                    return MutationUtils.createMutationFromBeamRows(Mutation.newUpdateBuilder((String)table), row);
                }
                case REPLACE: {
                    return MutationUtils.createMutationFromBeamRows(Mutation.newReplaceBuilder((String)table), row);
                }
                case INSERT_OR_UPDATE: {
                    return MutationUtils.createMutationFromBeamRows(Mutation.newInsertOrUpdateBuilder((String)table), row);
                }
            }
            throw new IllegalArgumentException(String.format("Unknown mutation operation type: %s", operation));
        };
    }

    private static Key createKeyFromBeamRow(Row row) {
        Key.Builder builder = Key.newBuilder();
        Schema schema = row.getSchema();
        List columns = schema.getFieldNames();
        columns.forEach(columnName -> MutationUtils.setBeamValueToKey(builder, schema.getField(columnName).getType(), columnName, row));
        return builder.build();
    }

    private static Mutation createMutationFromBeamRows(Mutation.WriteBuilder mutationBuilder, Row row) {
        Schema schema = row.getSchema();
        List columns = schema.getFieldNames();
        columns.forEach(columnName -> MutationUtils.setBeamValueToMutation(mutationBuilder, schema.getField(columnName).getType(), columnName, row));
        return mutationBuilder.build();
    }

    private static void setBeamValueToKey(Key.Builder keyBuilder, Schema.FieldType field, String columnName, Row row) {
        switch (field.getTypeName()) {
            case BYTE: {
                Byte byteValue = row.getByte(columnName);
                if (byteValue == null) {
                    keyBuilder.append((Long)null);
                    break;
                }
                keyBuilder.append((long)byteValue.byteValue());
                break;
            }
            case INT16: {
                Short int16 = row.getInt16(columnName);
                if (int16 == null) {
                    keyBuilder.append((Long)null);
                    break;
                }
                keyBuilder.append((long)int16.shortValue());
                break;
            }
            case INT32: {
                Integer int32 = row.getInt32(columnName);
                if (int32 == null) {
                    keyBuilder.append((Long)null);
                    break;
                }
                keyBuilder.append((long)int32.intValue());
                break;
            }
            case INT64: {
                keyBuilder.append(row.getInt64(columnName));
                break;
            }
            case FLOAT: {
                Float floatValue = row.getFloat(columnName);
                if (floatValue == null) {
                    keyBuilder.append((Double)null);
                    break;
                }
                keyBuilder.append((double)floatValue.floatValue());
                break;
            }
            case DOUBLE: {
                keyBuilder.append(row.getDouble(columnName));
                break;
            }
            case DECIMAL: {
                keyBuilder.append(row.getDecimal(columnName));
                break;
            }
            case DATETIME: {
                ReadableDateTime dateTime = row.getDateTime(columnName);
                if (dateTime == null) {
                    keyBuilder.append((Timestamp)null);
                    break;
                }
                keyBuilder.append(Timestamp.ofTimeMicroseconds((long)(dateTime.toInstant().getMillis() * 1000L)));
                break;
            }
            case BOOLEAN: {
                keyBuilder.append(row.getBoolean(columnName));
                break;
            }
            case STRING: {
                keyBuilder.append(row.getString(columnName));
                break;
            }
            case BYTES: {
                byte[] bytes = row.getBytes(columnName);
                if (bytes == null) {
                    keyBuilder.append((ByteArray)null);
                    break;
                }
                keyBuilder.append(ByteArray.copyFrom((byte[])bytes));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported field type: %s", field.getTypeName()));
            }
        }
    }

    private static void setBeamValueToMutation(Mutation.WriteBuilder mutationBuilder, Schema.FieldType fieldType, String columnName, Row row) {
        switch (fieldType.getTypeName()) {
            case BYTE: {
                Byte byteValue = row.getByte(columnName);
                if (byteValue == null) {
                    mutationBuilder.set(columnName).to((Long)null);
                    break;
                }
                mutationBuilder.set(columnName).to((long)byteValue.byteValue());
                break;
            }
            case INT16: {
                Short int16 = row.getInt16(columnName);
                if (int16 == null) {
                    mutationBuilder.set(columnName).to((Long)null);
                    break;
                }
                mutationBuilder.set(columnName).to((long)int16.shortValue());
                break;
            }
            case INT32: {
                Integer int32 = row.getInt32(columnName);
                if (int32 == null) {
                    mutationBuilder.set(columnName).to((Long)null);
                    break;
                }
                mutationBuilder.set(columnName).to((long)int32.intValue());
                break;
            }
            case INT64: {
                mutationBuilder.set(columnName).to(row.getInt64(columnName));
                break;
            }
            case FLOAT: {
                Float floatValue = row.getFloat(columnName);
                if (floatValue == null) {
                    mutationBuilder.set(columnName).to((Double)null);
                    break;
                }
                mutationBuilder.set(columnName).to((double)floatValue.floatValue());
                break;
            }
            case DOUBLE: {
                mutationBuilder.set(columnName).to(row.getDouble(columnName));
                break;
            }
            case DECIMAL: {
                BigDecimal decimal = row.getDecimal(columnName);
                if (decimal == null) {
                    Preconditions.checkNotNull((Object)decimal, (Object)("Null decimal at column " + columnName));
                    break;
                }
                mutationBuilder.set(columnName).to(decimal);
                break;
            }
            case DATETIME: {
                ReadableDateTime dateTime = row.getDateTime(columnName);
                if (dateTime == null) {
                    mutationBuilder.set(columnName).to((Timestamp)null);
                    break;
                }
                mutationBuilder.set(columnName).to(Timestamp.ofTimeMicroseconds((long)(dateTime.toInstant().getMillis() * 1000L)));
                break;
            }
            case BOOLEAN: {
                mutationBuilder.set(columnName).to(row.getBoolean(columnName));
                break;
            }
            case STRING: {
                mutationBuilder.set(columnName).to(row.getString(columnName));
                break;
            }
            case BYTES: {
                byte[] bytes = row.getBytes(columnName);
                if (bytes == null) {
                    mutationBuilder.set(columnName).to((ByteArray)null);
                    break;
                }
                mutationBuilder.set(columnName).to(ByteArray.copyFrom((byte[])bytes));
                break;
            }
            case ROW: {
                Row subRow = row.getRow(columnName);
                if (subRow == null) {
                    mutationBuilder.set(columnName).to(StructUtils.beamTypeToSpannerType(row.getSchema().getField(columnName).getType()), null);
                    break;
                }
                mutationBuilder.set(columnName).to(StructUtils.beamTypeToSpannerType(row.getSchema().getField(columnName).getType()), StructUtils.beamRowToStruct(subRow));
                break;
            }
            case ARRAY: {
                MutationUtils.addIterableToMutationBuilder(mutationBuilder, row.getArray(columnName), row.getSchema().getField(columnName));
                break;
            }
            case ITERABLE: {
                MutationUtils.addIterableToMutationBuilder(mutationBuilder, row.getIterable(columnName), row.getSchema().getField(columnName));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported field type: %s", fieldType.getTypeName()));
            }
        }
    }

    private static void addIterableToMutationBuilder(Mutation.WriteBuilder mutationBuilder, @Nullable Iterable<Object> iterable, Schema.Field field) {
        String column = field.getName();
        Schema.FieldType beamIterableType = field.getType().getCollectionElementType();
        if (beamIterableType == null) {
            throw new NullPointerException("Null collection element type at field " + field.getName());
        }
        Schema.TypeName beamIterableTypeName = beamIterableType.getTypeName();
        switch (beamIterableTypeName) {
            case ROW: {
                if (iterable == null) {
                    mutationBuilder.set(column).toStructArray(StructUtils.beamTypeToSpannerType(beamIterableType), null);
                    break;
                }
                mutationBuilder.set(column).toStructArray(StructUtils.beamTypeToSpannerType(beamIterableType), (Iterable)StreamSupport.stream(iterable.spliterator(), false).map(row -> StructUtils.beamRowToStruct((Row)row)).collect(Collectors.toList()));
                break;
            }
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: {
                mutationBuilder.set(column).toInt64Array(iterable);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                mutationBuilder.set(column).toFloat64Array(iterable);
                break;
            }
            case DECIMAL: {
                mutationBuilder.set(column).toNumericArray(iterable);
                break;
            }
            case BOOLEAN: {
                mutationBuilder.set(column).toBoolArray(iterable);
                break;
            }
            case BYTES: {
                if (iterable == null) {
                    mutationBuilder.set(column).toBytesArray(null);
                    break;
                }
                mutationBuilder.set(column).toBytesArray((Iterable)StreamSupport.stream(iterable.spliterator(), false).map(object -> ByteArray.copyFrom((byte[])((byte[])object))).collect(Collectors.toList()));
                break;
            }
            case STRING: {
                mutationBuilder.set(column).toStringArray(iterable);
                break;
            }
            case DATETIME: {
                if (iterable == null) {
                    mutationBuilder.set(column).toDateArray(null);
                    break;
                }
                mutationBuilder.set(column).toTimestampArray((Iterable)StreamSupport.stream(iterable.spliterator(), false).map(datetime -> Timestamp.parseTimestamp((String)datetime.toString())).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported iterable type '%s' while translating row to struct.", beamIterableType.getTypeName()));
            }
        }
    }
}

