/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteTables;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StreamingInserts<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    private BigQueryServices bigQueryServices;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private InsertRetryPolicy retryPolicy;
    private boolean extendedErrorInfo;
    private final boolean skipInvalidRows;
    private final boolean ignoreUnknownValues;
    private final boolean ignoreInsertIds;
    private final boolean autoSharding;
    private final boolean propagateSuccessful;
    private final @Nullable String kmsKey;
    private final Coder<ElementT> elementCoder;
    private final SerializableFunction<ElementT, TableRow> toTableRow;
    private final SerializableFunction<ElementT, TableRow> toFailsafeTableRow;
    private final @Nullable SerializableFunction<ElementT, String> deterministicRecordIdFn;

    public StreamingInserts(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations, Coder<ElementT> elementCoder, SerializableFunction<ElementT, TableRow> toTableRow, SerializableFunction<ElementT, TableRow> toFailsafeTableRow) {
        this(createDisposition, dynamicDestinations, new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry(), false, false, false, false, false, true, elementCoder, toTableRow, toFailsafeTableRow, null, null);
    }

    private StreamingInserts(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations, BigQueryServices bigQueryServices, InsertRetryPolicy retryPolicy, boolean extendedErrorInfo, boolean skipInvalidRows, boolean ignoreUnknownValues, boolean ignoreInsertIds, boolean autoSharding, boolean propagateSuccessful, Coder<ElementT> elementCoder, SerializableFunction<ElementT, TableRow> toTableRow, SerializableFunction<ElementT, TableRow> toFailsafeTableRow, @Nullable SerializableFunction<ElementT, String> deterministicRecordIdFn, @Nullable String kmsKey) {
        this.createDisposition = createDisposition;
        this.dynamicDestinations = dynamicDestinations;
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.autoSharding = autoSharding;
        this.propagateSuccessful = propagateSuccessful;
        this.elementCoder = elementCoder;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.deterministicRecordIdFn = deterministicRecordIdFn;
        this.kmsKey = kmsKey;
    }

    public StreamingInserts<DestinationT, ElementT> withInsertRetryPolicy(InsertRetryPolicy retryPolicy) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    public StreamingInserts<DestinationT, ElementT> withExtendedErrorInfo(boolean extendedErrorInfo) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withSkipInvalidRows(boolean skipInvalidRows) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withIgnoreUnknownValues(boolean ignoreUnknownValues) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withIgnoreInsertIds(boolean ignoreInsertIds) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withAutoSharding(boolean autoSharding) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withSuccessfulInsertsPropagation(boolean propagateSuccessful) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withDeterministicRecordIdFn(SerializableFunction<ElementT, String> deterministicRecordIdFn) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, deterministicRecordIdFn, this.kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withKmsKey(String kmsKey) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, kmsKey);
    }

    StreamingInserts<DestinationT, ElementT> withTestServices(BigQueryServices bigQueryServices) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    public WriteResult expand(PCollection<KV<DestinationT, ElementT>> input) {
        PCollection writes = (PCollection)input.apply("CreateTables", new CreateTables(this.createDisposition, this.dynamicDestinations).withTestServices(this.bigQueryServices).withKmsKey(this.kmsKey));
        return (WriteResult)writes.apply(new StreamingWriteTables().withTestServices(this.bigQueryServices).withInsertRetryPolicy(this.retryPolicy).withExtendedErrorInfo(this.extendedErrorInfo).withSkipInvalidRows(this.skipInvalidRows).withIgnoreUnknownValues(this.ignoreUnknownValues).withIgnoreInsertIds(this.ignoreInsertIds).withAutoSharding(this.autoSharding).withPropagateSuccessful(this.propagateSuccessful).withElementCoder(this.elementCoder).withToTableRow(this.toTableRow).withToFailsafeTableRow(this.toFailsafeTableRow).withDeterministicRecordIdFn(this.deterministicRecordIdFn));
    }
}

