/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class RowWriterFactory<ElementT, DestinationT>
implements Serializable {
    private RowWriterFactory() {
    }

    abstract OutputType getOutputType();

    abstract String getSourceFormat();

    abstract BigQueryRowWriter<ElementT> createRowWriter(String var1, DestinationT var2) throws Exception;

    static <ElementT, DestinationT> RowWriterFactory<ElementT, DestinationT> tableRows(SerializableFunction<ElementT, TableRow> toRow, SerializableFunction<ElementT, TableRow> toFailsafeRow) {
        return new TableRowWriterFactory(toRow, toFailsafeRow);
    }

    static <ElementT, AvroT, DestinationT> AvroRowWriterFactory<ElementT, AvroT, DestinationT> avroRecords(SerializableFunction<AvroWriteRequest<ElementT>, AvroT> toAvro, SerializableFunction<Schema, DatumWriter<AvroT>> writerFactory) {
        return new AvroRowWriterFactory(toAvro, writerFactory, null, null);
    }

    static final class AvroRowWriterFactory<ElementT, AvroT, DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final SerializableFunction<AvroWriteRequest<ElementT>, AvroT> toAvro;
        private final SerializableFunction<Schema, DatumWriter<AvroT>> writerFactory;
        private final @Nullable SerializableFunction<@Nullable TableSchema, Schema> schemaFactory;
        private final @Nullable DynamicDestinations<?, DestinationT> dynamicDestinations;

        private AvroRowWriterFactory(SerializableFunction<AvroWriteRequest<ElementT>, AvroT> toAvro, SerializableFunction<Schema, DatumWriter<AvroT>> writerFactory, @Nullable SerializableFunction<@Nullable TableSchema, Schema> schemaFactory, @Nullable DynamicDestinations<?, DestinationT> dynamicDestinations) {
            this.toAvro = toAvro;
            this.writerFactory = writerFactory;
            this.schemaFactory = schemaFactory;
            this.dynamicDestinations = dynamicDestinations;
        }

        AvroRowWriterFactory<ElementT, AvroT, DestinationT> prepare(DynamicDestinations<?, DestinationT> dynamicDestinations, SerializableFunction<@Nullable TableSchema, Schema> schemaFactory) {
            return new AvroRowWriterFactory<ElementT, AvroT, DestinationT>(this.toAvro, this.writerFactory, schemaFactory, dynamicDestinations);
        }

        @Override
        OutputType getOutputType() {
            return OutputType.AvroGenericRecord;
        }

        @Override
        BigQueryRowWriter<ElementT> createRowWriter(String tempFilePrefix, DestinationT destination) throws Exception {
            if (this.dynamicDestinations == null) {
                throw new IllegalStateException("createRowWriter called when dynamicDestinations is null; forgot to call prepare()?");
            }
            if (this.schemaFactory == null) {
                throw new IllegalStateException("createRowWriter called when schemaFactory is null; forgot to call prepare()?");
            }
            TableSchema tableSchema = this.dynamicDestinations.getSchema(destination);
            Schema avroSchema = (Schema)this.schemaFactory.apply((Object)tableSchema);
            return new AvroRowWriter<AvroT, ElementT>(tempFilePrefix, avroSchema, this.toAvro, this.writerFactory);
        }

        @Override
        String getSourceFormat() {
            return "AVRO";
        }
    }

    static final class TableRowWriterFactory<ElementT, DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final SerializableFunction<ElementT, TableRow> toRow;
        private final SerializableFunction<ElementT, TableRow> toFailsafeRow;

        private TableRowWriterFactory(SerializableFunction<ElementT, TableRow> toRow, SerializableFunction<ElementT, TableRow> toFailsafeRow) {
            this.toRow = toRow;
            this.toFailsafeRow = toFailsafeRow;
        }

        public SerializableFunction<ElementT, TableRow> getToRowFn() {
            return this.toRow;
        }

        public SerializableFunction<ElementT, TableRow> getToFailsafeRowFn() {
            if (this.toFailsafeRow == null) {
                return this.toRow;
            }
            return this.toFailsafeRow;
        }

        @Override
        public OutputType getOutputType() {
            return OutputType.JsonTableRow;
        }

        @Override
        public BigQueryRowWriter<ElementT> createRowWriter(String tempFilePrefix, DestinationT destination) throws Exception {
            return new TableRowWriter<ElementT>(tempFilePrefix, this.toRow);
        }

        @Override
        String getSourceFormat() {
            return "NEWLINE_DELIMITED_JSON";
        }
    }

    static enum OutputType {
        JsonTableRow,
        AvroGenericRecord;

    }
}

