/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.array;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseDoubleArrayValue
extends ClickHouseObjectValue<double[]> {
    private static final String TYPE_NAME = "double[]";

    public static ClickHouseDoubleArrayValue ofEmpty() {
        return ClickHouseDoubleArrayValue.of(ClickHouseValues.EMPTY_DOUBLE_ARRAY);
    }

    public static ClickHouseDoubleArrayValue of(double[] value) {
        return ClickHouseDoubleArrayValue.of(null, value);
    }

    public static ClickHouseDoubleArrayValue of(ClickHouseValue ref, double[] value) {
        return ref instanceof ClickHouseDoubleArrayValue ? ((ClickHouseDoubleArrayValue)ref).set(value) : new ClickHouseDoubleArrayValue(value);
    }

    protected ClickHouseDoubleArrayValue(double[] value) {
        super(value);
    }

    protected ClickHouseDoubleArrayValue set(double[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        double[] v = (double[])this.getValue();
        int len = v.length;
        Object[] array = new Double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        double[] v = (double[])this.getValue();
        int len = v.length;
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i]);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        double[] v = (double[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.toString((double[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseDoubleArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseDoubleArrayValue((double[])this.getValue());
        }
        double[] value = (double[])this.getValue();
        return new ClickHouseDoubleArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((double[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseDoubleArrayValue resetToDefault() {
        this.set(ClickHouseValues.EMPTY_DOUBLE_ARRAY);
        return this;
    }

    @Override
    public ClickHouseDoubleArrayValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        int len;
        double[] value = (double[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < len; ++i) {
            builder.append(value[i]).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseDoubleArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? 1.0 : 0.0;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(byte value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(short value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(int value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(long value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(float value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(double value) {
        return this.set(new double[]{value});
    }

    @Override
    public ClickHouseDoubleArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Arrays.copyOf(value, len));
    }

    @Override
    public ClickHouseDoubleArrayValue update(BigInteger value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.doubleValue();
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(BigDecimal value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.doubleValue();
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Enum<?> value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.ordinal();
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseDoubleArrayValue update(LocalDate value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.toEpochDay();
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(LocalTime value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.toSecondOfDay();
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(LocalDateTime value) {
        double[] dArray;
        if (value == null) {
            dArray = ClickHouseValues.EMPTY_DOUBLE_ARRAY;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(dArray);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? 0.0 : ((Number)o).doubleValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        double[] values = new double[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? 0.0 : n.doubleValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] v = new double[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? 0.0 : ((Number)e.getValue()).doubleValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseDoubleArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_DOUBLE_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_DOUBLE_ARRAY);
            } else {
                double[] arr = new double[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = v == null ? 0.0 : Double.parseDouble(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseDoubleArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseDoubleArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseDoubleArrayValue) {
            this.set((double[])((ClickHouseDoubleArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseDoubleArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        double[] values = new double[len];
        for (int i = 0; i < len; ++i) {
            Object o = value[i];
            values[i] = o == null ? 0.0 : ((Number)o).doubleValue();
        }
        this.set(values);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new double[]{((Number)value).doubleValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseDoubleArrayValue update(Object value) {
        if (value instanceof double[]) {
            this.set((double[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((double[])this.getValue(), (double[])((ClickHouseDoubleArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((double[])this.getValue());
    }
}

