/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InstanceBuilder<T> {
    private final Class<T> type;
    private final List<Class<?>> parameterTypes = new ArrayList();
    private final List<Object> arguments = new ArrayList<Object>();
    private @Nullable String methodName;
    private @Nullable Class<?> factoryClass;

    public static <T> InstanceBuilder<T> ofType(Class<T> type) {
        return new InstanceBuilder<T>(type);
    }

    public static <T> InstanceBuilder<T> ofType(TypeDescriptor<T> token) {
        Class<T> type = token.getRawType();
        return new InstanceBuilder<T>(type);
    }

    public InstanceBuilder<T> fromClassName(String name) throws ClassNotFoundException {
        Preconditions.checkArgument((this.factoryClass == null ? 1 : 0) != 0, (Object)"Class name may only be specified once");
        if (name.indexOf(46) == -1) {
            name = this.type.getPackage().getName() + "." + name;
        }
        try {
            this.factoryClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(String.format("Could not find class: %s", name), e);
        }
        return this;
    }

    public InstanceBuilder<T> fromClass(Class<?> factoryClass) {
        this.factoryClass = factoryClass;
        return this;
    }

    public InstanceBuilder<T> fromFactoryMethod(String methodName) {
        Preconditions.checkArgument((this.methodName == null ? 1 : 0) != 0, (Object)"Factory method name may only be specified once");
        this.methodName = methodName;
        return this;
    }

    public <ArgT> InstanceBuilder<T> withArg(Class<? super ArgT> argType, ArgT value) {
        this.parameterTypes.add(argType);
        this.arguments.add(value);
        return this;
    }

    public T build() {
        if (this.factoryClass == null) {
            this.factoryClass = this.type;
        }
        Class[] types = this.parameterTypes.toArray(new Class[this.parameterTypes.size()]);
        if (this.methodName != null) {
            return this.buildFromMethod(types);
        }
        return this.buildFromConstructor(types);
    }

    private InstanceBuilder(Class<T> type) {
        this.type = type;
    }

    private T buildFromMethod(Class<?>[] types) {
        Preconditions.checkState((this.factoryClass != null ? 1 : 0) != 0);
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0);
        try {
            Method method = this.factoryClass.getDeclaredMethod(this.methodName, types);
            Preconditions.checkState((boolean)Modifier.isStatic(method.getModifiers()), (Object)("Factory method must be a static method for " + this.factoryClass.getName() + "#" + method.getName()));
            Preconditions.checkState((boolean)this.type.isAssignableFrom(method.getReturnType()), (Object)("Return type for " + this.factoryClass.getName() + "#" + method.getName() + " must be assignable to " + this.type.getSimpleName()));
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(method.invoke(null, args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Unable to find factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(String.format("Encountered checked exception when constructing an instance from factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)), e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to construct instance from factory method %s#%s(%s) due to access restriction", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)), e);
        }
    }

    private T buildFromConstructor(Class<?>[] types) {
        Preconditions.checkState((this.factoryClass != null ? 1 : 0) != 0);
        try {
            Constructor<?> constructor = this.factoryClass.getDeclaredConstructor(types);
            Preconditions.checkState((boolean)this.type.isAssignableFrom(this.factoryClass), (Object)("Instance type " + this.factoryClass.getName() + " must be assignable to " + this.type.getSimpleName()));
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(constructor.newInstance(args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find constructor for " + this.factoryClass.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to construct instance from constructor " + this.factoryClass.getName(), e);
        }
    }
}

