/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CharStreams;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ExplicitShardedFile
implements ShardedFile {
    private static final Logger LOG = LoggerFactory.getLogger(ExplicitShardedFile.class);
    private static final int MAX_READ_RETRIES = 4;
    private static final Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds((long)10L);
    static final FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private final List<MatchResult.Metadata> files = new ArrayList<MatchResult.Metadata>();

    public ExplicitShardedFile(Collection<String> files) throws IOException {
        for (String file : files) {
            this.files.add(FileSystems.matchSingleFileSpec(file));
        }
    }

    @Override
    public List<String> readFilesWithRetries(Sleeper sleeper, BackOff backOff) throws IOException, InterruptedException {
        if (this.files.isEmpty()) {
            return Collections.emptyList();
        }
        IOException lastException = null;
        while (true) {
            try {
                return this.readLines(this.files);
            }
            catch (IOException e) {
                lastException = e;
                LOG.warn("Error in file reading. Ignore and retry.");
                if (BackOffUtils.next(sleeper, backOff)) continue;
                throw new IOException(String.format("Unable to read file(s) after retrying %d times", 4), lastException);
            }
            break;
        }
    }

    public List<String> readFilesWithRetries() throws IOException, InterruptedException {
        return this.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
    }

    public String toString() {
        return String.format("explicit sharded file (%s)", Joiner.on((String)", ").join(this.files));
    }

    @VisibleForTesting
    List<String> readLines(Collection<MatchResult.Metadata> files) throws IOException {
        ArrayList allLines = Lists.newArrayList();
        int i = 1;
        for (MatchResult.Metadata file : files) {
            try (Reader reader = Channels.newReader(FileSystems.open(file.resourceId()), StandardCharsets.UTF_8.name());){
                List lines = CharStreams.readLines((Readable)reader);
                allLines.addAll(lines);
                LOG.debug("[{} of {}] Read {} lines from file: {}", new Object[]{i, files.size(), lines.size(), file});
            }
            ++i;
        }
        return allLines;
    }
}

