/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.checkerframework.checker.nullness.qual.Nullable;

public class View {
    private View() {
    }

    public static <T> AsSingleton<T> asSingleton() {
        return new AsSingleton();
    }

    public static <T> AsList<T> asList() {
        return new AsList();
    }

    public static <T> AsIterable<T> asIterable() {
        return new AsIterable();
    }

    public static <K, V> AsMap<K, V> asMap() {
        return new AsMap();
    }

    public static <K, V> AsMultimap<K, V> asMultimap() {
        return new AsMultimap();
    }

    @Internal
    public static class CreatePCollectionView<ElemT, ViewT>
    extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
        private PCollectionView<ViewT> view;

        private CreatePCollectionView(PCollectionView<ViewT> view) {
            this.view = view;
        }

        public static <ElemT, ViewT> CreatePCollectionView<ElemT, ViewT> of(PCollectionView<ViewT> view) {
            return new CreatePCollectionView<ElemT, ViewT>(view);
        }

        @Deprecated
        public PCollectionView<ViewT> getView() {
            return this.view;
        }

        @Override
        public PCollection<ElemT> expand(PCollection<ElemT> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), input.getWindowingStrategy(), input.isBounded(), input.getCoder());
        }
    }

    @Internal
    public static class AsMap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, V>>> {
        private AsMap() {
        }

        @Deprecated
        public AsMap<K, V> withSingletonValues() {
            return this;
        }

        @Override
        public PCollectionView<Map<K, V>> expand(PCollection<KV<K, V>> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder valueCoder = kvCoder.getValueCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<K, V>>(x -> x){}));
            PCollectionView view = PCollectionViews.mapView(materializationInput, keyCoder::getEncodedTypeDescriptor, valueCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    @Internal
    public static class AsMultimap<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, Iterable<V>>>> {
        private AsMultimap() {
        }

        @Override
        public PCollectionView<Map<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder valueCoder = kvCoder.getValueCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<K, V>>(x -> x){}));
            PCollectionView view = PCollectionViews.multimapView(materializationInput, keyCoder::getEncodedTypeDescriptor, valueCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    private static class SingletonCombineFn<T>
    extends Combine.BinaryCombineFn<T> {
        private final boolean hasDefault;
        private final @Nullable Coder<T> valueCoder;
        private final byte @Nullable [] defaultValue;

        private SingletonCombineFn(boolean hasDefault, Coder<T> coder, T defaultValue) {
            this.hasDefault = hasDefault;
            if (hasDefault) {
                if (defaultValue == null) {
                    this.defaultValue = null;
                    this.valueCoder = coder;
                } else {
                    this.valueCoder = coder;
                    try {
                        this.defaultValue = CoderUtils.encodeToByteArray(coder, defaultValue);
                    }
                    catch (CoderException e) {
                        throw new IllegalArgumentException(String.format("Could not encode the default value %s with the provided coder %s", defaultValue, coder));
                    }
                }
            } else {
                this.valueCoder = null;
                this.defaultValue = null;
            }
        }

        @Override
        public T apply(T left, T right) {
            throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view. Consider using Combine.globally().asSingleton() to combine the PCollection into a single value");
        }

        @Override
        public T identity() {
            if (this.hasDefault) {
                if (this.defaultValue == null) {
                    return null;
                }
                try {
                    return CoderUtils.decodeFromByteArray(this.valueCoder, this.defaultValue);
                }
                catch (CoderException e) {
                    throw new IllegalArgumentException(String.format("Could not decode the default value with the provided coder %s", this.valueCoder));
                }
            }
            throw new IllegalArgumentException("Empty PCollection accessed as a singleton view. Consider setting withDefault to provide a default value");
        }
    }

    @Internal
    public static class AsSingleton<T>
    extends PTransform<PCollection<T>, PCollectionView<T>> {
        private final @Nullable T defaultValue;
        private final boolean hasDefault;

        private AsSingleton() {
            this.defaultValue = null;
            this.hasDefault = false;
        }

        private AsSingleton(T defaultValue) {
            this.defaultValue = defaultValue;
            this.hasDefault = true;
        }

        public boolean hasDefaultValue() {
            return this.hasDefault;
        }

        public T defaultValue() {
            return this.defaultValue;
        }

        public AsSingleton<T> withDefaultValue(T defaultValue) {
            return new AsSingleton<T>(defaultValue);
        }

        @Override
        public PCollectionView<T> expand(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            Combine.Globally singletonCombine = Combine.globally(new SingletonCombineFn(this.hasDefault, input.getCoder(), this.defaultValue));
            if (!this.hasDefault) {
                singletonCombine = singletonCombine.withoutDefaults();
            }
            return (PCollectionView)input.apply(singletonCombine.asSingletonView());
        }
    }

    @Internal
    public static class AsIterable<T>
    extends PTransform<PCollection<T>, PCollectionView<Iterable<T>>> {
        private AsIterable() {
        }

        @Override
        public PCollectionView<Iterable<T>> expand(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            Coder<T> inputCoder = input.getCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<T, T>(x -> x){}));
            PCollectionView view = PCollectionViews.iterableView(materializationInput, inputCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    @Internal
    public static class ToListViewDoFn<T>
    extends DoFn<T, KV<Long, PCollectionViews.ValueOrMetadata<T, OffsetRange>>> {
        private Map<BoundedWindow, OffsetRange> windowsToOffsets = new HashMap<BoundedWindow, OffsetRange>();

        private OffsetRange generateRange(BoundedWindow window) {
            long offset = ThreadLocalRandom.current().nextLong(-9223372036854775807L, 9223372034707292160L);
            return new OffsetRange(offset, offset);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            OffsetRange range = this.windowsToOffsets.computeIfAbsent(window, this::generateRange);
            c.output(KV.of(range.getTo(), PCollectionViews.ValueOrMetadata.create(c.element())));
            this.windowsToOffsets.put(window, new OffsetRange(range.getFrom(), range.getTo() + 1L));
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext c) {
            for (Map.Entry<BoundedWindow, OffsetRange> entry : this.windowsToOffsets.entrySet()) {
                c.output(KV.of(Long.MIN_VALUE, PCollectionViews.ValueOrMetadata.createMetadata(entry.getValue())), entry.getKey().maxTimestamp(), entry.getKey());
            }
            this.windowsToOffsets.clear();
        }
    }

    @Internal
    public static class AsList<T>
    extends PTransform<PCollection<T>, PCollectionView<List<T>>> {
        private AsList() {
        }

        @Override
        public PCollectionView<List<T>> expand(PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            Coder<T> inputCoder = input.getCoder();
            PCollection materializationInput = ((PCollection)input.apply("IndexElements", ParDo.of(new ToListViewDoFn()))).setCoder(KvCoder.of(BigEndianLongCoder.of(), PCollectionViews.ValueOrMetadataCoder.create(inputCoder, OffsetRange.Coder.of())));
            PCollectionView view = PCollectionViews.listView(materializationInput, inputCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            materializationInput.apply(CreatePCollectionView.of(view));
            return view;
        }
    }
}

