/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_GaugeResult;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class GaugeResult {
    public abstract long getValue();

    public abstract Instant getTimestamp();

    public static GaugeResult create(long value, Instant timestamp) {
        return new AutoValue_GaugeResult(value, timestamp);
    }

    public static GaugeResult empty() {
        return EmptyGaugeResult.INSTANCE;
    }

    public static class EmptyGaugeResult
    extends GaugeResult {
        private static final EmptyGaugeResult INSTANCE = new EmptyGaugeResult();
        private static final Instant EPOCH = new Instant(0L);

        private EmptyGaugeResult() {
        }

        @Override
        public long getValue() {
            return -1L;
        }

        @Override
        public Instant getTimestamp() {
            return EPOCH;
        }
    }
}

