/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.utils.memory.BufferPool;

public class BufferPoolMetrics {
    public final Meter hits;
    public final Meter misses;
    public final Gauge<Long> size;
    public final Gauge<Long> usedSize;
    public final Gauge<Long> overflowSize;

    public BufferPoolMetrics(String scope, BufferPool bufferPool) {
        DefaultNameFactory factory = new DefaultNameFactory("BufferPool", scope);
        this.hits = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Hits"));
        this.misses = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("Misses"));
        this.overflowSize = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("OverflowSize"), bufferPool::overflowMemoryInBytes);
        this.usedSize = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("UsedSize"), bufferPool::usedSizeInBytes);
        this.size = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("Size"), bufferPool::sizeInBytes);
    }

    public void register3xAlias() {
        DefaultNameFactory legacyFactory = new DefaultNameFactory("BufferPool");
        CassandraMetricsRegistry.Metrics.registerMBean((Metric)this.misses, legacyFactory.createMetricName("Misses").getMBeanName());
        CassandraMetricsRegistry.Metrics.registerMBean((Metric)this.size, legacyFactory.createMetricName("Size").getMBeanName());
    }
}

