/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import org.apache.cassandra.cql3.CqlBuilder;

public final class FunctionName {
    private static final FunctionName TOKEN_FUNCTION_NAME = FunctionName.nativeFunction("token");
    public final String keyspace;
    public final String name;

    public static FunctionName nativeFunction(String name) {
        return new FunctionName("system", name);
    }

    public FunctionName(String keyspace, String name) {
        assert (name != null) : "Name parameter must not be null";
        this.keyspace = keyspace;
        this.name = name;
    }

    public FunctionName asNativeFunction() {
        return FunctionName.nativeFunction(this.name);
    }

    public boolean hasKeyspace() {
        return this.keyspace != null;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace, this.name});
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FunctionName)) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        return Objects.equal((Object)this.keyspace, (Object)that.keyspace) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public final boolean equalsNativeFunction(FunctionName nativeFunction) {
        assert (nativeFunction.keyspace.equals("system"));
        if (this.hasKeyspace() && !this.keyspace.equals("system")) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)nativeFunction.name);
    }

    public String toString() {
        return this.keyspace == null ? this.name : this.keyspace + "." + this.name;
    }

    public void appendCqlTo(CqlBuilder builder) {
        if (this.equalsNativeFunction(TOKEN_FUNCTION_NAME)) {
            builder.append(this.name);
        } else {
            if (this.keyspace != null) {
                builder.appendQuotingIfNeeded(this.keyspace).append('.');
            }
            builder.appendQuotingIfNeeded(this.name);
        }
    }
}

