/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowInfoFn
extends DoFn<HopRow, HopRow> {
    private final String transformName;
    private final String maxWindowField;
    private final String startWindowField;
    private final String endWindowField;
    private final String rowMetaJson;
    private transient Counter readCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;
    private transient int fieldIndex;
    private static final Logger LOG = LoggerFactory.getLogger(WindowInfoFn.class);
    private transient IRowMeta inputRowMeta;
    private transient IValueMeta fieldValueMeta;

    public WindowInfoFn(String transformName, String maxWindowField, String startWindowField, String endWindowField, String rowMetaJson) {
        this.transformName = transformName;
        this.maxWindowField = maxWindowField;
        this.startWindowField = startWindowField;
        this.endWindowField = endWindowField;
        this.rowMetaJson = rowMetaJson;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.transformName);
            BeamHop.init();
            this.inputRowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error in setup of adding window information to rows : " + e.getMessage());
            throw new RuntimeException("Error in setup of adding window information to rows", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext, BoundedWindow window) {
        try {
            IntervalWindow intervalWindow;
            HopRow hopRow = (HopRow)processContext.element();
            this.readCounter.inc();
            Instant instant = window.maxTimestamp();
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])hopRow.getRow(), (int)(this.inputRowMeta.size() + 3));
            int fieldIndex = this.inputRowMeta.size();
            if (StringUtils.isNotEmpty((String)this.startWindowField)) {
                Instant start;
                if (window instanceof IntervalWindow && (start = (intervalWindow = (IntervalWindow)window).start()) != null) {
                    outputRow[fieldIndex] = start.toDate();
                }
                ++fieldIndex;
            }
            if (StringUtils.isNotEmpty((String)this.endWindowField)) {
                Instant end;
                if (window instanceof IntervalWindow && (end = (intervalWindow = (IntervalWindow)window).end()) != null) {
                    outputRow[fieldIndex] = end.toDate();
                }
                ++fieldIndex;
            }
            if (StringUtils.isNotEmpty((String)this.maxWindowField)) {
                Instant maxTimestamp = window.maxTimestamp();
                if (maxTimestamp != null) {
                    outputRow[fieldIndex] = maxTimestamp.toDate();
                }
                ++fieldIndex;
            }
            HopRow outputHopRow = new HopRow(outputRow);
            processContext.outputWithTimestamp((Object)outputHopRow, instant);
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error adding window information to rows : " + String.valueOf(processContext.element()) + ", " + e.getMessage());
            throw new RuntimeException("Error adding window information to rows", e);
        }
    }
}

