/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.cloud.storage.WriteCtx;
import com.google.protobuf.MessageOrBuilder;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ResumableWrite
implements WriteCtx.WriteObjectRequestBuilderFactory {
    private final StartResumableWriteRequest req;
    private final StartResumableWriteResponse res;
    private final WriteObjectRequest writeRequest;

    public ResumableWrite(StartResumableWriteRequest req, StartResumableWriteResponse res) {
        this.req = req;
        this.res = res;
        WriteObjectRequest.Builder b = WriteObjectRequest.newBuilder().setUploadId(res.getUploadId());
        if (req.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(req.getCommonObjectRequestParams());
        }
        this.writeRequest = b.build();
    }

    public StartResumableWriteRequest getReq() {
        return this.req;
    }

    public StartResumableWriteResponse getRes() {
        return this.res;
    }

    @Override
    public WriteObjectRequest.Builder newBuilder() {
        return this.writeRequest.toBuilder();
    }

    @Override
    public @Nullable String bucketName() {
        if (this.req.hasWriteObjectSpec() && this.req.getWriteObjectSpec().hasResource()) {
            return this.req.getWriteObjectSpec().getResource().getBucket();
        }
        return null;
    }

    public String toString() {
        return "ResumableWrite{req=" + StorageV2ProtoUtils.fmtProto((MessageOrBuilder)this.req) + ", res=" + StorageV2ProtoUtils.fmtProto((MessageOrBuilder)this.res) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResumableWrite)) {
            return false;
        }
        ResumableWrite resumableWrite = (ResumableWrite)o;
        return Objects.equals(this.req, resumableWrite.req) && Objects.equals(this.res, resumableWrite.res);
    }

    public int hashCode() {
        return Objects.hash(this.req, this.res);
    }

    static ResumableWrite identity(ResumableWrite w) {
        return w;
    }
}

