/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner;
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean version18;
    boolean noSeparators;
    Calendar tempCalDefault = new GregorianCalendar();

    public RowInputTextLog() {
        super(new byte[0]);
        this.scanner = new Scanner();
    }

    public RowInputTextLog(boolean bl) {
        super(new byte[0]);
        this.scanner = new Scanner();
        this.version18 = bl;
    }

    public void setSource(Session session, String string) {
        this.scanner.reset(session, string);
        this.statementType = 1;
        this.scanner.scanNext();
        int n = this.scanner.getTokenType();
        switch (n) {
            case 145: {
                this.statementType = 3;
                this.scanner.scanNext();
                this.scanner.scanNext();
                this.tableName = this.scanner.getString();
                this.scanner.scanNext();
                break;
            }
            case 84: {
                this.statementType = 2;
                this.scanner.scanNext();
                this.scanner.scanNext();
                this.tableName = this.scanner.getString();
                break;
            }
            case 47: {
                this.statementType = 4;
                break;
            }
            case 268: {
                this.scanner.scanNext();
                n = this.scanner.getTokenType();
                if (n != 519) break;
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean bl;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl2 = bl = this.scanner.getTokenType() == 934;
        if (bl) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (bl) {
            try {
                this.value = this.scanner.getDataType().negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    @Override
    public String readString() {
        this.readField();
        return (String)this.value;
    }

    @Override
    public char readChar() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public byte readByte() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public short readShort() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readInt() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public long readLong() {
        throw Error.runtimeError(201, "RowInputTextLog");
    }

    @Override
    public int readType() {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    @Override
    protected Long readBigint() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (Long)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double readReal() {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object object = this.scanner.getValue();
        double d = ((Number)object).doubleValue();
        if (d != 0.0) throw Error.error(5585);
        if (((Number)this.value).doubleValue() == 1.0) {
            d = Double.POSITIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            d = Double.NEGATIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5585);
            d = Double.NaN;
        }
        this.value = d;
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bigDecimal = (BigDecimal)type.convertToDefaultType(null, this.value);
        return bigDecimal;
    }

    @Override
    protected TimeData readTime(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Time time = Time.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, time.getTime());
            l = HsqlDateTime.getNormalisedTime(l);
            return new TimeData((int)l / 1000, 0, 0);
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Date date = Date.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, date.getTime());
            l = HsqlDateTime.getNormalisedDate(l);
            return new TimestampData(l / 1000L);
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Timestamp timestamp = Timestamp.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, timestamp.getTime());
            int n = timestamp.getNanos();
            n = DateTimeType.normaliseFraction(n, type.scale);
            return new TimestampData(l / 1000L, n, 0);
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    @Override
    protected BinaryData readBit() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 1021) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readUUID() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanUUIDStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 1022) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!string.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        this.scanner.scanNext();
        string = this.scanner.getString();
        if (!string.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.noSeparators = true;
        int n = 0;
        while (!this.scanner.scanSpecialIdentifier("]")) {
            if (n > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object object = this.readData(type);
            hsqlArrayList.add(object);
            ++n;
        }
        this.noSeparators = false;
        Object[] objectArray = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(objectArray);
        return objectArray;
    }
}

