/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfFileDom
extends DocumentImpl
implements NamespaceContext {
    private static final long serialVersionUID = 766167617530147000L;
    protected String mPackagePath;
    protected OdfPackageDocument mPackageDocument;
    protected OdfPackage mPackage;
    protected XPath mXPath;
    protected Map<String, String> mUriByPrefix;
    protected Map<String, String> mPrefixByUri;
    protected Map<String, Set<String>> mDuplicatePrefixesByUri;

    protected OdfFileDom(OdfPackageDocument packageDocument, String packagePath) {
        super(false);
        if (packageDocument == null || packagePath == null) {
            throw new IllegalArgumentException("Arguments are not allowed to be NULL for OdfFileDom constructor!");
        }
        this.mPackageDocument = packageDocument;
        this.mPackage = packageDocument.getPackage();
        this.mPackagePath = packagePath;
        this.mUriByPrefix = new HashMap<String, String>();
        this.mPrefixByUri = new HashMap<String, String>();
        this.mDuplicatePrefixesByUri = new HashMap<String, Set<String>>();
        this.initialize();
        this.addDomToCache(this.mPackageDocument.mPackage, packagePath);
    }

    private void addDomToCache(OdfPackage pkg, String internalPath) {
        pkg.cacheDom((Document)((Object)this), internalPath);
    }

    public static OdfFileDom newFileDom(OdfPackageDocument packageDocument, String packagePath) {
        OdfFileDom newFileDom = null;
        Document existingDom = packageDocument.getPackage().getCachedDom(packagePath);
        if (existingDom == null) {
            newFileDom = packagePath.equals("content.xml") || packagePath.endsWith("/content.xml") ? new OdfContentDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("styles.xml") || packagePath.endsWith("/styles.xml") ? new OdfStylesDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("meta.xml") || packagePath.endsWith("/meta.xml") ? new OdfMetaDom((OdfSchemaDocument)packageDocument, packagePath) : (packagePath.equals("settings.xml") || packagePath.endsWith("/settings.xml") ? new OdfSettingsDom((OdfSchemaDocument)packageDocument, packagePath) : new OdfFileDom(packageDocument, packagePath))));
        } else if (existingDom instanceof OdfFileDom) {
            newFileDom = (OdfFileDom)((Object)existingDom);
        }
        return newFileDom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        InputStream fileStream = null;
        try {
            fileStream = this.mPackage.getInputStream(this.mPackagePath);
            if (fileStream != null) {
                XMLReader xmlReader = this.mPackage.getXMLReader();
                xmlReader.setContentHandler(new OdfFileSaxHandler((Node)((Object)this)));
                InputSource xmlSource = new InputSource(fileStream);
                xmlReader.parse(xmlSource);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public OdfPackageDocument getDocument() {
        return this.mPackageDocument;
    }

    public String getPackagePath() {
        return this.mPackagePath;
    }

    public OdfElement getRootElement() {
        return (OdfElement)((Object)this.getDocumentElement());
    }

    public OdfElement createElement(String name) throws DOMException {
        return this.createElementNS(OdfName.newName(name));
    }

    public OdfElement createElementNS(String nsuri, String qname) throws DOMException {
        return this.createElementNS(OdfName.newName(nsuri, qname));
    }

    public OdfElement createElementNS(OdfName name) throws DOMException {
        return OdfXMLFactory.newOdfElement(this, name);
    }

    public OdfAttribute createAttribute(String name) throws DOMException {
        return this.createAttributeNS(OdfName.newName(name));
    }

    public OdfAttribute createAttributeNS(String nsuri, String qname) throws DOMException {
        return this.createAttributeNS(OdfName.newName(nsuri, qname));
    }

    public OdfAttribute createAttributeNS(OdfName name) throws DOMException {
        return OdfXMLFactory.newOdfAttribute(this, name);
    }

    public <T extends OdfElement> T newOdfElement(Class<T> clazz) {
        try {
            Field fname = clazz.getField("ELEMENT_NAME");
            OdfName name = (OdfName)fname.get(null);
            return (T)((Object)this.createElementNS(name));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            return null;
        }
    }

    public String toString() {
        return ((OdfElement)((Object)this.getDocumentElement())).toString();
    }

    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
        }
        return this.mXPath;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String nsURI = null;
        nsURI = this.mUriByPrefix.get(prefix);
        if (nsURI == null) {
            nsURI = "";
        }
        return nsURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.mPrefixByUri.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Set<String> prefixes = this.mDuplicatePrefixesByUri.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new HashSet<String>();
            this.mDuplicatePrefixesByUri.put(namespaceURI, prefixes);
        }
        prefixes.add(this.mPrefixByUri.get(namespaceURI));
        return prefixes.iterator();
    }

    Map<String, String> getMapNamespacePrefixByUri() {
        return this.mPrefixByUri;
    }

    public OdfNamespace setNamespace(String prefix, String uri) {
        OdfNamespace newNamespace = null;
        String existingPrefix = this.mPrefixByUri.get(uri);
        if (existingPrefix != null) {
            newNamespace = OdfNamespace.newNamespace(existingPrefix, uri);
            Set<String> prefixes = this.mDuplicatePrefixesByUri.get(uri);
            if (prefixes == null) {
                prefixes = new HashSet<String>();
                this.mDuplicatePrefixesByUri.put(uri, prefixes);
            }
            prefixes.add(prefix);
        } else {
            String existingURI = this.mUriByPrefix.get(prefix);
            if (existingURI != null && !existingURI.equals(uri)) {
                int i = 1;
                do {
                    int suffixStart;
                    if ((suffixStart = prefix.lastIndexOf("__")) != -1) {
                        prefix = prefix.substring(0, suffixStart);
                    }
                    prefix = prefix + "__" + i;
                    ++i;
                } while ((existingURI = this.mUriByPrefix.get(prefix)) != null && !existingURI.equals(uri));
            }
            newNamespace = OdfNamespace.newNamespace(prefix, uri);
            this.mPrefixByUri.put(uri, prefix);
            this.mUriByPrefix.put(prefix, uri);
        }
        OdfElement root = this.getRootElement();
        if (root != null) {
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return newNamespace;
    }

    public OdfNamespace setNamespace(NamespaceName name) {
        return this.setNamespace(name.getPrefix(), name.getUri());
    }

    public OdfOfficeStyles getOfficeStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfOfficeAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.newOdfElement(OdfOfficeAutomaticStyles.class);
            Node parent = this.getFirstChild();
            OdfElement sibling = OdfElement.findFirstChildNode(OfficeBodyElement.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild((Node)((Object)automaticStyles));
            } else {
                parent.insertBefore((Node)((Object)automaticStyles), (Node)((Object)sibling));
            }
        }
        return automaticStyles;
    }
}

