/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.RemoteRpc;
import com.google.protobuf.MessageLite;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, Code.UNAVAILABLE, "Invalid response", exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("allocateIds", (MessageLite)request);){
            AllocateIdsResponse allocateIdsResponse = AllocateIdsResponse.parseFrom((InputStream)is);
            return allocateIdsResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("allocateIds", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("beginTransaction", (MessageLite)request);){
            BeginTransactionResponse beginTransactionResponse = BeginTransactionResponse.parseFrom((InputStream)is);
            return beginTransactionResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("beginTransaction", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("commit", (MessageLite)request);){
            CommitResponse commitResponse = CommitResponse.parseFrom((InputStream)is);
            return commitResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("commit", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LookupResponse lookup(LookupRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("lookup", (MessageLite)request);){
            LookupResponse lookupResponse = LookupResponse.parseFrom((InputStream)is);
            return lookupResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("lookup", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("reserveIds", (MessageLite)request);){
            ReserveIdsResponse reserveIdsResponse = ReserveIdsResponse.parseFrom((InputStream)is);
            return reserveIdsResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("reserveIds", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RollbackResponse rollback(RollbackRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("rollback", (MessageLite)request);){
            RollbackResponse rollbackResponse = RollbackResponse.parseFrom((InputStream)is);
            return rollbackResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("rollback", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RunQueryResponse runQuery(RunQueryRequest request) throws DatastoreException {
        try (InputStream is = this.remoteRpc.call("runQuery", (MessageLite)request);){
            RunQueryResponse runQueryResponse = RunQueryResponse.parseFrom((InputStream)is);
            return runQueryResponse;
        }
        catch (IOException exception) {
            throw this.invalidResponseException("runQuery", exception);
        }
    }
}

