/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.pdf.AccessChecker;
import org.apache.tika.parser.pdf.PDF2XHTML;

public class PDFParserConfig
implements Serializable {
    private static final long serialVersionUID = 6492570218190936986L;
    private final Set<String> userConfigured = new HashSet<String>();
    private boolean enableAutoSpace = true;
    private boolean suppressDuplicateOverlappingText = false;
    private boolean extractAnnotationText = true;
    private boolean sortByPosition = false;
    private boolean extractAcroFormContent = true;
    private boolean extractBookmarksText = true;
    private boolean extractInlineImages = false;
    private boolean extractInlineImageMetadataOnly = false;
    private boolean extractUniqueInlineImagesOnly = true;
    private boolean extractMarkedContent = false;
    private Float averageCharTolerance = Float.valueOf(0.3f);
    private Float spacingTolerance = Float.valueOf(0.5f);
    private float dropThreshold = 2.5f;
    private boolean ifXFAExtractOnlyXFA = false;
    private OCR_STRATEGY ocrStrategy = OCR_STRATEGY.AUTO;
    private static final OCRStrategyAuto OCR_STRATEGY_AUTO_BETTER = new OCRStrategyAuto(10.0f, 10);
    private static final OCRStrategyAuto OCR_STRATEGY_AUTO_FASTER = new OCRStrategyAuto(0.1f, 10);
    private static final int OCR_STRATEGY_AUTO_DEFAULT_CHARS_PER_PAGE = 10;
    private OCRStrategyAuto ocrStrategyAuto = OCR_STRATEGY_AUTO_BETTER;
    private OCR_RENDERING_STRATEGY ocrRenderingStrategy = OCR_RENDERING_STRATEGY.ALL;
    private int ocrDPI = 300;
    private ImageType ocrImageType = ImageType.GRAY;
    private String ocrImageFormatName = "png";
    private float ocrImageQuality = 1.0f;
    private AccessChecker accessChecker = new AccessChecker();
    private boolean catchIntermediateIOExceptions = true;
    private boolean extractActions = false;
    private boolean extractFontNames = false;
    private long maxMainMemoryBytes = 0x20000000L;
    private boolean setKCMS = false;
    private boolean detectAngles = false;

    boolean isExtractInlineImageMetadataOnly() {
        return this.extractInlineImageMetadataOnly;
    }

    void setExtractInlineImageMetadataOnly(boolean extractInlineImageMetadataOnly) {
        this.extractInlineImageMetadataOnly = extractInlineImageMetadataOnly;
        this.userConfigured.add("extractInlineImageMetadataOnly");
    }

    public boolean isExtractMarkedContent() {
        return this.extractMarkedContent;
    }

    public void setExtractMarkedContent(boolean extractMarkedContent) {
        this.extractMarkedContent = extractMarkedContent;
        this.userConfigured.add("extractMarkedContent");
    }

    public void configure(PDF2XHTML pdf2XHTML) {
        pdf2XHTML.setSortByPosition(this.isSortByPosition());
        if (this.isEnableAutoSpace()) {
            pdf2XHTML.setWordSeparator(" ");
        } else {
            pdf2XHTML.setWordSeparator("");
        }
        if (this.getAverageCharTolerance() != null) {
            pdf2XHTML.setAverageCharTolerance(this.getAverageCharTolerance().floatValue());
        }
        if (this.getSpacingTolerance() != null) {
            pdf2XHTML.setSpacingTolerance(this.getSpacingTolerance().floatValue());
        }
        if (this.getDropThreshold() != null) {
            pdf2XHTML.setDropThreshold(this.dropThreshold);
        }
        pdf2XHTML.setSuppressDuplicateOverlappingText(this.isSuppressDuplicateOverlappingText());
    }

    public boolean isExtractAcroFormContent() {
        return this.extractAcroFormContent;
    }

    public void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.extractAcroFormContent = extractAcroFormContent;
        this.userConfigured.add("extractAcroFormContent");
    }

    public boolean isIfXFAExtractOnlyXFA() {
        return this.ifXFAExtractOnlyXFA;
    }

    public void setIfXFAExtractOnlyXFA(boolean ifXFAExtractOnlyXFA) {
        this.ifXFAExtractOnlyXFA = ifXFAExtractOnlyXFA;
        this.userConfigured.add("ifXFAExtractOnlyXFA");
    }

    public boolean isExtractBookmarksText() {
        return this.extractBookmarksText;
    }

    public void setExtractBookmarksText(boolean extractBookmarksText) {
        this.extractBookmarksText = extractBookmarksText;
        this.userConfigured.add("extractBookmarksText");
    }

    public boolean isExtractFontNames() {
        return this.extractFontNames;
    }

    public void setExtractFontNames(boolean extractFontNames) {
        this.extractFontNames = extractFontNames;
        this.userConfigured.add("extractFontNames");
    }

    public boolean isExtractInlineImages() {
        return this.extractInlineImages;
    }

    public void setExtractInlineImages(boolean extractInlineImages) {
        this.extractInlineImages = extractInlineImages;
        this.userConfigured.add("extractInlineImages");
    }

    public boolean isExtractUniqueInlineImagesOnly() {
        return this.extractUniqueInlineImagesOnly;
    }

    public void setExtractUniqueInlineImagesOnly(boolean extractUniqueInlineImagesOnly) {
        this.extractUniqueInlineImagesOnly = extractUniqueInlineImagesOnly;
        this.userConfigured.add("extractUniqueInlineImagesOnly");
    }

    public boolean isEnableAutoSpace() {
        return this.enableAutoSpace;
    }

    public void setEnableAutoSpace(boolean enableAutoSpace) {
        this.enableAutoSpace = enableAutoSpace;
        this.userConfigured.add("enableAutoSpace");
    }

    public boolean isSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingText) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingText;
        this.userConfigured.add("suppressDuplicateOverlappingText");
    }

    public boolean isExtractAnnotationText() {
        return this.extractAnnotationText;
    }

    public void setExtractAnnotationText(boolean extractAnnotationText) {
        this.extractAnnotationText = extractAnnotationText;
        this.userConfigured.add("extractAnnotationText");
    }

    public boolean isSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean sortByPosition) {
        this.sortByPosition = sortByPosition;
        this.userConfigured.add("sortByPosition");
    }

    public Float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(Float averageCharTolerance) {
        this.averageCharTolerance = averageCharTolerance;
        this.userConfigured.add("averageCharTolerance");
    }

    public Float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(Float spacingTolerance) {
        this.spacingTolerance = spacingTolerance;
        this.userConfigured.add("spacingTolerance");
    }

    public Float getDropThreshold() {
        return Float.valueOf(this.dropThreshold);
    }

    public void setDropThreshold(Float dropThreshold) {
        this.dropThreshold = dropThreshold.floatValue();
        this.userConfigured.add("dropThreshold");
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public void setAccessChecker(AccessChecker accessChecker) {
        this.accessChecker = accessChecker;
        this.userConfigured.add("accessChecker");
    }

    public boolean isCatchIntermediateIOExceptions() {
        return this.catchIntermediateIOExceptions;
    }

    public void setCatchIntermediateIOExceptions(boolean catchIntermediateIOExceptions) {
        this.catchIntermediateIOExceptions = catchIntermediateIOExceptions;
        this.userConfigured.add("catchIntermediateIOExceptions");
    }

    public OCR_STRATEGY getOcrStrategy() {
        return this.ocrStrategy;
    }

    public OCRStrategyAuto getOcrStrategyAuto() {
        return this.ocrStrategyAuto;
    }

    public void setOcrStrategy(OCR_STRATEGY ocrStrategy) {
        this.ocrStrategy = ocrStrategy;
        this.userConfigured.add("ocrStrategy");
    }

    public void setOcrStrategyAuto(String ocrStrategyAuto) {
        String regex = "^\\s*(faster|better)|(\\d{1,3})(%)?(?:,\\s*(\\d{1,3}))?\\s*$";
        Pattern pattern = Pattern.compile("^\\s*(faster|better)|(\\d{1,3})(%)?(?:,\\s*(\\d{1,3}))?\\s*$");
        Matcher matcher = pattern.matcher(ocrStrategyAuto);
        if (matcher.matches()) {
            String group1 = matcher.group(1);
            if ("better".equals(group1)) {
                this.ocrStrategyAuto = OCR_STRATEGY_AUTO_BETTER;
            } else if ("faster".equals(group1)) {
                this.ocrStrategyAuto = OCR_STRATEGY_AUTO_FASTER;
            } else {
                float unmappedUnicodeCharsPerPage = Integer.parseInt(matcher.group(2));
                if (matcher.group(3) != null) {
                    if ((double)unmappedUnicodeCharsPerPage > 100.0) {
                        throw new IllegalArgumentException("Error parsing OCRStrategyAuto - Percent cannot exceed 100%");
                    }
                    unmappedUnicodeCharsPerPage /= 100.0f;
                }
                int totalCharsPerPage = matcher.group(4) == null ? 10 : Integer.parseInt(matcher.group(4));
                this.ocrStrategyAuto = new OCRStrategyAuto(unmappedUnicodeCharsPerPage, totalCharsPerPage);
            }
        } else {
            throw new IllegalArgumentException("Error parsing OCRStrategyAuto - Must be in the form 'num[%], num'");
        }
        this.userConfigured.add("ocrStrategyAuto");
    }

    public void setOcrStrategy(String ocrStrategyString) {
        this.setOcrStrategy(OCR_STRATEGY.parse(ocrStrategyString));
    }

    public OCR_RENDERING_STRATEGY getOcrRenderingStrategy() {
        return this.ocrRenderingStrategy;
    }

    public void setOcrRenderingStrategy(String ocrRenderingStrategyString) {
        this.setOcrRenderingStrategy(OCR_RENDERING_STRATEGY.parse(ocrRenderingStrategyString));
    }

    public void setOcrRenderingStrategy(OCR_RENDERING_STRATEGY ocrRenderingStrategy) {
        this.ocrRenderingStrategy = ocrRenderingStrategy;
        this.userConfigured.add("ocrRenderingStrategy");
    }

    public String getOcrImageFormatName() {
        return this.ocrImageFormatName;
    }

    public void setOcrImageFormatName(String ocrImageFormatName) {
        if (!(ocrImageFormatName.equals("png") || ocrImageFormatName.equals("tiff") || ocrImageFormatName.equals("jpeg"))) {
            throw new IllegalArgumentException("Available options: png, tiff, jpeg. I'm sorry, but I don't recognize: " + ocrImageFormatName);
        }
        this.ocrImageFormatName = ocrImageFormatName;
        this.userConfigured.add("ocrImageFormatName");
    }

    public ImageType getOcrImageType() {
        return this.ocrImageType;
    }

    public void setOcrImageType(ImageType ocrImageType) {
        this.ocrImageType = ocrImageType;
        this.userConfigured.add("ocrImageType");
    }

    public void setOcrImageType(String ocrImageTypeString) {
        this.ocrImageType = this.parseImageType(ocrImageTypeString);
    }

    public int getOcrDPI() {
        return this.ocrDPI;
    }

    public void setOcrDPI(int ocrDPI) {
        this.ocrDPI = ocrDPI;
        this.userConfigured.add("ocrDPI");
    }

    public float getOcrImageQuality() {
        return this.ocrImageQuality;
    }

    public void setOcrImageQuality(float ocrImageQuality) {
        this.ocrImageQuality = ocrImageQuality;
        this.userConfigured.add("ocrImageQuality");
    }

    public boolean isExtractActions() {
        return this.extractActions;
    }

    public void setExtractActions(boolean v) {
        this.extractActions = v;
        this.userConfigured.add("extractActions");
    }

    public long getMaxMainMemoryBytes() {
        return this.maxMainMemoryBytes;
    }

    public void setMaxMainMemoryBytes(long maxMainMemoryBytes) {
        this.maxMainMemoryBytes = maxMainMemoryBytes;
        this.userConfigured.add("maxMainMemoryBytes");
    }

    public boolean isSetKCMS() {
        return this.setKCMS;
    }

    public void setSetKCMS(boolean setKCMS) {
        this.setKCMS = setKCMS;
        this.userConfigured.add("setKCMS");
    }

    private ImageType parseImageType(String ocrImageType) {
        for (ImageType t : ImageType.values()) {
            if (!ocrImageType.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("I regret that I could not parse '");
        sb.append(ocrImageType);
        sb.append("'. I'm only familiar with: ");
        int i = 0;
        for (ImageType t : ImageType.values()) {
            if (i++ == 0) {
                sb.append(", ");
            }
            sb.append(t.toString());
        }
        throw new IllegalArgumentException(sb.toString());
    }

    public boolean isDetectAngles() {
        return this.detectAngles;
    }

    public void setDetectAngles(boolean detectAngles) {
        this.detectAngles = detectAngles;
        this.userConfigured.add("detectAngles");
    }

    public PDFParserConfig cloneAndUpdate(PDFParserConfig updates) throws TikaException {
        PDFParserConfig updated = new PDFParserConfig();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "userConfigured".equals(field.getName())) continue;
            if (updates.userConfigured.contains(field.getName())) {
                try {
                    field.set(updated, field.get(updates));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new TikaException("can't update " + field.getName(), (Throwable)e);
                }
            }
            try {
                field.set(updated, field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new TikaException("can't update " + field.getName(), (Throwable)e);
            }
        }
        return updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PDFParserConfig)) {
            return false;
        }
        PDFParserConfig config = (PDFParserConfig)o;
        if (this.isEnableAutoSpace() != config.isEnableAutoSpace()) {
            return false;
        }
        if (this.isSuppressDuplicateOverlappingText() != config.isSuppressDuplicateOverlappingText()) {
            return false;
        }
        if (this.isExtractAnnotationText() != config.isExtractAnnotationText()) {
            return false;
        }
        if (this.isSortByPosition() != config.isSortByPosition()) {
            return false;
        }
        if (this.isExtractAcroFormContent() != config.isExtractAcroFormContent()) {
            return false;
        }
        if (this.isExtractBookmarksText() != config.isExtractBookmarksText()) {
            return false;
        }
        if (this.isExtractInlineImages() != config.isExtractInlineImages()) {
            return false;
        }
        if (this.isExtractUniqueInlineImagesOnly() != config.isExtractUniqueInlineImagesOnly()) {
            return false;
        }
        if (this.isIfXFAExtractOnlyXFA() != config.isIfXFAExtractOnlyXFA()) {
            return false;
        }
        if (this.getOcrDPI() != config.getOcrDPI()) {
            return false;
        }
        if (this.isCatchIntermediateIOExceptions() != config.isCatchIntermediateIOExceptions()) {
            return false;
        }
        if (!this.getAverageCharTolerance().equals(config.getAverageCharTolerance())) {
            return false;
        }
        if (!this.getSpacingTolerance().equals(config.getSpacingTolerance())) {
            return false;
        }
        if (!this.getDropThreshold().equals(config.getDropThreshold())) {
            return false;
        }
        if (!this.getOcrStrategy().equals((Object)config.getOcrStrategy())) {
            return false;
        }
        if (this.getOcrImageType() != config.getOcrImageType()) {
            return false;
        }
        if (!this.getOcrImageFormatName().equals(config.getOcrImageFormatName())) {
            return false;
        }
        if (this.isExtractActions() != config.isExtractActions()) {
            return false;
        }
        if (!this.getAccessChecker().equals(config.getAccessChecker())) {
            return false;
        }
        return this.getMaxMainMemoryBytes() == config.getMaxMainMemoryBytes();
    }

    public int hashCode() {
        int result = this.isEnableAutoSpace() ? 1 : 0;
        result = 31 * result + (this.isSuppressDuplicateOverlappingText() ? 1 : 0);
        result = 31 * result + (this.isExtractAnnotationText() ? 1 : 0);
        result = 31 * result + (this.isSortByPosition() ? 1 : 0);
        result = 31 * result + (this.isExtractAcroFormContent() ? 1 : 0);
        result = 31 * result + (this.isExtractBookmarksText() ? 1 : 0);
        result = 31 * result + (this.isExtractInlineImages() ? 1 : 0);
        result = 31 * result + (this.isExtractUniqueInlineImagesOnly() ? 1 : 0);
        result = 31 * result + this.getAverageCharTolerance().hashCode();
        result = 31 * result + this.getSpacingTolerance().hashCode();
        result = 31 * result + this.getDropThreshold().hashCode();
        result = 31 * result + (this.isIfXFAExtractOnlyXFA() ? 1 : 0);
        result = 31 * result + this.ocrStrategy.hashCode();
        result = 31 * result + this.getOcrDPI();
        result = 31 * result + this.getOcrImageType().hashCode();
        result = 31 * result + this.getOcrImageFormatName().hashCode();
        result = 31 * result + this.getAccessChecker().hashCode();
        result = 31 * result + (this.isCatchIntermediateIOExceptions() ? 1 : 0);
        result = 31 * result + (this.isExtractActions() ? 1 : 0);
        result = 31 * result + Long.valueOf(this.getMaxMainMemoryBytes()).hashCode();
        return result;
    }

    public String toString() {
        return "PDFParserConfig{enableAutoSpace=" + this.enableAutoSpace + ", suppressDuplicateOverlappingText=" + this.suppressDuplicateOverlappingText + ", extractAnnotationText=" + this.extractAnnotationText + ", sortByPosition=" + this.sortByPosition + ", extractAcroFormContent=" + this.extractAcroFormContent + ", extractBookmarksText=" + this.extractBookmarksText + ", extractInlineImages=" + this.extractInlineImages + ", extractUniqueInlineImagesOnly=" + this.extractUniqueInlineImagesOnly + ", averageCharTolerance=" + this.averageCharTolerance + ", spacingTolerance=" + this.spacingTolerance + ", dropThreshold=" + this.dropThreshold + ", ifXFAExtractOnlyXFA=" + this.ifXFAExtractOnlyXFA + ", ocrStrategy=" + (Object)((Object)this.ocrStrategy) + ", ocrDPI=" + this.ocrDPI + ", ocrImageType=" + this.ocrImageType + ", ocrImageFormatName='" + this.ocrImageFormatName + '\'' + ", accessChecker=" + this.accessChecker + ", extractActions=" + this.extractActions + ", catchIntermediateIOExceptions=" + this.catchIntermediateIOExceptions + ", maxMainMemoryBytes=" + this.maxMainMemoryBytes + '}';
    }

    public static enum OCR_RENDERING_STRATEGY {
        NO_TEXT,
        ALL;


        private static OCR_RENDERING_STRATEGY parse(String s) {
            if (s == null) {
                return NO_TEXT;
            }
            if ("no_text".equals(s.toLowerCase(Locale.ROOT))) {
                return NO_TEXT;
            }
            if ("all".equals(s.toLowerCase(Locale.ROOT))) {
                return ALL;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("I regret that I don't recognize '").append(s);
            sb.append("' as an OCR_STRATEGY. I only recognize:");
            int i = 0;
            for (OCR_RENDERING_STRATEGY strategy : OCR_RENDERING_STRATEGY.values()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(strategy.toString());
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static class OCRStrategyAuto
    implements Serializable {
        private final float unmappedUnicodeCharsPerPage;
        private final int totalCharsPerPage;

        public OCRStrategyAuto(float unmappedUnicodeCharsPerPage, int totalCharsPerPage) {
            this.totalCharsPerPage = totalCharsPerPage;
            this.unmappedUnicodeCharsPerPage = unmappedUnicodeCharsPerPage;
        }

        public float getUnmappedUnicodeCharsPerPage() {
            return this.unmappedUnicodeCharsPerPage;
        }

        public int getTotalCharsPerPage() {
            return this.totalCharsPerPage;
        }
    }

    public static enum OCR_STRATEGY {
        AUTO,
        NO_OCR,
        OCR_ONLY,
        OCR_AND_TEXT_EXTRACTION;


        private static OCR_STRATEGY parse(String s) {
            if (s == null) {
                return NO_OCR;
            }
            if ("no_ocr".equals(s.toLowerCase(Locale.ROOT))) {
                return NO_OCR;
            }
            if ("ocr_only".equals(s.toLowerCase(Locale.ROOT))) {
                return OCR_ONLY;
            }
            if (s.toLowerCase(Locale.ROOT).contains("ocr_and_text")) {
                return OCR_AND_TEXT_EXTRACTION;
            }
            if ("auto".equals(s.toLowerCase(Locale.ROOT))) {
                return AUTO;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("I regret that I don't recognize '").append(s);
            sb.append("' as an OCR_STRATEGY. I only recognize:");
            int i = 0;
            for (OCR_STRATEGY strategy : OCR_STRATEGY.values()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(strategy.toString());
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

