/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class RowMutationEntry
implements MutationApi<RowMutationEntry>,
Serializable {
    private static final long serialVersionUID = 1974738836742298192L;
    private final ByteString key;
    private final Mutation mutation;

    private RowMutationEntry(@Nonnull ByteString key, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)key, (Object)"Row key can't be null");
        Preconditions.checkNotNull((Object)mutation, (Object)"Row mutation can't be null");
        this.key = key;
        this.mutation = mutation;
    }

    public static RowMutationEntry create(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Row key can't be null");
        return RowMutationEntry.create(ByteString.copyFromUtf8((String)key));
    }

    public static RowMutationEntry create(@Nonnull ByteString key) {
        return new RowMutationEntry(key, Mutation.create());
    }

    @InternalApi(value="For internal usage only")
    public static RowMutationEntry createUnsafe(@Nonnull ByteString key) {
        return new RowMutationEntry(key, Mutation.createUnsafe());
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        this.mutation.deleteCells(familyName, qualifier, timestampRange);
        return this;
    }

    @Override
    public RowMutationEntry deleteFamily(@Nonnull String familyName) {
        this.mutation.deleteFamily(familyName);
        return this;
    }

    @Override
    public RowMutationEntry deleteRow() {
        this.mutation.deleteRow();
        return this;
    }

    @InternalApi
    public MutateRowsRequest.Entry toProto() {
        return MutateRowsRequest.Entry.newBuilder().setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build();
    }
}

