/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeData;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;

class UnicodeDataParser {
    private static final int SBase = 44032;
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int NCount = 588;
    private static final int SCount = 11172;

    private UnicodeDataParser() {
    }

    static NormalizerData build() {
        IntToIntHashMap intToIntHashMap = new IntToIntHashMap(400);
        intToIntHashMap.setDefaultValue(0);
        IntHashMap intHashMap = new IntHashMap(18000);
        IntToIntHashMap intToIntHashMap2 = new IntToIntHashMap(15000);
        intToIntHashMap2.setDefaultValue(65535);
        BitSet bitSet = new BitSet(128000);
        BitSet bitSet2 = new BitSet(128000);
        UnicodeDataParser.readExclusionList(bitSet2);
        UnicodeDataParser.readCompatibilityList(bitSet);
        UnicodeDataParser.readCanonicalClassTable(intToIntHashMap);
        UnicodeDataParser.readDecompositionTable(intHashMap, intToIntHashMap2, bitSet2, bitSet);
        return new NormalizerData(intToIntHashMap, intHashMap, intToIntHashMap2, bitSet, bitSet2);
    }

    private static void readExclusionList(BitSet bitSet) {
        for (int i = 0; i < UnicodeData.exclusionList.length; ++i) {
            String string = UnicodeData.exclusionList[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2, 32);
                bitSet.set(n);
            }
        }
    }

    private static void readCompatibilityList(BitSet bitSet) {
        for (int i = 0; i < UnicodeData.compatibilityList.length; ++i) {
            String string = UnicodeData.compatibilityList[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2, 32);
                bitSet.set(n);
            }
        }
    }

    private static void readCanonicalClassTable(IntToIntHashMap intToIntHashMap) {
        Object object;
        Object object2;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5000);
        for (n = 0; n < UnicodeData.canonicalClassKeys.length; ++n) {
            String string = UnicodeData.canonicalClassKeys[n];
            object2 = new StringTokenizer(string, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                int n2 = Integer.parseInt((String)object, 32);
                arrayList.add(new Integer(n2));
            }
        }
        n = 0;
        for (int i = 0; i < UnicodeData.canonicalClassValues.length; ++i) {
            object2 = UnicodeData.canonicalClassValues[i];
            object = new StringTokenizer((String)object2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                int n3 = Integer.parseInt(string, 32);
                intToIntHashMap.put((Integer)arrayList.get(n++), n3);
            }
        }
    }

    private static void readDecompositionTable(IntHashMap intHashMap, IntToIntHashMap intToIntHashMap, BitSet bitSet, BitSet bitSet2) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < UnicodeData.decompositionKeys.length; ++n2) {
            String string = UnicodeData.decompositionKeys[n2];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2, 32);
                String string3 = UnicodeData.decompositionValues[n3++];
                intHashMap.put(n, string3);
                if (bitSet2.get(n) || bitSet.get(n)) continue;
                char c = '\u0000';
                char c2 = string3.charAt(0);
                if (string3.length() > 1) {
                    c = c2;
                    c2 = string3.charAt(1);
                }
                int n4 = c << 16 | c2;
                intToIntHashMap.put(n4, n);
            }
        }
        for (n2 = 0; n2 < 11172; ++n2) {
            char c;
            char c3;
            int n5 = n2 % 28;
            if (n5 != 0) {
                c3 = (char)(44032 + n2 - n5);
                c = (char)(4519 + n5);
            } else {
                c3 = (char)(4352 + n2 / 588);
                c = (char)(4449 + n2 % 588 / 28);
            }
            n = c3 << 16 | c;
            int n6 = n2 + 44032;
            intHashMap.put(n6, String.valueOf(c3) + c);
            intToIntHashMap.put(n, n6);
        }
    }
}

