/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

public class MetricNames {
    public static final String SUFFIX_RATE = "PerSecond";
    public static final String IO_NUM_RECORDS_IN = "numRecordsIn";
    public static final String IO_NUM_RECORDS_OUT = "numRecordsOut";
    public static final String IO_NUM_RECORDS_IN_RATE = "numRecordsInPerSecond";
    public static final String IO_NUM_RECORDS_OUT_RATE = "numRecordsOutPerSecond";
    public static final String IO_NUM_BYTES_IN = "numBytesIn";
    public static final String IO_NUM_BYTES_OUT = "numBytesOut";
    public static final String IO_NUM_BYTES_IN_RATE = "numBytesInPerSecond";
    public static final String IO_NUM_BYTES_OUT_RATE = "numBytesOutPerSecond";
    public static final String IO_NUM_BUFFERS_IN = "numBuffersIn";
    public static final String IO_NUM_BUFFERS_OUT = "numBuffersOut";
    public static final String IO_NUM_BUFFERS_OUT_RATE = "numBuffersOutPerSecond";
    public static final String IO_CURRENT_INPUT_WATERMARK = "currentInputWatermark";
    @Deprecated
    public static final String IO_CURRENT_INPUT_1_WATERMARK = "currentInput1Watermark";
    @Deprecated
    public static final String IO_CURRENT_INPUT_2_WATERMARK = "currentInput2Watermark";
    public static final String IO_CURRENT_INPUT_WATERMARK_PATERN = "currentInput%dWatermark";
    public static final String IO_CURRENT_OUTPUT_WATERMARK = "currentOutputWatermark";
    public static final String NUM_RUNNING_JOBS = "numRunningJobs";
    public static final String TASK_SLOTS_AVAILABLE = "taskSlotsAvailable";
    public static final String TASK_SLOTS_TOTAL = "taskSlotsTotal";
    public static final String NUM_REGISTERED_TASK_MANAGERS = "numRegisteredTaskManagers";
    public static final String NUM_PENDING_TASK_MANAGERS = "numPendingTaskManagers";
    public static final String NUM_RESTARTS = "numRestarts";
    @Deprecated
    public static final String FULL_RESTARTS = "fullRestarts";
    public static final String MEMORY_USED = "Used";
    public static final String MEMORY_COMMITTED = "Committed";
    public static final String MEMORY_MAX = "Max";
    public static final String IS_BACK_PRESSURED = "isBackPressured";
    public static final String CHECKPOINT_ALIGNMENT_TIME = "checkpointAlignmentTime";
    public static final String CHECKPOINT_START_DELAY_TIME = "checkpointStartDelayNanos";
    public static final String START_WORKER_FAILURE_RATE = "startWorkFailurePerSecond";
    public static final String TASK_IDLE_TIME = "idleTimeMsPerSecond";
    public static final String TASK_BUSY_TIME = "busyTimeMsPerSecond";
    public static final String TASK_BACK_PRESSURED_TIME = "backPressuredTimeMsPerSecond";
    public static final String TASK_SOFT_BACK_PRESSURED_TIME = "softBackPressuredTimeMsPerSecond";
    public static final String TASK_HARD_BACK_PRESSURED_TIME = "hardBackPressuredTimeMsPerSecond";
    public static final String TASK_MAX_SOFT_BACK_PRESSURED_TIME = "maxSoftBackPressureTimeMs";
    public static final String TASK_MAX_HARD_BACK_PRESSURED_TIME = "maxHardBackPressureTimeMs";
    public static final String ESTIMATED_TIME_TO_CONSUME_BUFFERS = "estimatedTimeToConsumeBuffersMs";
    public static final String DEBLOATED_BUFFER_SIZE = "debloatedBufferSize";
    @Deprecated
    public static final String NUM_RECORDS_OUT_ERRORS = "numRecordsOutErrors";
    public static final String NUM_RECORDS_SEND_ERRORS = "numRecordsSendErrors";
    public static final String CURRENT_SEND_TIME = "currentSendTime";
    public static final String NUM_RECORDS_SEND = "numRecordsSend";
    public static final String NUM_BYTES_SEND = "numBytesSend";
    public static final String NUM_RECORDS_IN_ERRORS = "numRecordsInErrors";
    public static final String CURRENT_FETCH_EVENT_TIME_LAG = "currentFetchEventTimeLag";
    public static final String CURRENT_EMIT_EVENT_TIME_LAG = "currentEmitEventTimeLag";
    public static final String WATERMARK_LAG = "watermarkLag";
    public static final String PENDING_RECORDS = "pendingRecords";
    public static final String PENDING_BYTES = "pendingBytes";
    public static final String SOURCE_IDLE_TIME = "sourceIdleTime";
    public static final String WATERMARK_ALIGNMENT_DRIFT = "watermarkAlignmentDrift";

    private MetricNames() {
    }

    public static String currentInputWatermarkName(int index) {
        return String.format(IO_CURRENT_INPUT_WATERMARK_PATERN, index);
    }
}

