/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatReceiver;
import org.apache.flink.runtime.heartbeat.HeartbeatSender;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.NoOpHeartbeatManager;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.EstablishedResourceManagerConnection;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciliationHandler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionGraphException;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationRejection;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.JobMasterException;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.ResourceManagerAddress;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.TaskManagerRegistration;
import org.apache.flink.runtime.jobmaster.TaskManagerRegistrationInformation;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.UnknownKvStateLocation;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.PermanentlyFencedRpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcServiceUtils;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.shuffle.JobShuffleContextImpl;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToJobManagerHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public class JobMaster
extends PermanentlyFencedRpcEndpoint<JobMasterId>
implements JobMasterGateway,
JobMasterService {
    public static final String JOB_MANAGER_NAME = "jobmanager";
    private final JobMasterConfiguration jobMasterConfiguration;
    private final ResourceID resourceId;
    private final JobGraph jobGraph;
    private final Time rpcTimeout;
    private final HighAvailabilityServices highAvailabilityServices;
    private final BlobWriter blobWriter;
    private final HeartbeatServices heartbeatServices;
    private final ScheduledExecutorService futureExecutor;
    private final Executor ioExecutor;
    private final OnCompletionActions jobCompletionActions;
    private final FatalErrorHandler fatalErrorHandler;
    private final ClassLoader userCodeLoader;
    private final SlotPoolService slotPoolService;
    private final long initializationTimestamp;
    private final boolean retrieveTaskManagerHostName;
    private final LeaderRetrievalService resourceManagerLeaderRetriever;
    private final Map<ResourceID, TaskManagerRegistration> registeredTaskManagers;
    private final ShuffleMaster<?> shuffleMaster;
    private final SchedulerNG schedulerNG;
    private final JobManagerJobStatusListener jobStatusListener;
    private final JobManagerJobMetricGroup jobManagerJobMetricGroup;
    private final Map<String, Object> accumulators;
    private final JobMasterPartitionTracker partitionTracker;
    private final ExecutionDeploymentTracker executionDeploymentTracker;
    private final ExecutionDeploymentReconciler executionDeploymentReconciler;
    @Nullable
    private ResourceManagerAddress resourceManagerAddress;
    @Nullable
    private ResourceManagerConnection resourceManagerConnection;
    @Nullable
    private EstablishedResourceManagerConnection establishedResourceManagerConnection;
    private HeartbeatManager<TaskExecutorToJobManagerHeartbeatPayload, AllocatedSlotReport> taskManagerHeartbeatManager;
    private HeartbeatManager<Void, Void> resourceManagerHeartbeatManager;

    public JobMaster(RpcService rpcService, JobMasterId jobMasterId, JobMasterConfiguration jobMasterConfiguration, ResourceID resourceId, JobGraph jobGraph, HighAvailabilityServices highAvailabilityService, SlotPoolServiceSchedulerFactory slotPoolServiceSchedulerFactory, JobManagerSharedServices jobManagerSharedServices, HeartbeatServices heartbeatServices, JobManagerJobMetricGroupFactory jobMetricGroupFactory, OnCompletionActions jobCompletionActions, FatalErrorHandler fatalErrorHandler, ClassLoader userCodeLoader, ShuffleMaster<?> shuffleMaster, PartitionTrackerFactory partitionTrackerFactory, ExecutionDeploymentTracker executionDeploymentTracker, ExecutionDeploymentReconciler.Factory executionDeploymentReconcilerFactory, long initializationTimestamp) throws Exception {
        super(rpcService, RpcServiceUtils.createRandomName((String)JOB_MANAGER_NAME), (Serializable)((Object)jobMasterId));
        ExecutionDeploymentReconciliationHandler executionStateReconciliationHandler = new ExecutionDeploymentReconciliationHandler(){

            @Override
            public void onMissingDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID host) {
                JobMaster.this.log.debug("Failing deployments {} due to no longer being deployed.", executionAttemptIds);
                for (ExecutionAttemptID executionAttemptId : executionAttemptIds) {
                    JobMaster.this.schedulerNG.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.FAILED, (Throwable)new FlinkException(String.format("Execution %s is unexpectedly no longer running on task executor %s.", executionAttemptId, host))));
                }
            }

            @Override
            public void onUnknownDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID host) {
                JobMaster.this.log.debug("Canceling left-over deployments {} on task executor {}.", executionAttemptIds, (Object)host);
                for (ExecutionAttemptID executionAttemptId : executionAttemptIds) {
                    TaskManagerRegistration taskManagerRegistration = (TaskManagerRegistration)JobMaster.this.registeredTaskManagers.get(host);
                    if (taskManagerRegistration == null) continue;
                    taskManagerRegistration.getTaskExecutorGateway().cancelTask(executionAttemptId, JobMaster.this.rpcTimeout);
                }
            }
        };
        this.executionDeploymentTracker = executionDeploymentTracker;
        this.executionDeploymentReconciler = executionDeploymentReconcilerFactory.create(executionStateReconciliationHandler);
        this.jobMasterConfiguration = (JobMasterConfiguration)Preconditions.checkNotNull((Object)jobMasterConfiguration);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
        this.rpcTimeout = jobMasterConfiguration.getRpcTimeout();
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityService);
        this.blobWriter = jobManagerSharedServices.getBlobWriter();
        this.futureExecutor = jobManagerSharedServices.getFutureExecutor();
        this.ioExecutor = jobManagerSharedServices.getIoExecutor();
        this.jobCompletionActions = (OnCompletionActions)Preconditions.checkNotNull((Object)jobCompletionActions);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.userCodeLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeLoader);
        this.initializationTimestamp = initializationTimestamp;
        this.retrieveTaskManagerHostName = jobMasterConfiguration.getConfiguration().getBoolean(JobManagerOptions.RETRIEVE_TASK_MANAGER_HOSTNAME);
        String jobName = jobGraph.getName();
        JobID jid = jobGraph.getJobID();
        this.log.info("Initializing job '{}' ({}).", (Object)jobName, (Object)jid);
        this.resourceManagerLeaderRetriever = this.highAvailabilityServices.getResourceManagerLeaderRetriever();
        this.slotPoolService = ((SlotPoolServiceSchedulerFactory)Preconditions.checkNotNull((Object)slotPoolServiceSchedulerFactory)).createSlotPoolService(jid);
        this.registeredTaskManagers = new HashMap<ResourceID, TaskManagerRegistration>(4);
        this.partitionTracker = ((PartitionTrackerFactory)Preconditions.checkNotNull((Object)partitionTrackerFactory)).create(resourceID -> Optional.ofNullable(this.registeredTaskManagers.get(resourceID)).map(TaskManagerRegistration::getTaskExecutorGateway));
        this.shuffleMaster = (ShuffleMaster)Preconditions.checkNotNull(shuffleMaster);
        this.jobManagerJobMetricGroup = jobMetricGroupFactory.create(jobGraph);
        this.jobStatusListener = new JobManagerJobStatusListener();
        this.schedulerNG = this.createScheduler(slotPoolServiceSchedulerFactory, executionDeploymentTracker, this.jobManagerJobMetricGroup, this.jobStatusListener);
        this.heartbeatServices = (HeartbeatServices)Preconditions.checkNotNull((Object)heartbeatServices);
        this.taskManagerHeartbeatManager = NoOpHeartbeatManager.getInstance();
        this.resourceManagerHeartbeatManager = NoOpHeartbeatManager.getInstance();
        this.resourceManagerConnection = null;
        this.establishedResourceManagerConnection = null;
        this.accumulators = new HashMap<String, Object>();
    }

    private SchedulerNG createScheduler(SlotPoolServiceSchedulerFactory slotPoolServiceSchedulerFactory, ExecutionDeploymentTracker executionDeploymentTracker, JobManagerJobMetricGroup jobManagerJobMetricGroup, JobStatusListener jobStatusListener) throws Exception {
        SchedulerNG scheduler = slotPoolServiceSchedulerFactory.createScheduler(this.log, this.jobGraph, this.ioExecutor, this.jobMasterConfiguration.getConfiguration(), this.slotPoolService, this.futureExecutor, this.userCodeLoader, this.highAvailabilityServices.getCheckpointRecoveryFactory(), this.rpcTimeout, this.blobWriter, jobManagerJobMetricGroup, this.jobMasterConfiguration.getSlotRequestTimeout(), this.shuffleMaster, this.partitionTracker, executionDeploymentTracker, this.initializationTimestamp, (ComponentMainThreadExecutor)this.getMainThreadExecutor(), this.fatalErrorHandler, jobStatusListener);
        return scheduler;
    }

    private HeartbeatManager<Void, Void> createResourceManagerHeartbeatManager(HeartbeatServices heartbeatServices) {
        return heartbeatServices.createHeartbeatManager(this.resourceId, new ResourceManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
    }

    private HeartbeatManager<TaskExecutorToJobManagerHeartbeatPayload, AllocatedSlotReport> createTaskManagerHeartbeatManager(HeartbeatServices heartbeatServices) {
        return heartbeatServices.createHeartbeatManagerSender(this.resourceId, new TaskManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
    }

    protected void onStart() throws JobMasterException {
        try {
            this.startJobExecution();
        }
        catch (Exception e) {
            JobMasterException jobMasterException = new JobMasterException("Could not start the JobMaster.", e);
            this.handleJobMasterError((Throwable)((Object)jobMasterException));
            throw jobMasterException;
        }
    }

    public CompletableFuture<Void> onStop() {
        this.log.info("Stopping the JobMaster for job '{}' ({}).", (Object)this.jobGraph.getName(), (Object)this.jobGraph.getJobID());
        return this.stopJobExecution((Exception)new FlinkException(String.format("Stopping JobMaster for job '%s' (%s).", this.jobGraph.getName(), this.jobGraph.getJobID()))).exceptionally(exception -> {
            throw new CompletionException((Throwable)((Object)new JobMasterException("Could not properly stop the JobMaster.", (Throwable)exception)));
        });
    }

    @Override
    public CompletableFuture<Acknowledge> cancel(Time timeout) {
        this.schedulerNG.cancel();
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public CompletableFuture<Acknowledge> updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        FlinkException taskExecutionException;
        try {
            Preconditions.checkNotNull((Object)taskExecutionState, (String)"taskExecutionState");
            if (this.schedulerNG.updateTaskExecutionState(taskExecutionState)) {
                return CompletableFuture.completedFuture(Acknowledge.get());
            }
            taskExecutionException = new ExecutionGraphException("The execution attempt " + taskExecutionState.getID() + " was not found.");
        }
        catch (Exception e) {
            taskExecutionException = new JobMasterException("Could not update the state of task execution for JobMaster.", e);
            this.handleJobMasterError(taskExecutionException);
        }
        return FutureUtils.completedExceptionally((Throwable)taskExecutionException);
    }

    @Override
    public CompletableFuture<SerializedInputSplit> requestNextInputSplit(JobVertexID vertexID, ExecutionAttemptID executionAttempt) {
        try {
            return CompletableFuture.completedFuture(this.schedulerNG.requestNextInputSplit(vertexID, executionAttempt));
        }
        catch (IOException e) {
            this.log.warn("Error while requesting next input split", (Throwable)e);
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<ExecutionState> requestPartitionState(IntermediateDataSetID intermediateResultId, ResultPartitionID resultPartitionId) {
        try {
            return CompletableFuture.completedFuture(this.schedulerNG.requestPartitionState(intermediateResultId, resultPartitionId));
        }
        catch (PartitionProducerDisposedException e) {
            this.log.info("Error while requesting partition state", (Throwable)e);
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> notifyPartitionDataAvailable(ResultPartitionID partitionID, Time timeout) {
        this.schedulerNG.notifyPartitionDataAvailable(partitionID);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public CompletableFuture<Acknowledge> disconnectTaskManager(ResourceID resourceID, Exception cause) {
        this.log.debug("Disconnect TaskExecutor {} because: {}", (Object)resourceID.getStringWithMetadata(), (Object)cause.getMessage());
        this.taskManagerHeartbeatManager.unmonitorTarget(resourceID);
        this.slotPoolService.releaseTaskManager(resourceID, cause);
        this.partitionTracker.stopTrackingPartitionsFor(resourceID);
        TaskManagerRegistration taskManagerRegistration = this.registeredTaskManagers.remove(resourceID);
        if (taskManagerRegistration != null) {
            taskManagerRegistration.getTaskExecutorGateway().disconnectJobManager(this.jobGraph.getJobID(), cause);
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, @Nullable SerializedValue<TaskStateSnapshot> checkpointState) {
        this.schedulerNG.acknowledgeCheckpoint(jobID, executionAttemptID, checkpointId, checkpointMetrics, TaskStateSnapshot.deserializeTaskStateSnapshot(checkpointState, this.getClass().getClassLoader()));
    }

    @Override
    public void reportCheckpointMetrics(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics) {
        this.schedulerNG.reportCheckpointMetrics(jobID, executionAttemptID, checkpointId, checkpointMetrics);
    }

    @Override
    public void declineCheckpoint(DeclineCheckpoint decline) {
        this.schedulerNG.declineCheckpoint(decline);
    }

    @Override
    public CompletableFuture<Acknowledge> sendOperatorEventToCoordinator(ExecutionAttemptID task, OperatorID operatorID, SerializedValue<OperatorEvent> serializedEvent) {
        try {
            OperatorEvent evt = (OperatorEvent)serializedEvent.deserializeValue(this.userCodeLoader);
            this.schedulerNG.deliverOperatorEventToCoordinator(task, operatorID, evt);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<CoordinationResponse> sendRequestToCoordinator(OperatorID operatorID, SerializedValue<CoordinationRequest> serializedRequest) {
        try {
            CoordinationRequest request = (CoordinationRequest)serializedRequest.deserializeValue(this.userCodeLoader);
            return this.schedulerNG.deliverCoordinationRequestToCoordinator(operatorID, request);
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<KvStateLocation> requestKvStateLocation(JobID jobId, String registrationName) {
        try {
            return CompletableFuture.completedFuture(this.schedulerNG.requestKvStateLocation(jobId, registrationName));
        }
        catch (FlinkJobNotFoundException | UnknownKvStateLocation e) {
            this.log.info("Error while request key-value state location", (Throwable)e);
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) {
        try {
            this.schedulerNG.notifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId, kvStateServerAddress);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (FlinkJobNotFoundException e) {
            this.log.info("Error while receiving notification about key-value state registration", (Throwable)((Object)e));
            return FutureUtils.completedExceptionally((Throwable)((Object)e));
        }
    }

    @Override
    public CompletableFuture<Acknowledge> notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
        try {
            this.schedulerNG.notifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (FlinkJobNotFoundException e) {
            this.log.info("Error while receiving notification about key-value state de-registration", (Throwable)((Object)e));
            return FutureUtils.completedExceptionally((Throwable)((Object)e));
        }
    }

    @Override
    public CompletableFuture<Collection<SlotOffer>> offerSlots(ResourceID taskManagerId, Collection<SlotOffer> slots, Time timeout) {
        TaskManagerRegistration taskManagerRegistration = this.registeredTaskManagers.get(taskManagerId);
        if (taskManagerRegistration == null) {
            return FutureUtils.completedExceptionally((Throwable)new Exception("Unknown TaskManager " + taskManagerId));
        }
        RpcTaskManagerGateway rpcTaskManagerGateway = new RpcTaskManagerGateway(taskManagerRegistration.getTaskExecutorGateway(), (JobMasterId)((Object)this.getFencingToken()));
        return CompletableFuture.completedFuture(this.slotPoolService.offerSlots(taskManagerRegistration.getTaskManagerLocation(), rpcTaskManagerGateway, slots));
    }

    @Override
    public void failSlot(ResourceID taskManagerId, AllocationID allocationId, Exception cause) {
        if (this.registeredTaskManagers.containsKey(taskManagerId)) {
            this.internalFailAllocation(taskManagerId, allocationId, cause);
        } else {
            this.log.warn("Cannot fail slot " + (Object)((Object)allocationId) + " because the TaskManager " + taskManagerId + " is unknown.");
        }
    }

    private void internalFailAllocation(@Nullable ResourceID resourceId, AllocationID allocationId, Exception cause) {
        Optional<ResourceID> resourceIdOptional = this.slotPoolService.failAllocation(resourceId, allocationId, cause);
        resourceIdOptional.ifPresent(taskManagerId -> {
            if (!this.partitionTracker.isTrackingPartitionsFor(taskManagerId)) {
                this.releaseEmptyTaskManager((ResourceID)taskManagerId);
            }
        });
    }

    private void releaseEmptyTaskManager(ResourceID resourceId) {
        this.disconnectTaskManager(resourceId, (Exception)new FlinkException(String.format("No more slots registered at JobMaster %s.", resourceId.getStringWithMetadata())));
    }

    @Override
    public CompletableFuture<RegistrationResponse> registerTaskManager(JobID jobId, TaskManagerRegistrationInformation taskManagerRegistrationInformation, Time timeout) {
        TaskManagerLocation taskManagerLocation;
        if (!this.jobGraph.getJobID().equals((Object)jobId)) {
            this.log.debug("Rejecting TaskManager registration attempt because of wrong job id {}.", (Object)jobId);
            return CompletableFuture.completedFuture(new JMTMRegistrationRejection(String.format("The JobManager is not responsible for job %s. Maybe the TaskManager used outdated connection information.", jobId)));
        }
        try {
            taskManagerLocation = this.resolveTaskManagerLocation(taskManagerRegistrationInformation.getUnresolvedTaskManagerLocation());
        }
        catch (FlinkException exception) {
            this.log.error("Could not accept TaskManager registration.", (Throwable)exception);
            return CompletableFuture.completedFuture(new RegistrationResponse.Failure(exception));
        }
        ResourceID taskManagerId = taskManagerLocation.getResourceID();
        UUID sessionId = taskManagerRegistrationInformation.getTaskManagerSession();
        TaskManagerRegistration taskManagerRegistration = this.registeredTaskManagers.get(taskManagerId);
        if (taskManagerRegistration != null) {
            if (taskManagerRegistration.getSessionId().equals(sessionId)) {
                this.log.debug("Ignoring registration attempt of TaskManager {} with the same session id {}.", (Object)taskManagerId, (Object)sessionId);
                JMTMRegistrationSuccess response = new JMTMRegistrationSuccess(this.resourceId);
                return CompletableFuture.completedFuture(response);
            }
            this.disconnectTaskManager(taskManagerId, (Exception)((Object)new FlinkException("A registered TaskManager re-registered with a new session id. This indicates a restart of the TaskManager. Closing the old connection.")));
        }
        return this.getRpcService().connect(taskManagerRegistrationInformation.getTaskManagerRpcAddress(), TaskExecutorGateway.class).handleAsync((taskExecutorGateway, throwable) -> {
            if (throwable != null) {
                return new RegistrationResponse.Failure((Throwable)throwable);
            }
            this.slotPoolService.registerTaskManager(taskManagerId);
            this.registeredTaskManagers.put(taskManagerId, TaskManagerRegistration.create(taskManagerLocation, taskExecutorGateway, sessionId));
            this.taskManagerHeartbeatManager.monitorTarget(taskManagerId, new TaskExecutorHeartbeatSender((TaskExecutorGateway)taskExecutorGateway));
            return new JMTMRegistrationSuccess(this.resourceId);
        }, (Executor)this.getMainThreadExecutor());
    }

    @Nonnull
    private TaskManagerLocation resolveTaskManagerLocation(UnresolvedTaskManagerLocation unresolvedTaskManagerLocation) throws FlinkException {
        try {
            if (this.retrieveTaskManagerHostName) {
                return TaskManagerLocation.fromUnresolvedLocation(unresolvedTaskManagerLocation, TaskManagerLocation.ResolutionMode.RETRIEVE_HOST_NAME);
            }
            return TaskManagerLocation.fromUnresolvedLocation(unresolvedTaskManagerLocation, TaskManagerLocation.ResolutionMode.USE_IP_ONLY);
        }
        catch (Throwable throwable) {
            String errMsg = String.format("TaskManager address %s cannot be resolved. %s", unresolvedTaskManagerLocation.getExternalAddress(), throwable.getMessage());
            throw new FlinkException(errMsg, throwable);
        }
    }

    @Override
    public void disconnectResourceManager(ResourceManagerId resourceManagerId, Exception cause) {
        if (this.isConnectingToResourceManager(resourceManagerId)) {
            this.reconnectToResourceManager(cause);
        }
    }

    private boolean isConnectingToResourceManager(ResourceManagerId resourceManagerId) {
        return this.resourceManagerAddress != null && this.resourceManagerAddress.getResourceManagerId().equals((Object)resourceManagerId);
    }

    @Override
    public CompletableFuture<Void> heartbeatFromTaskManager(ResourceID resourceID, TaskExecutorToJobManagerHeartbeatPayload payload) {
        return this.taskManagerHeartbeatManager.receiveHeartbeat(resourceID, payload);
    }

    @Override
    public CompletableFuture<Void> heartbeatFromResourceManager(ResourceID resourceID) {
        return this.resourceManagerHeartbeatManager.requestHeartbeat(resourceID, null);
    }

    @Override
    public CompletableFuture<JobDetails> requestJobDetails(Time timeout) {
        return CompletableFuture.completedFuture(this.schedulerNG.requestJobDetails());
    }

    @Override
    public CompletableFuture<JobStatus> requestJobStatus(Time timeout) {
        return CompletableFuture.completedFuture(this.schedulerNG.requestJobStatus());
    }

    @Override
    public CompletableFuture<ExecutionGraphInfo> requestJob(Time timeout) {
        return CompletableFuture.completedFuture(this.schedulerNG.requestJob());
    }

    @Override
    public CompletableFuture<String> triggerSavepoint(@Nullable String targetDirectory, boolean cancelJob, SavepointFormatType formatType, Time timeout) {
        return this.schedulerNG.triggerSavepoint(targetDirectory, cancelJob, formatType);
    }

    @Override
    public CompletableFuture<String> triggerCheckpoint(Time timeout) {
        return this.schedulerNG.triggerCheckpoint();
    }

    @Override
    public CompletableFuture<String> stopWithSavepoint(@Nullable String targetDirectory, SavepointFormatType formatType, boolean terminate, Time timeout) {
        return this.schedulerNG.stopWithSavepoint(targetDirectory, terminate, formatType);
    }

    @Override
    public void notifyAllocationFailure(AllocationID allocationID, Exception cause) {
        this.internalFailAllocation(null, allocationID, cause);
    }

    @Override
    public void notifyNotEnoughResourcesAvailable(Collection<ResourceRequirement> acquiredResources) {
        this.slotPoolService.notifyNotEnoughResourcesAvailable(acquiredResources);
    }

    @Override
    public CompletableFuture<Object> updateGlobalAggregate(String aggregateName, Object aggregand, byte[] serializedAggregateFunction) {
        AggregateFunction aggregateFunction = null;
        try {
            aggregateFunction = (AggregateFunction)InstantiationUtil.deserializeObject((byte[])serializedAggregateFunction, (ClassLoader)this.userCodeLoader);
        }
        catch (Exception e) {
            this.log.error("Error while attempting to deserialize user AggregateFunction.");
            return FutureUtils.completedExceptionally((Throwable)e);
        }
        Object accumulator = this.accumulators.get(aggregateName);
        if (null == accumulator) {
            accumulator = aggregateFunction.createAccumulator();
        }
        accumulator = aggregateFunction.add(aggregand, accumulator);
        this.accumulators.put(aggregateName, accumulator);
        return CompletableFuture.completedFuture(aggregateFunction.getResult(accumulator));
    }

    @Override
    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID operatorId, SerializedValue<CoordinationRequest> serializedRequest, Time timeout) {
        return this.sendRequestToCoordinator(operatorId, serializedRequest);
    }

    @Override
    public CompletableFuture<?> stopTrackingAndReleasePartitions(Collection<ResultPartitionID> partitionIds) {
        CompletableFuture future = new CompletableFuture();
        try {
            this.partitionTracker.stopTrackingAndReleasePartitions(partitionIds, false);
            future.complete(null);
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    private void startJobExecution() throws Exception {
        this.validateRunsInMainThread();
        JobShuffleContextImpl context = new JobShuffleContextImpl(this.jobGraph.getJobID(), this);
        this.shuffleMaster.registerJob(context);
        this.startJobMasterServices();
        this.log.info("Starting execution of job '{}' ({}) under job master id {}.", new Object[]{this.jobGraph.getName(), this.jobGraph.getJobID(), this.getFencingToken()});
        this.startScheduling();
    }

    private void startJobMasterServices() throws Exception {
        try {
            this.taskManagerHeartbeatManager = this.createTaskManagerHeartbeatManager(this.heartbeatServices);
            this.resourceManagerHeartbeatManager = this.createResourceManagerHeartbeatManager(this.heartbeatServices);
            this.slotPoolService.start((JobMasterId)((Object)this.getFencingToken()), this.getAddress(), (ComponentMainThreadExecutor)this.getMainThreadExecutor());
            this.resourceManagerLeaderRetriever.start(new ResourceManagerLeaderListener());
        }
        catch (Exception e) {
            this.handleStartJobMasterServicesError(e);
        }
    }

    private void handleStartJobMasterServicesError(Exception e) throws Exception {
        try {
            this.stopJobMasterServices();
        }
        catch (Exception inner) {
            e.addSuppressed(inner);
        }
        throw e;
    }

    private void stopJobMasterServices() throws Exception {
        Exception resultingException = null;
        try {
            this.resourceManagerLeaderRetriever.stop();
        }
        catch (Exception e) {
            resultingException = e;
        }
        this.slotPoolService.close();
        this.stopHeartbeatServices();
        ExceptionUtils.tryRethrowException((Exception)resultingException);
    }

    private CompletableFuture<Void> stopJobExecution(Exception cause) {
        this.validateRunsInMainThread();
        CompletableFuture<Void> terminationFuture = this.stopScheduling();
        return FutureUtils.runAfterwards(terminationFuture, () -> {
            this.shuffleMaster.unregisterJob(this.jobGraph.getJobID());
            this.disconnectTaskManagerResourceManagerConnections(cause);
            this.stopJobMasterServices();
        });
    }

    private void disconnectTaskManagerResourceManagerConnections(Exception cause) {
        HashSet<ResourceID> taskManagerResourceIds = new HashSet<ResourceID>(this.registeredTaskManagers.keySet());
        for (ResourceID taskManagerResourceId : taskManagerResourceIds) {
            this.disconnectTaskManager(taskManagerResourceId, cause);
        }
        this.closeResourceManagerConnection(cause);
    }

    private void stopHeartbeatServices() {
        this.taskManagerHeartbeatManager.stop();
        this.resourceManagerHeartbeatManager.stop();
    }

    private void startScheduling() {
        this.schedulerNG.startScheduling();
    }

    private CompletableFuture<Void> stopScheduling() {
        this.jobManagerJobMetricGroup.close();
        this.jobStatusListener.stop();
        return this.schedulerNG.closeAsync();
    }

    private void handleJobMasterError(Throwable cause) {
        if (ExceptionUtils.isJvmFatalError((Throwable)cause)) {
            this.log.error("Fatal error occurred on JobManager.", cause);
            this.fatalErrorHandler.onFatalError(cause);
        } else {
            this.jobCompletionActions.jobMasterFailed(cause);
        }
    }

    private void jobStatusChanged(JobStatus newJobStatus) {
        this.validateRunsInMainThread();
        if (newJobStatus.isGloballyTerminalState()) {
            this.runAsync(() -> {
                Collection allTracked = this.partitionTracker.getAllTrackedPartitions().stream().map(d -> d.getShuffleDescriptor().getResultPartitionID()).collect(Collectors.toList());
                if (newJobStatus == JobStatus.FINISHED) {
                    this.partitionTracker.stopTrackingAndReleaseOrPromotePartitions(allTracked);
                } else {
                    this.partitionTracker.stopTrackingAndReleasePartitions(allTracked);
                }
            });
            ExecutionGraphInfo executionGraphInfo = this.schedulerNG.requestJob();
            this.futureExecutor.execute(() -> this.jobCompletionActions.jobReachedGloballyTerminalState(executionGraphInfo));
        }
    }

    private void notifyOfNewResourceManagerLeader(String newResourceManagerAddress, ResourceManagerId resourceManagerId) {
        this.resourceManagerAddress = this.createResourceManagerAddress(newResourceManagerAddress, resourceManagerId);
        this.reconnectToResourceManager((Exception)((Object)new FlinkException(String.format("ResourceManager leader changed to new address %s", this.resourceManagerAddress))));
    }

    @Nullable
    private ResourceManagerAddress createResourceManagerAddress(@Nullable String newResourceManagerAddress, @Nullable ResourceManagerId resourceManagerId) {
        if (newResourceManagerAddress != null) {
            Preconditions.checkNotNull((Object)((Object)resourceManagerId));
            return new ResourceManagerAddress(newResourceManagerAddress, resourceManagerId);
        }
        return null;
    }

    private void reconnectToResourceManager(Exception cause) {
        this.closeResourceManagerConnection(cause);
        this.tryConnectToResourceManager();
    }

    private void tryConnectToResourceManager() {
        if (this.resourceManagerAddress != null) {
            this.connectToResourceManager();
        }
    }

    private void connectToResourceManager() {
        assert (this.resourceManagerAddress != null);
        assert (this.resourceManagerConnection == null);
        assert (this.establishedResourceManagerConnection == null);
        this.log.info("Connecting to ResourceManager {}", (Object)this.resourceManagerAddress);
        this.resourceManagerConnection = new ResourceManagerConnection(this.log, this.jobGraph.getJobID(), this.resourceId, this.getAddress(), (JobMasterId)((Object)this.getFencingToken()), this.resourceManagerAddress.getAddress(), this.resourceManagerAddress.getResourceManagerId(), this.futureExecutor);
        this.resourceManagerConnection.start();
    }

    private void establishResourceManagerConnection(JobMasterRegistrationSuccess success) {
        ResourceManagerId resourceManagerId = success.getResourceManagerId();
        if (this.resourceManagerConnection != null && Objects.equals(this.resourceManagerConnection.getTargetLeaderId(), (Object)resourceManagerId)) {
            this.log.info("JobManager successfully registered at ResourceManager, leader id: {}.", (Object)resourceManagerId);
            ResourceManagerGateway resourceManagerGateway = (ResourceManagerGateway)this.resourceManagerConnection.getTargetGateway();
            ResourceID resourceManagerResourceId = success.getResourceManagerResourceId();
            this.establishedResourceManagerConnection = new EstablishedResourceManagerConnection(resourceManagerGateway, resourceManagerResourceId);
            this.slotPoolService.connectToResourceManager(resourceManagerGateway);
            this.resourceManagerHeartbeatManager.monitorTarget(resourceManagerResourceId, new ResourceManagerHeartbeatReceiver(resourceManagerGateway));
        } else {
            this.log.debug("Ignoring resource manager connection to {} because it's duplicated or outdated.", (Object)resourceManagerId);
        }
    }

    private void closeResourceManagerConnection(Exception cause) {
        if (this.establishedResourceManagerConnection != null) {
            this.dissolveResourceManagerConnection(this.establishedResourceManagerConnection, cause);
            this.establishedResourceManagerConnection = null;
        }
        if (this.resourceManagerConnection != null) {
            this.resourceManagerConnection.close();
            this.resourceManagerConnection = null;
        }
    }

    private void dissolveResourceManagerConnection(EstablishedResourceManagerConnection establishedResourceManagerConnection, Exception cause) {
        ResourceID resourceManagerResourceID = establishedResourceManagerConnection.getResourceManagerResourceID();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Close ResourceManager connection {}.", (Object)resourceManagerResourceID.getStringWithMetadata(), (Object)cause);
        } else {
            this.log.info("Close ResourceManager connection {}: {}", (Object)resourceManagerResourceID.getStringWithMetadata(), (Object)cause.getMessage());
        }
        this.resourceManagerHeartbeatManager.unmonitorTarget(resourceManagerResourceID);
        ResourceManagerGateway resourceManagerGateway = establishedResourceManagerConnection.getResourceManagerGateway();
        resourceManagerGateway.disconnectJobManager(this.jobGraph.getJobID(), this.schedulerNG.requestJobStatus(), cause);
        this.slotPoolService.disconnectResourceManager();
    }

    @Override
    public JobMasterGateway getGateway() {
        return (JobMasterGateway)this.getSelfGateway(JobMasterGateway.class);
    }

    private class ResourceManagerHeartbeatListener
    implements HeartbeatListener<Void, Void> {
        private ResourceManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceId) {
            String message = String.format("The heartbeat of ResourceManager with id %s timed out.", resourceId.getStringWithMetadata());
            JobMaster.this.log.info(message);
            this.handleResourceManagerConnectionLoss(resourceId, new TimeoutException(message));
        }

        private void handleResourceManagerConnectionLoss(ResourceID resourceId, Exception cause) {
            JobMaster.this.validateRunsInMainThread();
            if (JobMaster.this.establishedResourceManagerConnection != null && JobMaster.this.establishedResourceManagerConnection.getResourceManagerResourceID().equals(resourceId)) {
                JobMaster.this.reconnectToResourceManager(cause);
            }
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("ResourceManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            JobMaster.this.log.info(message);
            this.handleResourceManagerConnectionLoss(resourceID, (Exception)((Object)new JobMasterException(message)));
        }

        @Override
        public void reportPayload(ResourceID resourceID, Void payload) {
        }

        @Override
        public Void retrievePayload(ResourceID resourceID) {
            return null;
        }
    }

    private class TaskManagerHeartbeatListener
    implements HeartbeatListener<TaskExecutorToJobManagerHeartbeatPayload, AllocatedSlotReport> {
        private TaskManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceID) {
            String message = String.format("Heartbeat of TaskManager with id %s timed out.", resourceID.getStringWithMetadata());
            JobMaster.this.log.info(message);
            this.handleTaskManagerConnectionLoss(resourceID, new TimeoutException(message));
        }

        private void handleTaskManagerConnectionLoss(ResourceID resourceID, Exception cause) {
            JobMaster.this.validateRunsInMainThread();
            JobMaster.this.disconnectTaskManager(resourceID, cause);
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("TaskManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            JobMaster.this.log.info(message);
            this.handleTaskManagerConnectionLoss(resourceID, (Exception)((Object)new JobMasterException(message)));
        }

        @Override
        public void reportPayload(ResourceID resourceID, TaskExecutorToJobManagerHeartbeatPayload payload) {
            JobMaster.this.validateRunsInMainThread();
            JobMaster.this.executionDeploymentReconciler.reconcileExecutionDeployments(resourceID, payload.getExecutionDeploymentReport(), JobMaster.this.executionDeploymentTracker.getExecutionsOn(resourceID));
            for (AccumulatorSnapshot snapshot : payload.getAccumulatorReport().getAccumulatorSnapshots()) {
                JobMaster.this.schedulerNG.updateAccumulators(snapshot);
            }
        }

        @Override
        public AllocatedSlotReport retrievePayload(ResourceID resourceID) {
            JobMaster.this.validateRunsInMainThread();
            return JobMaster.this.slotPoolService.createAllocatedSlotReport(resourceID);
        }
    }

    private class JobManagerJobStatusListener
    implements JobStatusListener {
        private volatile boolean running = true;

        private JobManagerJobStatusListener() {
        }

        @Override
        public void jobStatusChanges(JobID jobId, JobStatus newJobStatus, long timestamp) {
            if (this.running) {
                JobMaster.this.runAsync(() -> JobMaster.this.jobStatusChanged(newJobStatus));
            }
        }

        private void stop() {
            this.running = false;
        }
    }

    private class ResourceManagerConnection
    extends RegisteredRpcConnection<ResourceManagerId, ResourceManagerGateway, JobMasterRegistrationSuccess, RegistrationResponse.Rejection> {
        private final JobID jobID;
        private final ResourceID jobManagerResourceID;
        private final String jobManagerRpcAddress;
        private final JobMasterId jobMasterId;

        ResourceManagerConnection(Logger log, JobID jobID, ResourceID jobManagerResourceID, String jobManagerRpcAddress, JobMasterId jobMasterId, String resourceManagerAddress, ResourceManagerId resourceManagerId, Executor executor) {
            super(log, resourceManagerAddress, resourceManagerId, executor);
            this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
            this.jobManagerResourceID = (ResourceID)Preconditions.checkNotNull((Object)jobManagerResourceID);
            this.jobManagerRpcAddress = (String)Preconditions.checkNotNull((Object)jobManagerRpcAddress);
            this.jobMasterId = (JobMasterId)((Object)Preconditions.checkNotNull((Object)((Object)jobMasterId)));
        }

        @Override
        protected RetryingRegistration<ResourceManagerId, ResourceManagerGateway, JobMasterRegistrationSuccess, RegistrationResponse.Rejection> generateRegistration() {
            return new RetryingRegistration<ResourceManagerId, ResourceManagerGateway, JobMasterRegistrationSuccess, RegistrationResponse.Rejection>(this.log, JobMaster.this.getRpcService(), "ResourceManager", ResourceManagerGateway.class, this.getTargetAddress(), (ResourceManagerId)((Object)this.getTargetLeaderId()), JobMaster.this.jobMasterConfiguration.getRetryingRegistrationConfiguration()){

                @Override
                protected CompletableFuture<RegistrationResponse> invokeRegistration(ResourceManagerGateway gateway, ResourceManagerId fencingToken, long timeoutMillis) {
                    Time timeout = Time.milliseconds((long)timeoutMillis);
                    return gateway.registerJobMaster(ResourceManagerConnection.this.jobMasterId, ResourceManagerConnection.this.jobManagerResourceID, ResourceManagerConnection.this.jobManagerRpcAddress, ResourceManagerConnection.this.jobID, timeout);
                }
            };
        }

        @Override
        protected void onRegistrationSuccess(JobMasterRegistrationSuccess success) {
            JobMaster.this.runAsync(() -> {
                if (this == JobMaster.this.resourceManagerConnection) {
                    JobMaster.this.establishResourceManagerConnection(success);
                }
            });
        }

        @Override
        protected void onRegistrationRejection(RegistrationResponse.Rejection rejection) {
            JobMaster.this.handleJobMasterError(new IllegalStateException("The ResourceManager should never reject a JobMaster registration."));
        }

        @Override
        protected void onRegistrationFailure(Throwable failure) {
            JobMaster.this.handleJobMasterError(failure);
        }
    }

    private class ResourceManagerLeaderListener
    implements LeaderRetrievalListener {
        private ResourceManagerLeaderListener() {
        }

        @Override
        public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
            JobMaster.this.runAsync(() -> JobMaster.this.notifyOfNewResourceManagerLeader(leaderAddress, ResourceManagerId.fromUuidOrNull(leaderSessionID)));
        }

        @Override
        public void handleError(Exception exception) {
            JobMaster.this.handleJobMasterError(new Exception("Fatal error in the ResourceManager leader service", exception));
        }
    }

    private static final class ResourceManagerHeartbeatReceiver
    extends HeartbeatReceiver<Void> {
        private final ResourceManagerGateway resourceManagerGateway;

        private ResourceManagerHeartbeatReceiver(ResourceManagerGateway resourceManagerGateway) {
            this.resourceManagerGateway = resourceManagerGateway;
        }

        @Override
        public CompletableFuture<Void> receiveHeartbeat(ResourceID resourceID, Void payload) {
            return this.resourceManagerGateway.heartbeatFromJobManager(resourceID);
        }
    }

    private static final class TaskExecutorHeartbeatSender
    extends HeartbeatSender<AllocatedSlotReport> {
        private final TaskExecutorGateway taskExecutorGateway;

        private TaskExecutorHeartbeatSender(TaskExecutorGateway taskExecutorGateway) {
            this.taskExecutorGateway = taskExecutorGateway;
        }

        @Override
        public CompletableFuture<Void> requestHeartbeat(ResourceID resourceID, AllocatedSlotReport allocatedSlotReport) {
            return this.taskExecutorGateway.heartbeatFromJobManager(resourceID, allocatedSlotReport);
        }
    }
}

