/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.PartitionRequestClient;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyClient;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.util.Preconditions;

public class NettyConnectionManager
implements ConnectionManager {
    private final NettyServer server;
    private final NettyClient client;
    private final NettyBufferPool bufferPool;
    private final PartitionRequestClientFactory partitionRequestClientFactory;
    private final NettyProtocol nettyProtocol;

    public NettyConnectionManager(ResultPartitionProvider partitionProvider, TaskEventPublisher taskEventPublisher, NettyConfig nettyConfig, int maxNumberOfConnections, boolean connectionReuseEnabled) {
        this(new NettyBufferPool(nettyConfig.getNumberOfArenas()), partitionProvider, taskEventPublisher, nettyConfig, maxNumberOfConnections, connectionReuseEnabled);
    }

    @VisibleForTesting
    public NettyConnectionManager(NettyBufferPool bufferPool, ResultPartitionProvider partitionProvider, TaskEventPublisher taskEventPublisher, NettyConfig nettyConfig, int maxNumberOfConnections, boolean connectionReuseEnabled) {
        this.server = new NettyServer(nettyConfig);
        this.client = new NettyClient(nettyConfig);
        this.bufferPool = (NettyBufferPool)((Object)Preconditions.checkNotNull((Object)((Object)bufferPool)));
        this.partitionRequestClientFactory = new PartitionRequestClientFactory(this.client, nettyConfig.getNetworkRetries(), maxNumberOfConnections, connectionReuseEnabled);
        this.nettyProtocol = new NettyProtocol((ResultPartitionProvider)Preconditions.checkNotNull((Object)partitionProvider), (TaskEventPublisher)Preconditions.checkNotNull((Object)taskEventPublisher));
    }

    @Override
    public int start() throws IOException {
        this.client.init(this.nettyProtocol, this.bufferPool);
        return this.server.init(this.nettyProtocol, this.bufferPool);
    }

    @Override
    public PartitionRequestClient createPartitionRequestClient(ConnectionID connectionId) throws IOException, InterruptedException {
        return this.partitionRequestClientFactory.createPartitionRequestClient(connectionId);
    }

    @Override
    public void closeOpenChannelConnections(ConnectionID connectionId) {
        this.partitionRequestClientFactory.closeOpenChannelConnections(connectionId);
    }

    @Override
    public int getNumberOfActiveConnections() {
        return this.partitionRequestClientFactory.getNumberOfActiveClients();
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
        this.server.shutdown();
    }

    NettyClient getClient() {
        return this.client;
    }

    NettyServer getServer() {
        return this.server;
    }

    NettyBufferPool getBufferPool() {
        return this.bufferPool;
    }
}

