/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.TriggerSavepointFunction;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.dispatcher.UnknownOperationKeyException;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.util.concurrent.FutureUtils;

public class DispatcherCachedOperationsHandler {
    private final CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache;
    private final TriggerSavepointFunction triggerSavepointFunction;
    private final TriggerSavepointFunction stopWithSavepointFunction;

    DispatcherCachedOperationsHandler(DispatcherOperationCaches operationCaches, TriggerSavepointFunction triggerSavepointFunction, TriggerSavepointFunction stopWithSavepointFunction) {
        this(triggerSavepointFunction, stopWithSavepointFunction, operationCaches.getSavepointTriggerCache());
    }

    @VisibleForTesting
    DispatcherCachedOperationsHandler(TriggerSavepointFunction triggerSavepointFunction, TriggerSavepointFunction stopWithSavepointFunction, CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache) {
        this.triggerSavepointFunction = triggerSavepointFunction;
        this.stopWithSavepointFunction = stopWithSavepointFunction;
        this.savepointTriggerCache = savepointTriggerCache;
    }

    public CompletableFuture<Acknowledge> triggerSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Time timeout) {
        return this.registerOperationIdempotently(operationKey, () -> this.triggerSavepointFunction.apply(operationKey.getJobId(), targetDirectory, formatType, savepointMode, timeout));
    }

    public CompletableFuture<Acknowledge> stopWithSavepoint(AsynchronousJobOperationKey operationKey, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Time timeout) {
        return this.registerOperationIdempotently(operationKey, () -> this.stopWithSavepointFunction.apply(operationKey.getJobId(), targetDirectory, formatType, savepointMode, timeout));
    }

    public CompletableFuture<OperationResult<String>> getSavepointStatus(AsynchronousJobOperationKey operationKey) {
        return this.savepointTriggerCache.get(operationKey).map(CompletableFuture::completedFuture).orElse(FutureUtils.completedExceptionally((Throwable)((Object)new UnknownOperationKeyException(operationKey))));
    }

    private CompletableFuture<Acknowledge> registerOperationIdempotently(AsynchronousJobOperationKey operationKey, Supplier<CompletableFuture<String>> operation) {
        if (!this.savepointTriggerCache.containsOperation(operationKey)) {
            this.savepointTriggerCache.registerOngoingOperation(operationKey, operation.get());
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }
}

