/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.SwapFailedException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class Swapper {
    private Swapper() {
    }

    public static void swap(AS400 aS400, ProfileTokenCredential profileTokenCredential) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (profileTokenCredential == null) {
            throw new NullPointerException("newCredential");
        }
        if (aS400.canUseNativeOptimizations()) {
            Trace.log(4, "When running natively, swaps should be performed via ProfileTokenCredential.swap() instead of Swapper.swap().");
        }
        Swapper.swapToToken(aS400, profileTokenCredential.getToken());
        profileTokenCredential.fireSwapped();
    }

    public static void swap(Connection connection, ProfileTokenCredential profileTokenCredential) throws AS400SecurityException, IOException, SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (profileTokenCredential == null) {
            throw new NullPointerException("newCredential");
        }
        Swapper.swapToToken(connection, profileTokenCredential.getToken());
        profileTokenCredential.fireSwapped();
    }

    public static void swapToToken(AS400 aS400, byte[] byArray) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (byArray == null) {
            throw new NullPointerException("token");
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QSYSETPT.PGM", programParameterArray);
        programCall.suggestThreadsafe();
        try {
            if (!programCall.run()) {
                throw new SwapFailedException(programCall.getMessageList());
            }
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            if (aS400MessageArray != null && aS400MessageArray.length != 0) {
                System.out.println("Messages returned from QSYSETPT:");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    System.out.println(aS400MessageArray[i].toString());
                }
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw aS400SecurityException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void swapToToken(Connection connection, byte[] byArray) throws AS400SecurityException, IOException, SQLException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (byArray == null) {
            throw new NullPointerException("token");
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("CALL QSYS");
        stringBuffer.append(connection.getMetaData().getCatalogSeparator());
        stringBuffer.append("QSYSETPT (X'");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n = 256 + n;
            } else if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
        }
        stringBuffer.append("', X'0000')");
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(stringBuffer.toString());
            SQLWarning sQLWarning = statement.getWarnings();
            if (sQLWarning != null) {
                System.out.println("SQLWarning: " + sQLWarning.getErrorCode() + ": " + sQLWarning.getSQLState());
            }
            Object var6_7 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                if (!Trace.isTraceOn()) throw throwable;
                Trace.log(2, "Error while closing statement", (Throwable)exception);
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (Exception exception) {
            if (!Trace.isTraceOn()) return;
            Trace.log(2, "Error while closing statement", (Throwable)exception);
        }
    }
}

