/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

public class ConverterImplRemote
implements ConverterImpl {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public ConvTable table_;

    public ConverterImplRemote() {
    }

    public ConverterImplRemote(ConvTable convTable) {
        this.table_ = convTable;
    }

    String byteArrayToString(byte[] byArray) {
        return this.byteArrayToString(byArray, 0, byArray.length, new BidiConversionProperties());
    }

    String byteArrayToString(byte[] byArray, int n) {
        return this.byteArrayToString(byArray, n, byArray.length - n, new BidiConversionProperties());
    }

    public String byteArrayToString(byte[] byArray, int n, int n2) {
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties());
    }

    public String byteArrayToString(byte[] byArray, int n, int n2, int n3) {
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties(n3));
    }

    public String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        return this.table_.byteArrayToString(byArray, n, n2, bidiConversionProperties);
    }

    static ConverterImplRemote getConverter(int n, AS400ImplRemote aS400ImplRemote) throws UnsupportedEncodingException {
        return new ConverterImplRemote(ConvTable.getTable(n, aS400ImplRemote));
    }

    public String getEncoding() {
        return this.table_.getEncoding();
    }

    public int getCcsid() {
        return this.table_.getCcsid();
    }

    int getStringType(int n) {
        if (AS400BidiTransform.isBidiCcsid(n)) {
            return AS400BidiTransform.getStringType(n);
        }
        return 0;
    }

    public void setCcsid(int n, AS400Impl aS400Impl) throws UnsupportedEncodingException {
        this.table_ = ConvTable.getTable(n, null);
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        this.table_ = ConvTable.getTable(string);
    }

    public byte[] stringToByteArray(String string) {
        return this.stringToByteArray(string, new BidiConversionProperties());
    }

    public byte[] stringToByteArray(String string, int n) {
        return this.stringToByteArray(string, new BidiConversionProperties(n));
    }

    public byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        return this.table_.stringToByteArray(string, bidiConversionProperties);
    }

    void stringToByteArray(String string, byte[] byArray) throws CharConversionException {
        byte[] byArray2 = this.stringToByteArray(string, new BidiConversionProperties());
        if (byArray2.length > byArray.length) {
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + string.length() + "," + byArray.length);
            }
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        byte[] byArray2 = this.stringToByteArray(string, new BidiConversionProperties());
        if (byArray2.length > byArray.length - n) {
            System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + string.length() + "," + byArray.length + "," + n);
            }
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties());
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties(n3));
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        byte[] byArray2 = this.stringToByteArray(string, bidiConversionProperties);
        if (byArray2.length > n2) {
            System.arraycopy(byArray2, 0, byArray, n, n2);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + string.length() + "," + byArray.length + "," + n + "," + n2);
            }
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }
}

