/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public final class ExecutionBuilder {
    public String name;
    public String filename;
    public String id;
    public String parentId;
    public ExecutionType executionType;
    public String executorXml;
    public String metadataJson;
    public Map<String, String> variableValues = new HashMap<String, String>();
    public String runConfigurationName;
    public LogLevel logLevel;
    public Map<String, String> parameterValues = new HashMap<String, String>();
    public Map<String, String> environmentDetails = new HashMap<String, String>();
    public Date registrationDate = new Date();
    public Date executionStartDate;
    public String copyNr;

    private ExecutionBuilder() {
    }

    public static ExecutionBuilder of() {
        return new ExecutionBuilder();
    }

    public static ExecutionBuilder fromExecutor(IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        ExecutionBuilder builder = ExecutionBuilder.of();
        builder.withFilename(pipeline.getPipelineMeta().getFilename()).withName(pipeline.getPipelineMeta().getName()).withId(pipeline.getLogChannelId()).withParentId(pipeline.getParent() == null ? null : pipeline.getParent().getLogChannelId()).withExecutorType(ExecutionType.Pipeline).withExecutorXml(pipeline.getPipelineMeta().getXml(pipeline)).withMetadataJson(new SerializableMetadataProvider(pipeline.getMetadataProvider()).toJson()).withRunConfigurationName(pipeline.getPipelineRunConfiguration().getName()).withLogLevel(pipeline.getLogLevel()).withExecutionStartDate(pipeline.getExecutionStartDate());
        builder.environmentDetails.put(Execution.EnvironmentDetailType.ContainerId.name(), pipeline.getContainerId());
        builder.getVariableInformation(pipeline);
        builder.getParameterInformation(pipeline);
        builder.updateRuntimeInformation();
        return builder;
    }

    public static ExecutionBuilder fromExecutor(IWorkflowEngine<WorkflowMeta> workflow) throws HopException {
        ExecutionBuilder builder = ExecutionBuilder.of().withFilename(workflow.getWorkflowMeta().getFilename()).withName(workflow.getWorkflowMeta().getName()).withId(workflow.getLogChannelId()).withParentId(workflow.getParent() == null ? null : workflow.getParent().getLogChannelId()).withExecutorType(ExecutionType.Workflow).withExecutorXml(workflow.getWorkflowMeta().getXml(workflow)).withMetadataJson(new SerializableMetadataProvider(workflow.getMetadataProvider()).toJson()).withRunConfigurationName(workflow.getWorkflowRunConfiguration().getName()).withLogLevel(workflow.getLogLevel()).withExecutionStartDate(workflow.getExecutionStartDate());
        builder.environmentDetails.put(Execution.EnvironmentDetailType.ContainerId.name(), workflow.getContainerId());
        builder.getVariableInformation(workflow);
        builder.getParameterInformation(workflow);
        builder.updateRuntimeInformation();
        return builder;
    }

    public static ExecutionBuilder fromTransform(IPipelineEngine<PipelineMeta> pipeline, ITransform transform) {
        return ExecutionBuilder.of().withFilename(null).withName(transform.getTransformName()).withCopyNr(Integer.toString(transform.getCopyNr())).withId(transform.getLogChannelId()).withParentId(pipeline.getLogChannelId()).withExecutorType(ExecutionType.Transform).withExecutorXml(null).withMetadataJson(null).withRunConfigurationName(null).withLogLevel(transform.getLogLevel()).withExecutionStartDate(pipeline.getExecutionStartDate());
    }

    public static ExecutionBuilder fromAction(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionMeta, IAction action, Date startDate) {
        return ExecutionBuilder.of().withFilename(null).withName(actionMeta.getName()).withId(action.getLogChannel().getLogChannelId()).withParentId(workflow.getLogChannelId()).withExecutorType(ExecutionType.Action).withExecutorXml(null).withMetadataJson(null).withRunConfigurationName(null).withLogLevel(action.getLogChannel().getLogLevel()).withExecutionStartDate(startDate);
    }

    private void getVariableInformation(IVariables variables) {
        for (String variableName : variables.getVariableNames()) {
            String variableValue = variables.getVariable(variableName);
            this.variableValues.put(variableName, variableValue);
        }
    }

    private void getParameterInformation(INamedParameters parameters) throws UnknownParamException {
        for (String parameterName : parameters.listParameters()) {
            String parameterValue = parameters.getParameterValue(parameterName);
            this.parameterValues.put(parameterName, parameterValue);
        }
    }

    public ExecutionBuilder updateRuntimeInformation() {
        Runtime runtime = Runtime.getRuntime();
        this.environmentDetails.put(Execution.EnvironmentDetailType.MaxMemory.name(), Long.toString(runtime.maxMemory()));
        this.environmentDetails.put(Execution.EnvironmentDetailType.FreeMemory.name(), Long.toString(runtime.freeMemory()));
        this.environmentDetails.put(Execution.EnvironmentDetailType.TotalMemory.name(), Long.toString(runtime.totalMemory()));
        this.environmentDetails.put(Execution.EnvironmentDetailType.AvailableProcessors.name(), Integer.toString(runtime.availableProcessors()));
        this.environmentDetails.put(Execution.EnvironmentDetailType.JavaVersion.name(), System.getProperty("java.version"));
        this.environmentDetails.put(Execution.EnvironmentDetailType.JavaUser.name(), System.getProperty("user.name"));
        try {
            this.environmentDetails.put(Execution.EnvironmentDetailType.HostName.name(), InetAddress.getLocalHost().getHostName());
            this.environmentDetails.put(Execution.EnvironmentDetailType.HostAddress.name(), InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            this.environmentDetails.put(Execution.EnvironmentDetailType.HostName.name(), "<unknown>");
            this.environmentDetails.put(Execution.EnvironmentDetailType.HostAddress.name(), "<unknown>");
        }
        return this;
    }

    public ExecutionBuilder withName(String name) {
        assert (name != null) : "the registration of an execution needs to have a name";
        this.name = name;
        return this;
    }

    public ExecutionBuilder withCopyNr(String copyNr) {
        this.copyNr = copyNr;
        return this;
    }

    public ExecutionBuilder withFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public ExecutionBuilder withId(String id) {
        assert (id != null) : "the registration of an execution needs to have a unique ID";
        this.id = id;
        return this;
    }

    public ExecutionBuilder withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public ExecutionBuilder withExecutorType(ExecutionType executionType) {
        assert (executionType != null) : "Please specify execution type Pipeline or Workflow, not null";
        assert (executionType == ExecutionType.Pipeline || executionType == ExecutionType.Workflow) : "Please specify execution type Pipeline or Workflow";
        this.executionType = executionType;
        return this;
    }

    public ExecutionBuilder withExecutorXml(String executorXml) {
        this.executorXml = executorXml;
        return this;
    }

    public ExecutionBuilder withMetadataJson(String metadataJson) {
        this.metadataJson = metadataJson;
        return this;
    }

    public ExecutionBuilder withVariableValues(Map<String, String> variableValues) {
        this.variableValues = variableValues;
        return this;
    }

    public ExecutionBuilder withRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
        return this;
    }

    public ExecutionBuilder withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public ExecutionBuilder withParameterValues(Map<String, String> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public ExecutionBuilder withEnvironmentDetails(Map<String, String> environmentDetails) {
        this.environmentDetails = environmentDetails;
        return this;
    }

    public ExecutionBuilder withRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    public ExecutionBuilder withExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
        return this;
    }

    public Execution build() {
        Execution executionRegistration = new Execution();
        executionRegistration.setName(this.name);
        executionRegistration.setCopyNr(this.copyNr);
        executionRegistration.setFilename(this.filename);
        executionRegistration.setId(this.id);
        executionRegistration.setParentId(this.parentId);
        executionRegistration.setExecutionType(this.executionType);
        executionRegistration.setExecutorXml(this.executorXml);
        executionRegistration.setMetadataJson(this.metadataJson);
        executionRegistration.setVariableValues(this.variableValues);
        executionRegistration.setRunConfigurationName(this.runConfigurationName);
        executionRegistration.setLogLevel(this.logLevel);
        executionRegistration.setParameterValues(this.parameterValues);
        executionRegistration.setEnvironmentDetails(this.environmentDetails);
        executionRegistration.setRegistrationDate(this.registrationDate);
        executionRegistration.setExecutionStartDate(this.executionStartDate);
        return executionRegistration;
    }
}

