/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.encryption;

import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.eclipse.jetty.util.security.Password;

public class HopEncrypt {
    public static void main(String[] args) throws HopException {
        HopEnvironment.init();
        if (args.length != 2) {
            HopEncrypt.printOptions();
            System.exit(9);
        }
        String option = args[0];
        String password = args[1];
        if (Const.trim((String)option).substring(1).equalsIgnoreCase("hop")) {
            try {
                String obfuscated = Encr.encryptPasswordIfNotUsingVariables((String)password);
                System.out.println(obfuscated);
                System.exit(0);
            }
            catch (Exception ex) {
                System.err.println("Error encrypting password");
                ex.printStackTrace();
                System.exit(2);
            }
        } else if (Const.trim((String)option).substring(1).equalsIgnoreCase("server")) {
            String obfuscated = Password.obfuscate((String)password);
            System.out.println(obfuscated);
            System.exit(0);
        } else {
            System.err.println("Unknown option '" + option + "'\n");
            HopEncrypt.printOptions();
            System.exit(1);
        }
    }

    private static void printOptions() {
        System.err.println("hop-encrypt usage:\n");
        System.err.println("  encr <-hop|-server> <password>");
        System.err.println("  Options:");
        System.err.println("    -hop: generate an obfuscated or encrypted password");
        System.err.println("    -server : generate an obfuscated password to include in the hop-server password file 'pwd/hop.pwd'");
        System.err.println("\nThis command line tool obfuscates or encrypts a plain text password for use in XML, password or metadata files.");
        System.err.println("Make sure to also copy the password encryption prefix to indicate the obfuscated nature of the password.");
        System.err.println("Hop will then be able to make the distinction between regular plain text passwords and obfuscated ones.");
        System.err.println();
    }
}

